/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.mixin.entity;

import games.enchanted.blockplaceparticles.particle_spawning.SpawnParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemFrame.class})
public abstract class ItemFrameMixin
extends HangingEntity {
    @Shadow
    protected abstract boolean shouldDamageDropItem(DamageSource var1);

    @Shadow
    public abstract ItemStack getItem();

    protected ItemFrameMixin(EntityType<? extends HangingEntity> p_31703_, Level p_31704_) {
        super(p_31703_, p_31704_);
    }

    @Inject(at={@At(value="RETURN")}, method={"hurtClient"})
    private void spawnParticlesOnDamage(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        Level level = this.level();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        boolean wasHurtSuccessfully = (Boolean)cir.getReturnValue();
        if (!wasHurtSuccessfully) {
            return;
        }
        SpawnParticles.spawnItemFrameInteractionParticles(clientLevel, this.getX(), this.getY(), this.getZ(), this.getBoundingBox(), this.direction, this.shouldDamageDropItem(damageSource) ? SpawnParticles.ItemFrameParticleOrigin.HELD_ITEM_REMOVED : SpawnParticles.ItemFrameParticleOrigin.FRAME_KILLED, this instanceof GlowItemFrame);
    }

    @Inject(at={@At(value="RETURN")}, method={"interact"})
    private void spawnParticlesOnInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Level level = this.level();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        InteractionResult interactionResult = (InteractionResult)cir.getReturnValue();
        if (interactionResult != InteractionResult.SUCCESS) {
            return;
        }
        SpawnParticles.spawnItemFrameInteractionParticles(clientLevel, this.getX(), this.getY(), this.getZ(), this.getBoundingBox(), this.direction, this.getItem().isEmpty() ? SpawnParticles.ItemFrameParticleOrigin.ITEM_PLACED : SpawnParticles.ItemFrameParticleOrigin.ITEM_ROTATED, this instanceof GlowItemFrame);
    }
}

