/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.mixin.items;

import games.enchanted.blockplaceparticles.ParticleInteractionsLogging;
import games.enchanted.blockplaceparticles.particle_spawning.SpawnParticles;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxeItem.class})
public abstract class AxeItemNeoForge {
    @Shadow
    protected abstract Optional<BlockState> getStripped(BlockState var1);

    @Inject(method={"useOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/AxeItem;evaluateNewBlockState(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/item/context/UseOnContext;)Ljava/util/Optional;")})
    private void spawnParticleOnAxeStrip(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        BlockPos blockPos;
        Level level = context.getLevel();
        BlockState unstrippedBlockstate = level.getBlockState(blockPos = context.getClickedPos());
        Optional<BlockState> strippedBlockState = this.getStripped(unstrippedBlockstate);
        if (strippedBlockState.isPresent() && level.isClientSide()) {
            ParticleInteractionsLogging.interactionDebugInfo("Axe used (" + String.valueOf(this) + ") at " + blockPos.toShortString() + " to strip " + String.valueOf(unstrippedBlockstate.getBlock()), new Object[0]);
            SpawnParticles.spawnAxeStripParticle(level, blockPos, unstrippedBlockstate, strippedBlockState.get(), context);
        }
    }
}

