/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.mixin.particles;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import games.enchanted.blockplaceparticles.particle_override.BlockParticleOverride;
import games.enchanted.blockplaceparticles.particle_spawning.SpawnParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ParticleEngine.class}, priority=3000)
public abstract class ParticleEngineMixin
implements PreparableReloadListener {
    @Shadow
    protected ClientLevel level;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;")}, method={"destroy"})
    public void useParticleInteractionsDestroyParticleLogic(BlockPos brokenBlockPos, BlockState brokenBlockState, CallbackInfo ci) {
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(brokenBlockState, 2);
        SpawnParticles.spawnBlockBreakParticle(this.level, brokenBlockState, brokenBlockPos, particleOverride);
    }

    @WrapOperation(method={"destroy"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/shapes/VoxelShape;forAllBoxes(Lnet/minecraft/world/phys/shapes/Shapes$DoubleLineConsumer;)V")})
    public void skipSpawningVanillaDestroyParticles(VoxelShape instance, Shapes.DoubleLineConsumer action, Operation<Void> original) {
    }

    @WrapOperation(method={"createParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/particle/ParticleEngine;makeParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)Lnet/minecraft/client/particle/Particle;")})
    private <T extends ParticleOptions> Particle overrideParticleTypeConditionally(ParticleEngine instance, T originalParticleOption, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Particle> original) {
        if (originalParticleOption.getType() == ParticleTypes.ITEM) {
            if (!(originalParticleOption instanceof ItemParticleOption)) {
                return (Particle)original.call(new Object[]{instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed});
            }
            Item originalParticleItem = ((ItemParticleOption)originalParticleOption).getItem().getItem();
            if (!(originalParticleItem instanceof BlockItem)) {
                return (Particle)original.call(new Object[]{instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed});
            }
            int overrideOrigin = 4;
            BlockState originalParticleBlockState = ((BlockItem)originalParticleItem).getBlock().defaultBlockState();
            BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(originalParticleBlockState, overrideOrigin);
            if (particleOverride == BlockParticleOverride.VANILLA || particleOverride == BlockParticleOverride.NONE) {
                return (Particle)original.call(new Object[]{instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed});
            }
            ParticleOptions newParticleOption = particleOverride.getParticleOptionForState(originalParticleBlockState, this.level, BlockPos.containing((double)x, (double)y, (double)z), overrideOrigin);
            return (Particle)original.call(new Object[]{instance, newParticleOption, x, y, z, xSpeed * (Math.random() * 0.75 + 0.6) * (double)particleOverride.getParticleVelocityMultiplier(), (ySpeed + 0.6) * (Math.random() * 0.75 + 0.6) * (double)particleOverride.getParticleVelocityMultiplier(), zSpeed * (Math.random() * 0.75 + 0.6) * (double)particleOverride.getParticleVelocityMultiplier()});
        }
        if (originalParticleOption.getType() != ParticleTypes.BLOCK && originalParticleOption.getType() != ParticleTypes.DUST_PILLAR && originalParticleOption.getType() != ParticleTypes.BLOCK_CRUMBLE) {
            return (Particle)original.call(new Object[]{instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed});
        }
        if (!(originalParticleOption instanceof BlockParticleOption)) {
            return (Particle)original.call(new Object[]{instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed});
        }
        int overrideOrigin = 3;
        BlockState originalParticleBlockState = ((BlockParticleOption)originalParticleOption).getState();
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(originalParticleBlockState, overrideOrigin);
        if (particleOverride == BlockParticleOverride.VANILLA || particleOverride == BlockParticleOverride.NONE) {
            return (Particle)original.call(new Object[]{instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed});
        }
        ParticleOptions newParticleOption = particleOverride.getParticleOptionForState(originalParticleBlockState, this.level, BlockPos.containing((double)x, (double)y, (double)z), overrideOrigin);
        boolean isDustPillarParticle = originalParticleOption.getType() == ParticleTypes.DUST_PILLAR;
        double newYSpeed = ySpeed * (double)particleOverride.getParticleVelocityMultiplier() * 0.5 + (ySpeed < 0.02 ? 0.08 : 0.0);
        return (Particle)original.call(new Object[]{instance, newParticleOption, x, y, z, xSpeed * (Math.random() * 0.75 + 0.6) * (double)particleOverride.getParticleVelocityMultiplier(), isDustPillarParticle ? ySpeed * 2.0 + 0.45 : newYSpeed, zSpeed * (Math.random() * 0.75 + 0.6) * (double)particleOverride.getParticleVelocityMultiplier()});
    }

    @Inject(method={"crack(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/particle/ParticleEngine;add(Lnet/minecraft/client/particle/Particle;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    public void replaceCrackingParticlesConditionally(BlockPos blockPos, Direction side, CallbackInfo ci, @Local(ordinal=0) double xPos, @Local(ordinal=1) double yPos, @Local(ordinal=2) double zPos) {
        int overrideOrigin;
        BlockState blockstate = this.level.getBlockState(blockPos);
        BlockParticleOverride override = BlockParticleOverride.getOverrideForBlockState(blockstate, overrideOrigin = 6);
        if (override == BlockParticleOverride.VANILLA) {
            return;
        }
        if (override != BlockParticleOverride.NONE) {
            ParticleOptions newParticleOption = override.getParticleOptionForState(blockstate, this.level, blockPos, overrideOrigin);
            if (newParticleOption == null) {
                return;
            }
            this.level.addParticle(newParticleOption, xPos, yPos, zPos, 0.0, 0.0, 0.0);
        }
        ci.cancel();
    }
}

