/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import games.enchanted.blockplaceparticles.particle.BouncyParticle;
import games.enchanted.blockplaceparticles.shapes.QuadFaceShape;
import games.enchanted.blockplaceparticles.shapes.ShapeDefinitions;
import games.enchanted.blockplaceparticles.util.ColourUtil;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class StretchyBouncyShapeParticle
extends BouncyParticle {
    protected double prevPrevX;
    protected double prevPrevY;
    protected double prevPrevZ;
    private QuadFaceShape particleShape;
    protected Vector3f particleShapeScale;
    protected float prevPitch;
    protected float prevYaw;

    protected StretchyBouncyShapeParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.prevPrevX = this.xo;
        this.prevPrevY = this.yo;
        this.prevPrevZ = this.zo;
        this.speedUpWhenYMotionIsBlocked = true;
        this.particleShapeScale = new Vector3f(1.0f);
        this.setShape(ShapeDefinitions.CUBE);
    }

    @Override
    public void tick() {
        this.prevPrevX = this.xo;
        this.prevPrevY = this.yo;
        this.prevPrevZ = this.zo;
        super.tick();
    }

    protected void setShape(QuadFaceShape newShape) {
        this.particleShape = newShape;
    }

    protected boolean isParticleMoving() {
        return (double)this.getTotalVelocity() < 0.001;
    }

    @NotNull
    public SingleQuadParticle.FacingCameraMode getFacingCameraMode() {
        return (quaternionf, camera, d) -> quaternionf.set(0.0f, 0.0f, 0.0f, camera.rotation().w);
    }

    protected void renderRotatedQuad(@NotNull VertexConsumer consumer, @NotNull Camera camera, @NotNull Quaternionf quaternionf, float d) {
        Vector3f cameraPosition = camera.getPosition().toVector3f();
        float xPos = (float)Mth.lerp((double)d, (double)this.xo, (double)this.x);
        float yPos = (float)Mth.lerp((double)d, (double)this.yo, (double)this.y);
        float zPos = (float)Mth.lerp((double)d, (double)this.zo, (double)this.z);
        Vector3f pos = new Vector3f(xPos, yPos, zPos).sub((Vector3fc)cameraPosition);
        float prevXPos = (float)Mth.lerp((double)d, (double)this.prevPrevX, (double)this.xo);
        float prevYPos = (float)Mth.lerp((double)d, (double)this.prevPrevY, (double)this.yo);
        float prevZPos = (float)Mth.lerp((double)d, (double)this.prevPrevZ, (double)this.zo);
        Vector3f prevPos = new Vector3f(prevXPos, prevYPos, prevZPos).sub((Vector3fc)cameraPosition);
        this.renderCubeGeometry(consumer, pos, prevPos, d);
    }

    private void renderCubeGeometry(@NotNull VertexConsumer consumer, Vector3f pos, Vector3f prevPos, float d) {
        float cuboidSize = this.getQuadSize(d);
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int lightColor = this.getLightColor(d);
        Vector3f normalisedMovementDir = new Vector3f((Vector3fc)pos).sub((Vector3fc)prevPos).normalize();
        float pitch = (float)Math.toDegrees(Math.asin(normalisedMovementDir.y));
        if (!Float.isFinite(pitch)) {
            pitch = this.prevPitch;
        }
        this.prevPitch = pitch;
        float yaw = (float)Math.toDegrees(Math.atan2(normalisedMovementDir.x, normalisedMovementDir.z));
        if (!Float.isFinite(yaw)) {
            yaw = this.prevYaw;
        }
        this.prevYaw = yaw;
        Vector3f shapePos = MathHelpers.getPosBetween3DPoints(pos, prevPos);
        Vector3f shapeScale = new Vector3f(1.0f, Math.max(Math.abs(MathHelpers.getDistanceBetweenVectors(pos, prevPos) * 40.0f), 1.0f), 1.0f).mul((Vector3fc)this.particleShapeScale);
        Vector3f shapeRotation = new Vector3f(-(pitch - 90.0f), yaw, 0.0f);
        this.particleShape.renderShapeWithRotation(consumer, new Vector2f[]{new Vector2f(u0, v0), new Vector2f(u1, v1)}, shapePos, shapeScale, shapeRotation, cuboidSize, lightColor, ColourUtil.ARGBfloats_to_ARGB(this.alpha, this.rCol, this.gCol, this.bCol));
    }
}

