/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.bubble;

import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnderwaterRisingBubble
extends TextureSheetParticle {
    protected UnderwaterRisingBubble(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.setSprite(spriteSet.get(this.random));
        this.gravity = -0.35f;
        this.friction = 0.85f;
        this.setSize(0.02f, 0.02f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
        this.xd = xSpeed * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.yd = ySpeed * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.zd = zSpeed * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.lifetime = MathHelpers.randomBetween(100, 600);
    }

    public void tick() {
        super.tick();
        if (this.age > 1 && !this.removed && !this.level.getFluidState(BlockPos.containing((double)this.x, (double)(this.y + 0.125), (double)this.z)).is(FluidTags.WATER)) {
            this.popAndRemove();
        } else if (this.age >= this.lifetime - 1) {
            this.popAndRemove();
        }
        this.xd *= 0.9;
        this.zd *= 0.9;
    }

    private void popAndRemove() {
        this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, this.x, this.y, this.z, 0.0, 0.0, 0.0);
        this.remove();
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class SmallProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public SmallProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            UnderwaterRisingBubble particle = new UnderwaterRisingBubble(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            particle.quadSize = MathHelpers.randomBetween(0.02f, 0.05f);
            return particle;
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new UnderwaterRisingBubble(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

