/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.dust;

import games.enchanted.blockplaceparticles.config.ConfigHandler;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDust
extends TextureSheetParticle {
    public static float MIN_SIZE = 0.095f;
    public static float MAX_SIZE = 0.125f;
    protected boolean spawnSpecks;
    protected boolean spriteFromAge;
    protected SpriteSet spriteSet;
    protected boolean emissive;

    protected AbstractDust(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet, float gravityMultiplier, boolean spawnSpecks) {
        super(level, x, y, z);
        float particleSize;
        this.spawnSpecks = spawnSpecks;
        this.spriteSet = spriteSet;
        this.spriteFromAge = spawnSpecks;
        this.gravity = Mth.randomBetween((RandomSource)this.random, (float)0.25f, (float)0.38f);
        this.friction = 1.0f;
        this.xd = xSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.yd = ySpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.zd = zSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.lifetime = (int)(16.0 / ((double)this.random.nextFloat() * 0.8 + 0.2)) + 2;
        this.oRoll = this.roll = (float)Math.toRadians(this.random.nextIntBetweenInclusive(0, 360));
        this.quadSize = particleSize = this.random.nextBoolean() ? MIN_SIZE : MAX_SIZE;
        this.setSize(particleSize, particleSize);
        this.gravity *= gravityMultiplier;
        if (this.spriteFromAge) {
            this.setSpriteFromAge(this.spriteSet);
        } else {
            this.setSprite(spriteSet.get(this.random));
        }
        this.emissive = false;
    }

    public void tick() {
        if (this.spriteFromAge) {
            this.setSpriteFromAge(this.spriteSet);
        }
        this.xd *= (double)0.95f;
        this.yd *= (double)0.9f;
        this.zd *= (double)0.95f;
        this.gravity = 0.98f * this.gravity;
        this.friction = 0.995f * this.friction;
        super.tick();
        if (!this.spawnSpecks || this.removed || !this.hasPhysics || this.onGround) {
            return;
        }
        if (!ConfigHandler.particle_dust_additionalSpecks) {
            return;
        }
        if (this.age < 3 && this.random.nextFloat() < 0.23f || this.random.nextFloat() < 0.01f) {
            this.level.addParticle(this.getSpeckParticle(), this.x, this.y, this.z, this.xd / 2.0, this.yd / 2.0 + 0.05, this.zd / 2.0);
        }
    }

    protected int getLightColor(float partialTick) {
        return this.emissive ? 0xF000F0 : super.getLightColor(partialTick);
    }

    @NotNull
    protected abstract ParticleOptions getSpeckParticle();

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }
}

