/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.dust;

import games.enchanted.blockplaceparticles.particle.ModParticleTypes;
import games.enchanted.blockplaceparticles.particle.dust.AbstractDust;
import games.enchanted.blockplaceparticles.util.ColourUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatingColouredDust
extends AbstractDust {
    protected final BlockState dustBlockState;

    protected FloatingColouredDust(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, BlockPos blockPos, BlockState blockState, SpriteSet spriteSet, float gravityMultiplier, boolean spawnSpecks) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, gravityMultiplier, spawnSpecks);
        this.dustBlockState = blockState;
        int tintColour = Minecraft.getInstance().getBlockColors().getColor(blockState, (BlockAndTintGetter)level, blockPos, 0);
        if (tintColour == 0xFFFFFF || tintColour == -1) {
            int[] averageBlockColour = ColourUtil.getRandomBlockColour(blockState);
            this.rCol = (float)averageBlockColour[1] / 255.0f;
            this.gCol = (float)averageBlockColour[2] / 255.0f;
            this.bCol = (float)averageBlockColour[3] / 255.0f;
            this.alpha = (float)averageBlockColour[0] / 255.0f;
        } else {
            this.rCol = (float)(tintColour >> 16 & 0xFF) / 255.0f * 0.75f;
            this.gCol = (float)(tintColour >> 8 & 0xFF) / 255.0f * 0.75f;
            this.bCol = (float)(tintColour & 0xFF) / 255.0f * 0.75f;
        }
    }

    @Override
    @NotNull
    public ParticleOptions getSpeckParticle() {
        return new BlockParticleOption(ModParticleTypes.TINTED_DUST_SPECK, this.dustBlockState);
    }

    @Override
    @NotNull
    public ParticleRenderType getRenderType() {
        if ((double)this.alpha < 0.99) {
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }
        return super.getRenderType();
    }

    public static class TintedDustSpeckProvider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet spriteSet;

        public TintedDustSpeckProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull BlockParticleOption type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FloatingColouredDust(level, x, y, z, xSpeed, ySpeed, zSpeed, BlockPos.containing((double)x, (double)y, (double)z), type.getState(), this.spriteSet, 0.35f, false);
        }
    }

    public static class TintedDustProvider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet spriteSet;

        public TintedDustProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull BlockParticleOption type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FloatingColouredDust(level, x, y, z, xSpeed, ySpeed, zSpeed, BlockPos.containing((double)x, (double)y, (double)z), type.getState(), this.spriteSet, 0.7f, true);
        }
    }
}

