/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.emitter;

import com.mojang.blaze3d.vertex.VertexConsumer;
import games.enchanted.blockplaceparticles.config.ConfigHandler;
import games.enchanted.blockplaceparticles.particle.option.ParticleEmitterOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public abstract class AbstractParticleEmitter
extends Particle {
    protected double emittedXSpeed;
    protected double emittedYSpeed;
    protected double emittedZSpeed;
    protected int emitterInterval;
    protected int emitterIterations;
    protected int particlesPerEmission;
    protected float emitterWidth;
    protected float emitterHeight;
    protected float emitterDepth;
    protected Vector3f emitterVariance;
    protected boolean emitOnFirstTick;

    protected AbstractParticleEmitter(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ParticleEmitterOptions emitterOptions) {
        super(level, x, y, z);
        this.emittedXSpeed = xSpeed;
        this.emittedYSpeed = ySpeed;
        this.emittedZSpeed = zSpeed;
        this.emitterInterval = emitterOptions.getTickInterval();
        this.emitterIterations = emitterOptions.getTickIterations();
        this.particlesPerEmission = emitterOptions.getParticlesPerEmission();
        Vector3f emitterDim = emitterOptions.getDimensions();
        this.emitterWidth = emitterDim.x();
        this.emitterHeight = emitterDim.y();
        this.emitterDepth = emitterDim.z();
        this.emitOnFirstTick = emitterOptions.getEmitOnFirstTick();
        this.emitterVariance = emitterOptions.getVelocityVariance();
        this.setLifetime(this.emitterInterval * this.emitterIterations);
        this.x -= (double)(this.emitterWidth / 2.0f);
        this.y -= (double)(this.emitterHeight / 2.0f);
        this.z -= (double)(this.emitterDepth / 2.0f);
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        if (ConfigHandler.debug_showEmitterBounds) {
            this.level.addParticle((ParticleOptions)new DustParticleOptions(-65536, 0.5f), this.x, this.y, this.z, 0.0, 0.0, 0.0);
            this.level.addParticle((ParticleOptions)new DustParticleOptions(-16711936, 0.5f), this.x + (double)this.emitterWidth, this.y + (double)this.emitterHeight, this.z + (double)this.emitterDepth, 0.0, 0.0, 0.0);
        }
        if ((this.age - (this.emitOnFirstTick ? 1 : 0)) % this.emitterInterval == 0) {
            for (int i = 0; i < this.particlesPerEmission; ++i) {
                double[] emitPos = this.getRandomPositionInsideBounds();
                this.level.addParticle(this.getParticleToEmit(this.level, emitPos[0], emitPos[1], emitPos[2]), emitPos[0], emitPos[1], emitPos[2], this.emittedXSpeed + (double)(this.level.random.nextFloat() * this.emitterVariance.x - this.emitterVariance.x / 2.0f), this.emittedYSpeed + (double)(this.level.random.nextFloat() * this.emitterVariance.y - this.emitterVariance.y / 2.0f), this.emittedZSpeed + (double)(this.level.random.nextFloat() * this.emitterVariance.z - this.emitterVariance.z / 2.0f));
            }
        }
    }

    protected double[] getRandomPositionInsideBounds() {
        double newX = this.x + (double)(this.emitterWidth * this.level.random.nextFloat());
        double newY = this.y + (double)(this.emitterHeight * this.level.random.nextFloat());
        double newZ = this.z + (double)(this.emitterDepth * this.level.random.nextFloat());
        return new double[]{newX, newY, newZ};
    }

    protected abstract ParticleOptions getParticleToEmit(ClientLevel var1, double var2, double var4, double var6);

    public void render(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float v) {
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.NO_RENDER;
    }
}

