/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.option;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ParticleEmitterOptions
implements ParticleOptions {
    private final ParticleType<ParticleEmitterOptions> type;
    private final int tickIterations;
    private final int tickInterval;
    private final int particlesPerEmission;
    private final boolean emitOnFirstTick;
    private final Vector3f dimensions;
    private final Vector3f velocityVariance;

    public ParticleEmitterOptions(ParticleType<ParticleEmitterOptions> type, int tickIterations, int tickInvertal, int particlesPerEmission, boolean emitOnFirstTick, Vector3f dimensions, Vector3f velocityVariance) {
        this.type = type;
        this.tickIterations = tickIterations;
        this.tickInterval = tickInvertal;
        this.particlesPerEmission = particlesPerEmission;
        this.emitOnFirstTick = emitOnFirstTick;
        this.dimensions = dimensions;
        this.velocityVariance = velocityVariance;
    }

    public ParticleEmitterOptions(ParticleType<ParticleEmitterOptions> type, int tickIterations, int tickInvertal, int particlesPerEmission) {
        this(type, tickIterations, tickInvertal, particlesPerEmission, true, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public ParticleEmitterOptions(ParticleType<ParticleEmitterOptions> type, int tickIterations, int tickInvertal, int particlesPerEmission, Vector3f dimensions) {
        this(type, tickIterations, tickInvertal, particlesPerEmission, true, dimensions, new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public ParticleEmitterOptions(ParticleType<ParticleEmitterOptions> type, int tickIterations, int tickInvertal, int particlesPerEmission, Vector3f dimensions, Vector3f velocityVariance) {
        this(type, tickIterations, tickInvertal, particlesPerEmission, true, dimensions, velocityVariance);
    }

    private static Codec<ParticleEmitterOptions> createCodec(ParticleType<ParticleEmitterOptions> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("repeat").forGetter(ParticleEmitterOptions::getTickIterations), (App)ExtraCodecs.POSITIVE_INT.fieldOf("interval").forGetter(ParticleEmitterOptions::getTickInterval), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("amount_per_emission", (Object)1).forGetter(ParticleEmitterOptions::getParticlesPerEmission), (App)Codec.BOOL.optionalFieldOf("emit_on_first_tick", (Object)true).forGetter(ParticleEmitterOptions::getEmitOnFirstTick), (App)ExtraCodecs.VECTOR3F.optionalFieldOf("dimensions", (Object)new Vector3f(0.0f, 0.0f, 0.0f)).forGetter(ParticleEmitterOptions::getDimensions), (App)ExtraCodecs.VECTOR3F.optionalFieldOf("velocity_variance", (Object)new Vector3f(0.0f, 0.0f, 0.0f)).forGetter(ParticleEmitterOptions::getVelocityVariance)).apply((Applicative)instance, (tickIterations, tickInterval, particlesPerEmission, emitOnFirstTick, dimensions, velocityVariance) -> new ParticleEmitterOptions(type, (int)tickIterations, (int)tickInterval, (int)particlesPerEmission, (boolean)emitOnFirstTick, (Vector3f)dimensions, (Vector3f)velocityVariance)));
    }

    public static MapCodec<ParticleEmitterOptions> codec(ParticleType<ParticleEmitterOptions> type) {
        return ParticleEmitterOptions.createCodec(type).fieldOf("emitter_options");
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, ParticleEmitterOptions> streamCodec(ParticleType<ParticleEmitterOptions> type) {
        return ByteBufCodecs.fromCodec(ParticleEmitterOptions.createCodec(type));
    }

    @NotNull
    public ParticleType<ParticleEmitterOptions> getType() {
        return this.type;
    }

    public int getTickIterations() {
        return this.tickIterations;
    }

    public int getTickInterval() {
        return this.tickInterval;
    }

    public int getParticlesPerEmission() {
        return this.particlesPerEmission;
    }

    public boolean getEmitOnFirstTick() {
        return this.emitOnFirstTick;
    }

    public Vector3f getDimensions() {
        return this.dimensions;
    }

    public Vector3f getVelocityVariance() {
        return this.velocityVariance;
    }
}

