/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.petal;

import games.enchanted.blockplaceparticles.duck.ParticleAccess;
import games.enchanted.blockplaceparticles.mixin.accessor.client.ParticleAccessor;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FallingPetal
extends TextureSheetParticle {
    private float rotSpeed;
    private float spinAcceleration;
    protected float maxSpinSpeed = 1.0f;
    private boolean transparency;

    protected FallingPetal(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet, float gravityMultiplier) {
        super(level, x, y, z);
        float particleSize;
        this.setSprite(spriteSet.get(this.random));
        this.gravity = Mth.randomBetween((RandomSource)this.random, (float)0.25f, (float)0.38f);
        this.friction = 1.0f;
        this.xd = xSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.yd = ySpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.zd = zSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.lifetime = (int)(16.0 / ((double)this.random.nextFloat() * 0.8 + 0.2)) + 2;
        this.spinAcceleration = (float)Math.toRadians(this.random.nextBoolean() ? -5.0 : 5.0);
        this.oRoll = this.roll = (float)Math.toRadians(this.random.nextIntBetweenInclusive(0, 360));
        this.quadSize = particleSize = this.random.nextBoolean() ? 0.07f : 0.08f;
        this.setSize(particleSize, particleSize);
        this.gravity *= gravityMultiplier;
        this.transparency = false;
        ((ParticleAccess)((Object)this)).setBypassMovementCollisionCheck(true);
    }

    protected FallingPetal(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet, float gravityMultiplier, boolean transparency) {
        this(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, gravityMultiplier);
        this.transparency = transparency;
    }

    public void tick() {
        this.rotSpeed += this.rotSpeed >= this.maxSpinSpeed ? 0.0f : this.spinAcceleration / 2.0f;
        if (this.rotSpeed > this.maxSpinSpeed) {
            this.rotSpeed = this.maxSpinSpeed;
        }
        this.oRoll = this.roll;
        if (!this.onGround && !((ParticleAccessor)((Object)this)).block_place_particle$getStoppedByCollision()) {
            this.roll += this.rotSpeed / 6.5f;
        }
        this.xd *= (double)0.95f;
        this.yd *= (double)0.9f;
        this.zd *= (double)0.95f;
        if (this.age >= 6 && ((ParticleAccess)((Object)this)).getBypassMovementCollisionCheck()) {
            ((ParticleAccess)((Object)this)).setBypassMovementCollisionCheck(false);
        }
        super.tick();
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return this.transparency ? ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT : ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class PaleOakProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public PaleOakProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingPetal particle = new FallingPetal(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 0.6f);
            float particleSize = level.random.nextBoolean() ? 0.1f : 0.15f;
            particle.quadSize = particleSize;
            particle.setSize(particleSize, particleSize);
            particle.maxSpinSpeed = 0.1f;
            particle.spinAcceleration = (float)Math.toRadians(level.random.nextBoolean() ? -1.0 : 1.0);
            return particle;
        }
    }

    public static class RandomisedSizeMoreGravityProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public RandomisedSizeMoreGravityProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingPetal particle = new FallingPetal(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 2.0f);
            float particleSize = MathHelpers.randomBetween(0.08f, 0.12f);
            particle.quadSize = particleSize;
            particle.setSize(particleSize, particleSize);
            return particle;
        }
    }

    public static class SnowflakeProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public SnowflakeProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingPetal particle = new FallingPetal(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 0.4f, true);
            float particleSize = level.random.nextBoolean() ? 0.1f : 0.12f;
            particle.quadSize = particleSize;
            particle.setSize(particleSize, particleSize);
            particle.spinAcceleration = 0.0f;
            particle.maxSpinSpeed = 0.0f;
            particle.roll = 0.0f;
            particle.oRoll = 0.0f;
            return particle;
        }
    }

    public static class GenericLeafProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public GenericLeafProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FallingPetal(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 1.0f);
        }
    }
}

