/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.shatter;

import com.mojang.blaze3d.vertex.VertexConsumer;
import games.enchanted.blockplaceparticles.particle.ModParticleRenderTypes;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import games.enchanted.blockplaceparticles.util.RenderingUtil;
import games.enchanted.blockplaceparticles.util.TextureHelpers;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class AbstractShatter
extends Particle {
    protected final float slice0X;
    protected final float slice0Y;
    protected final float slice1X;
    protected final float slice1Y;
    protected final float uvScale;
    protected final float uvOffset;
    protected final boolean inverseSlicePositions;
    protected TextureAtlasSprite sprite = TextureHelpers.getDebugSprite();

    protected AbstractShatter(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        int spriteWidth = this.sprite.contents().width();
        int randomSize = MathHelpers.randomBetween(3, 5);
        int randomSizeThird = randomSize / 3;
        this.uvOffset = (float)MathHelpers.randomBetween(0, spriteWidth - randomSize) / (float)spriteWidth;
        this.uvScale = (float)randomSize / (float)spriteWidth;
        this.slice0X = (float)MathHelpers.randomBetween(1, randomSizeThird) / (float)randomSize;
        this.slice0Y = (float)MathHelpers.randomBetween(2, randomSizeThird) / (float)randomSize;
        this.slice1X = (float)MathHelpers.randomBetween(randomSizeThird * 2 + 1, randomSize - 1) / (float)randomSize;
        this.slice1Y = (float)MathHelpers.randomBetween(randomSizeThird * 2 - 1, randomSize - 1) / (float)randomSize;
        this.inverseSlicePositions = level.random.nextBoolean();
        this.oRoll = this.roll = (float)Math.toRadians(MathHelpers.randomBetween(0, 3) * 90);
        this.setInitialVelocity(xSpeed, ySpeed, zSpeed, 0.1f);
        this.gravity = MathHelpers.randomBetween(0.75f, 0.9f);
        this.lifetime = MathHelpers.randomBetween(5, 25);
    }

    protected void setInitialVelocity(double xSpeed, double ySpeed, double zSpeed, float variance) {
        this.xd = xSpeed + (double)(this.level.random.nextFloat() * variance - variance / 2.0f);
        this.yd = ySpeed + (double)(this.level.random.nextFloat() * variance - variance / 2.0f);
        this.zd = zSpeed + (double)(this.level.random.nextFloat() * variance - variance / 2.0f);
    }

    public void tick() {
        this.xd *= (double)0.95f;
        this.yd *= (double)0.95f;
        this.zd *= (double)0.95f;
        super.tick();
    }

    protected void renderTick(float partialTicks) {
        float percentageAge = (float)this.age / (float)this.lifetime;
        if ((double)percentageAge > 0.8) {
            float finalA = 1.0f - (Mth.lerp((float)partialTicks, (float)this.age, (float)((float)this.age + 1.0f)) / (float)this.lifetime - 0.8f) * 5.0f;
            if (finalA < 0.0f) {
                this.alpha = 0.0f;
                return;
            }
            this.alpha = finalA;
        }
    }

    protected float getParticleScale(float partialTicks) {
        return this.uvScale;
    }

    protected abstract Direction getParticleFacingDirection();

    private SingleQuadParticle.FacingCameraMode getFacingMode(@Nullable Direction facingDirection) {
        Direction direction = facingDirection;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NORTH", "EAST", "SOUTH", "WEST", "UP", "DOWN"}, (Direction)direction, n)) {
            case 0: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(270.0), 0.0f));
            }
            case 1: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(180.0), 0.0f));
            }
            case 2: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(90.0), 0.0f));
            }
            case 3: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, 0.0f, 0.0f));
            }
            case 4: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(90.0), (float)Math.toRadians(90.0)));
            }
            case 5: {
                return (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)MathHelpers.eulerAnglesToQuaternion(0.0f, (float)Math.toRadians(90.0), (float)Math.toRadians(-90.0)));
            }
        }
        return SingleQuadParticle.FacingCameraMode.LOOKAT_XYZ;
    }

    public void render(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float partialTicks) {
        this.renderTick(partialTicks);
        Quaternionf quaternionf = new Quaternionf();
        this.getFacingMode(this.getParticleFacingDirection()).setRotation(quaternionf, camera, partialTicks);
        if (this.roll != 0.0f) {
            quaternionf.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
        }
        this.renderQuads(vertexConsumer, camera, quaternionf, partialTicks);
    }

    protected void renderQuads(VertexConsumer buffer, Camera camera, Quaternionf quaternion, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z());
        int lightColour = this.getLightColor(partialTicks);
        this.renderSlice0(buffer, quaternion, x, y, z, lightColour, partialTicks);
        this.renderSlice1(buffer, quaternion, x, y, z, lightColour, partialTicks);
        this.renderSlice2(buffer, quaternion, x, y, z, lightColour, partialTicks);
    }

    protected float getScaledUVCoord(float uv) {
        return uv * this.uvScale + this.uvOffset;
    }

    protected void renderSlice0(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, int lightColour, float partialTicks) {
        float scale = this.getParticleScale(partialTicks);
        float u0 = this.sprite.getU(this.getScaledUVCoord(0.0f));
        float u1 = this.sprite.getU(this.getScaledUVCoord(this.slice0X));
        float v0 = this.sprite.getV(this.getScaledUVCoord(this.inverseSlicePositions ? 1.0f - this.slice0Y : 0.0f));
        float v1 = this.sprite.getV(this.getScaledUVCoord(this.inverseSlicePositions ? 1.0f : this.slice0Y));
        this.renderVertex(buffer, quaternion, x, y, z, this.slice0X, this.inverseSlicePositions ? 0.0f : 1.0f - this.slice0Y, u1, v1, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice0X, this.inverseSlicePositions ? this.slice0Y : 1.0f, u1, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, 0.0f, this.inverseSlicePositions ? this.slice0Y : 1.0f, u0, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, 0.0f, this.inverseSlicePositions ? 0.0f : 1.0f - this.slice0Y, u0, v1, lightColour, scale);
    }

    protected void renderSlice1(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, int lightColour, float partialTicks) {
        float scale = this.getParticleScale(partialTicks);
        float u0 = this.sprite.getU(this.getScaledUVCoord(this.slice0X));
        float u1 = this.sprite.getU(this.getScaledUVCoord(this.slice1X));
        float v0 = this.sprite.getV(this.getScaledUVCoord(0.0f));
        float v1 = this.sprite.getV(this.getScaledUVCoord(1.0f));
        this.renderVertex(buffer, quaternion, x, y, z, this.slice1X, 0.0f, u1, v1, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice1X, 1.0f, u1, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice0X, 1.0f, u0, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice0X, 0.0f, u0, v1, lightColour, scale);
    }

    protected void renderSlice2(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, int lightColour, float partialTicks) {
        float scale = this.getParticleScale(partialTicks);
        float u0 = this.sprite.getU(this.getScaledUVCoord(this.slice1X));
        float u1 = this.sprite.getU(this.getScaledUVCoord(1.0f));
        float v0 = this.sprite.getV(this.getScaledUVCoord(this.inverseSlicePositions ? 0.0f : this.slice1Y));
        float v1 = this.sprite.getV(this.getScaledUVCoord(this.inverseSlicePositions ? 1.0f - this.slice1Y : 1.0f));
        this.renderVertex(buffer, quaternion, x, y, z, 1.0f, this.inverseSlicePositions ? this.slice1Y : 0.0f, u1, v1, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, 1.0f, this.inverseSlicePositions ? 1.0f : 1.0f - this.slice1Y, u1, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice1X, this.inverseSlicePositions ? 1.0f : 1.0f - this.slice1Y, u0, v0, lightColour, scale);
        this.renderVertex(buffer, quaternion, x, y, z, this.slice1X, this.inverseSlicePositions ? this.slice1Y : 0.0f, u0, v1, lightColour, scale);
    }

    protected void renderVertex(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float u, float v, int packedLight, float scale) {
        RenderingUtil.addVertexToConsumer(buffer, quaternion, x, y, z, xOffset -= 0.5f, yOffset -= 0.5f, scale, u, v, packedLight, this.rCol, this.gCol, this.bCol, this.alpha);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ModParticleRenderTypes.BACKFACE_TERRAIN_PARTICLE;
    }
}

