/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.spark;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SparkFlash
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float originalQuadSize;
    protected int prevAge;

    SparkFlash(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.speedUpWhenYMotionIsBlocked = true;
        this.friction = 0.96f;
        this.xd = xSpeed / 2.0 + (Math.random() * 3.0 - 1.5) * 0.07 * (double)((double)this.random.nextFloat() > 0.95 ? 2 : 1);
        this.yd = ySpeed / 2.0 + (Math.random() * 3.0 - 1.5) * 0.07 * (double)((double)this.random.nextFloat() > 0.95 ? 2 : 1);
        this.zd = zSpeed / 2.0 + (Math.random() * 3.0 - 1.5) * 0.07 * (double)((double)this.random.nextFloat() > 0.95 ? 2 : 1);
        this.lifetime = this.random.nextInt(4) + 3;
        this.sprites = sprites;
        this.setSpriteFromAge(sprites);
        this.originalQuadSize = this.quadSize = 0.125f;
        this.prevAge = this.age;
    }

    public void tick() {
        this.prevAge = this.age;
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public int getLightColor(float f) {
        return 240;
    }

    public void render(@NotNull VertexConsumer buffer, @NotNull Camera renderInfo, float partialTicks) {
        this.quadSize = this.originalQuadSize * (0.5f + Math.abs(1.0f - Mth.lerp((float)partialTicks, (float)this.prevAge, (float)this.age) / (float)this.lifetime) * 0.5f);
        super.render(buffer, renderInfo, partialTicks);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SparkFlash(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

