/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.splash;

import games.enchanted.blockplaceparticles.particle.splash.BucketSplash;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSplash
extends BucketSplash {
    private final BlockPos pos;
    private final float uo;
    private final float vo;

    protected BlockSplash(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, BlockPos blockPos, BlockState blockState) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, null);
        float particleSize;
        this.setSprite(Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(blockState));
        this.pos = blockPos;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        int tintColour = Minecraft.getInstance().getBlockColors().getColor(blockState, (BlockAndTintGetter)level, blockPos, 0);
        this.rCol *= (float)(tintColour >> 16 & 0xFF) / 255.0f;
        this.gCol *= (float)(tintColour >> 8 & 0xFF) / 255.0f;
        this.bCol *= (float)(tintColour & 0xFF) / 255.0f;
        this.quadSize = particleSize = 0.1255f - (this.random.nextBoolean() ? 0.01f : 0.02f);
        this.setSize(particleSize, particleSize);
    }

    @Override
    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f);
    }

    public int getLightColor(float f) {
        int lightColour = super.getLightColor(f);
        return lightColour == 0 && this.level.hasChunkAt(this.pos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)this.pos) : lightColour;
    }

    public static class Provider
    implements ParticleProvider<BlockParticleOption> {
        public Provider(SpriteSet spriteSet) {
        }

        @Nullable
        public Particle createParticle(BlockParticleOption type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new BlockSplash(level, x, y, z, xSpeed, ySpeed, zSpeed, BlockPos.containing((double)x, (double)y, (double)z), type.getState());
        }
    }
}

