/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.splash;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BucketSplash
extends TextureSheetParticle {
    protected BucketSplash(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable SpriteSet spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        float particleSize;
        if (spriteSet != null) {
            this.setSprite(spriteSet.get(this.random.nextInt(12), 12));
        }
        this.gravity = 0.95f;
        this.friction = 0.999f;
        this.xd = xSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.yd = ySpeed + (Math.random() - 0.5) * (double)(this.random.nextFloat() * 0.5f - 0.3f);
        this.zd = zSpeed + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.quadSize = particleSize = 0.1355f - (this.random.nextBoolean() ? 0.01f : 0.0f);
        this.setSize(particleSize, particleSize);
    }

    public void tick() {
        super.tick();
        if (!this.removed && this.onGround && this.random.nextFloat() > 0.9f) {
            this.randomOnParticleLand();
        }
    }

    public void randomOnParticleLand() {
        this.remove();
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new BucketSplash(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

