/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.swirling;

import games.enchanted.blockplaceparticles.duck.ParticleAccess;
import games.enchanted.blockplaceparticles.particle.swirling.SwirlingParticle;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ember
extends SwirlingParticle {
    protected Ember(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet, boolean shouldSwirl) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, shouldSwirl);
        this.setInitialVelocity(xSpeed, ySpeed, zSpeed, 0.015f);
        this.gravity = MathHelpers.randomBetween(-0.03f, -0.08f);
        this.lifetime = MathHelpers.randomBetween(20, 100);
        this.rotSpeed = 0.0f;
        this.spinAcceleration = 0.0f;
        this.swirlStrength = MathHelpers.randomBetween(0.7f, 0.9f) * (float)(level.random.nextBoolean() ? -1 : 1);
        this.swirlPeriod = MathHelpers.randomBetween(708, 720);
        this.quadSize = 0.078125f;
        this.setSize(0.03125f, 0.03125f);
        ((ParticleAccess)((Object)this)).setBypassMovementCollisionCheck(true);
    }

    @Override
    public void applyGravity() {
        this.yd = -this.gravity;
    }

    @Override
    protected void renderTick(float partialTicks) {
        float percentageAge = (float)this.age / (float)this.lifetime;
        if ((double)percentageAge > 0.8) {
            float finalA = 1.0f - (Mth.lerp((float)partialTicks, (float)this.age, (float)((float)this.age + 1.0f)) / (float)this.lifetime - 0.8f) * 5.0f;
            if (finalA < 0.0f) {
                this.alpha = 0.0f;
                return;
            }
            this.alpha = finalA;
        }
    }

    public int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    @Override
    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class EmberProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public EmberProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new Ember(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, true);
        }
    }
}

