/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle.swirling;

import games.enchanted.blockplaceparticles.particle.swirling.SwirlingParticle;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterVapour
extends SwirlingParticle {
    protected final SpriteSet sprites;

    protected WaterVapour(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet, boolean shouldSwirl) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, shouldSwirl);
        this.sprites = spriteSet;
        this.setSpriteFromAge(this.sprites);
        this.setInitialVelocity(xSpeed, ySpeed, zSpeed, 0.015f);
        this.gravity = MathHelpers.randomBetween(-0.04f, -0.07f);
        this.lifetime = MathHelpers.randomBetween(4, 15);
        this.rotSpeed = 0.0f;
        this.spinAcceleration = 0.0f;
        this.swirlStrength = MathHelpers.randomBetween(3.0f, 6.0f) * (float)(level.random.nextBoolean() ? -1 : 1);
        this.swirlPeriod = MathHelpers.randomBetween(1, 4);
        this.quadSize = 0.0625f;
        this.setSize(0.03125f, 0.03125f);
    }

    @Override
    public void tick() {
        this.setSpriteFromAge(this.sprites);
        super.tick();
    }

    public static class WaterVapourProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public WaterVapourProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new WaterVapour(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, true);
        }
    }
}

