/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle_spawning;

import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ParticlePositionHelpers {
    private static final float[][][] repeaterPositions = new float[][][]{new float[][]{{0.5f, 0.5625f}, {0.5f, 0.4375f}, {0.5f, 0.3125f}, {0.5f, 0.1875f}}, new float[][]{{0.4375f, 0.5f}, {0.5625f, 0.5f}, {0.6875f, 0.5f}, {0.8125f, 0.5f}}, new float[][]{{0.5f, 0.4375f}, {0.5f, 0.5625f}, {0.5f, 0.6875f}, {0.5f, 0.8125f}}, new float[][]{{0.5625f, 0.5f}, {0.4375f, 0.5f}, {0.3125f, 0.5f}, {0.1875f, 0.5f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 0.0f}}};
    private static final float[][] comparatorPositions = new float[][]{{0.5f, 0.8125f}, {0.1875f, 0.5f}, {0.5f, 0.1875f}, {0.8125f, 0.5f}, {0.0f, 0.0f}};

    public static float[] getRedstoneRepeaterInteractionPos(BlockState repeaterState) {
        Direction repeaterDirection = (Direction)repeaterState.getValue((Property)RepeaterBlock.FACING);
        int repeaterDelay = (Integer)repeaterState.getValue((Property)RepeaterBlock.DELAY);
        int positionsIndex = switch (repeaterDirection) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 4;
        };
        float height = 0.4f;
        if (repeaterDelay - 1 < 4 && repeaterDelay - 1 >= 0) {
            float[] xyPos = repeaterPositions[positionsIndex][repeaterDelay - 1];
            return new float[]{xyPos[0], 0.4f, xyPos[1]};
        }
        return new float[]{0.0f, 0.4f, 0.0f};
    }

    public static float[] getRedstoneComparatorInteractionPos(BlockState comparatorState) {
        Direction comparatorDirection = (Direction)comparatorState.getValue((Property)ComparatorBlock.FACING);
        int positionsIndex = switch (comparatorDirection) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 4;
        };
        float height = 0.4f;
        float[] xyPos = comparatorPositions[positionsIndex];
        return new float[]{xyPos[0], 0.4f, xyPos[1]};
    }

    public static double[] getRandomFurnaceParticlePosition(BlockPos blockPos, BlockState furnaceState) {
        Direction direction = (Direction)furnaceState.getValue((Property)AbstractFurnaceBlock.FACING);
        Direction.Axis direction$axis = direction.getAxis();
        double baseX = (double)blockPos.getX() + 0.5;
        double baseY = blockPos.getY();
        double baseZ = (double)blockPos.getZ() + 0.5;
        double outwardOffset = 0.52;
        double randomOffset = MathHelpers.randomBetween(-0.3f, 0.3f);
        double offsetX = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * outwardOffset : randomOffset;
        double offsetY = MathHelpers.randomBetween(0.0f, 0.375f);
        double offsetZ = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * outwardOffset : randomOffset;
        return new double[]{baseX + offsetX, baseY + offsetY, baseZ + offsetZ};
    }
}

