/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle_spawning;

import games.enchanted.blockplaceparticles.config.ConfigHandler;
import games.enchanted.blockplaceparticles.config.type.BrushParticleBehaviour;
import games.enchanted.blockplaceparticles.particle.ModParticleTypes;
import games.enchanted.blockplaceparticles.particle.option.ParticleEmitterOptions;
import games.enchanted.blockplaceparticles.particle.option.TintedParticleOption;
import games.enchanted.blockplaceparticles.particle_override.BlockParticleOverride;
import games.enchanted.blockplaceparticles.particle_override.BlockParticleOverrides;
import games.enchanted.blockplaceparticles.particle_override.FluidPlacementParticle;
import games.enchanted.blockplaceparticles.particle_spawning.ParticleCategory;
import games.enchanted.blockplaceparticles.particle_spawning.ParticlePositionHelpers;
import games.enchanted.blockplaceparticles.particle_spawning.SpawnParticlesUtil;
import games.enchanted.blockplaceparticles.registry.RegistryHelpers;
import games.enchanted.blockplaceparticles.registry.TagUtil;
import games.enchanted.blockplaceparticles.util.FluidHelpers;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SpawnParticles {
    public static void spawnBlockPlaceParticle(ClientLevel level, BlockPos blockPos) {
        BlockState placedBlockState = level.getBlockState(blockPos);
        SpawnParticles.spawnBlockPlaceParticle(level, blockPos, placedBlockState);
    }

    public static void spawnBlockPlaceParticle(ClientLevel level, BlockPos blockPos, BlockState placedBlockState) {
        int overrideOrigin;
        BlockParticleOverride particleOverride;
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.BLOCK_PLACE_OR_BREAK, blockPos)) {
            return;
        }
        if (ConfigHandler.underwaterBubbles_onPlace) {
            SpawnParticles.spawnUnderwaterBubbles(ConfigHandler.maxUnderwaterBubbles_onPlace, (Level)level, blockPos);
        }
        if ((particleOverride = BlockParticleOverride.getOverrideForBlockState(placedBlockState, overrideOrigin = 1)) == BlockParticleOverride.NONE) {
            return;
        }
        int maxParticlesPerEdge = BlockParticleOverride.getParticleMultiplierForOverride(particleOverride, true);
        if (maxParticlesPerEdge <= 0) {
            return;
        }
        double particleOutwardVelocityAdjustment = particleOverride.getParticleVelocityMultiplier();
        if (!placedBlockState.isAir() && placedBlockState.shouldSpawnTerrainParticles()) {
            VoxelShape blockShape = placedBlockState.getShape((BlockGetter)level, blockPos);
            double verticalAxisOffset = level.getBlockState(blockPos.offset(0, -1, 0)).isSolid() ? 0.01 : 0.0;
            blockShape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
                Direction.Axis biggestEdge;
                double edgeLength;
                double width = Math.abs(x1 - x2);
                double height = Math.abs(y1 - y2);
                double depth = Math.abs(z1 - z2);
                if (width > height && width > depth) {
                    edgeLength = width;
                    biggestEdge = Direction.Axis.X;
                } else if (height > width && height > depth) {
                    edgeLength = height;
                    biggestEdge = Direction.Axis.Y;
                } else {
                    edgeLength = depth;
                    biggestEdge = Direction.Axis.Z;
                }
                int amountOfParticlesAlongEdge = Mth.ceil((double)(edgeLength * (double)maxParticlesPerEdge));
                if (amountOfParticlesAlongEdge < 1) {
                    amountOfParticlesAlongEdge = 1;
                }
                for (int i = 0; i < amountOfParticlesAlongEdge; ++i) {
                    double particlePos = ((double)i + 0.5) / (double)amountOfParticlesAlongEdge;
                    if (particlePos > edgeLength + 0.0625) continue;
                    double particleXOffset = (biggestEdge == Direction.Axis.X ? particlePos : width) + x1;
                    double particleYOffset = (biggestEdge == Direction.Axis.Y ? particlePos : height) + y1 + verticalAxisOffset;
                    double particleZOffset = (biggestEdge == Direction.Axis.Z ? particlePos : depth) + z1;
                    ParticleOptions particleToSpawn = particleOverride.getParticleOptionForState(placedBlockState, level, blockPos, overrideOrigin);
                    if (particleToSpawn == null) continue;
                    level.addParticle(particleToSpawn, (double)blockPos.getX() + MathHelpers.expandWhenOutOfBound(particleXOffset, 0.0, 1.0), (double)blockPos.getY() + MathHelpers.expandWhenOutOfBound(particleYOffset, 0.0, 1.0), (double)blockPos.getZ() + MathHelpers.expandWhenOutOfBound(particleZOffset, 0.0, 1.0), (particleXOffset - 0.5) * particleOutwardVelocityAdjustment, (particleYOffset - 0.5) * particleOutwardVelocityAdjustment, (particleZOffset - 0.5) * particleOutwardVelocityAdjustment);
                }
            });
        }
    }

    public static void spawnBlockBreakParticle(ClientLevel level, BlockState brokenBlockState, BlockPos brokenBlockPos, BlockParticleOverride particleOverride) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.BLOCK_PLACE_OR_BREAK, brokenBlockPos)) {
            return;
        }
        if (ConfigHandler.underwaterBubbles_onBreak) {
            SpawnParticles.spawnUnderwaterBubbles(ConfigHandler.maxUnderwaterBubbles_onBreak, (Level)level, brokenBlockPos);
        }
        if (particleOverride == BlockParticleOverride.NONE) {
            return;
        }
        int maxParticlesPerLength = BlockParticleOverride.getParticleMultiplierForOverride(particleOverride, false);
        if (maxParticlesPerLength <= 0) {
            return;
        }
        double particleOutwardVelocityAdjustment = particleOverride.getParticleVelocityMultiplier();
        if (!brokenBlockState.isAir() && brokenBlockState.shouldSpawnTerrainParticles()) {
            VoxelShape blockShape = brokenBlockState.getShape((BlockGetter)level, brokenBlockPos);
            blockShape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
                double width = Math.abs(x1 - x2);
                int amountAlongWidth = Math.clamp((long)Mth.ceil((double)(width * (double)maxParticlesPerLength)), 1, 999);
                double height = Math.abs(y1 - y2);
                int amountAlongHeight = Math.clamp((long)Mth.ceil((double)(height * (double)maxParticlesPerLength)), 1, 999);
                double depth = Math.abs(z1 - z2);
                int amountAlongDepth = Math.clamp((long)Mth.ceil((double)(depth * (double)maxParticlesPerLength)), 1, 999);
                for (int i_W = 0; i_W < amountAlongWidth; ++i_W) {
                    for (int i_H = 0; i_H < amountAlongHeight; ++i_H) {
                        for (int i_D = 0; i_D < amountAlongDepth; ++i_D) {
                            double particleXOffset = ((double)i_W + 0.5) / (double)amountAlongWidth;
                            double particleYOffset = ((double)i_H + 0.5) / (double)amountAlongHeight;
                            double particleZOffset = ((double)i_D + 0.5) / (double)amountAlongDepth;
                            ParticleOptions particleToSpawn = particleOverride.getParticleOptionForState(brokenBlockState, level, brokenBlockPos, 2);
                            if (particleToSpawn == null) continue;
                            level.addParticle(particleToSpawn, (double)brokenBlockPos.getX() + (particleXOffset * width + x1), (double)brokenBlockPos.getY() + (particleYOffset * height + y1), (double)brokenBlockPos.getZ() + (particleZOffset * depth + z1), (particleXOffset - 0.5) * particleOutwardVelocityAdjustment, (particleYOffset - 0.5) * particleOutwardVelocityAdjustment, (particleZOffset - 0.5) * particleOutwardVelocityAdjustment);
                        }
                    }
                }
            });
        }
    }

    private static void spawnUnderwaterBubbles(int amountOfBubbles, Level level, BlockPos blockPos) {
        if (!FluidHelpers.probablyPlacedUnderwater(level, blockPos)) {
            return;
        }
        for (int i = 0; i < Math.max(amountOfBubbles + level.random.nextIntBetweenInclusive(-2, 0), 1); ++i) {
            double x = level.random.nextDouble();
            double y = level.random.nextDouble();
            double z = level.random.nextDouble();
            boolean blockAboveIsWater = level.getFluidState(blockPos.above()).is(FluidTags.WATER);
            double verticalVelocity = (y - 0.5) * (double)(blockAboveIsWater ? 2 : 0);
            double horizontalVelocityMul = !blockAboveIsWater ? 1.5 : 1.0;
            level.addParticle((ParticleOptions)ModParticleTypes.UNDERWATER_RISING_BUBBLE, (double)blockPos.getX() + x, (double)blockPos.getY() + y, (double)blockPos.getZ() + z, (x - 0.5) * 2.0 * horizontalVelocityMul, level.getBlockState(blockPos.below()).isSolid() ? Math.abs(verticalVelocity) + 0.1 : verticalVelocity, (z - 0.5) * 2.0 * horizontalVelocityMul);
        }
    }

    public static void spawnFallingBlockRandomFallParticles(ClientLevel level, BlockState blockState, double x, double y, double z, Vec3 deltaMovement) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) {
            return;
        }
        if (!ConfigHandler.fallingBlockEffect_enabled) {
            return;
        }
        if (blockState.isAir()) {
            return;
        }
        int overrideOrigin = 8;
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(blockState, overrideOrigin);
        if (particleOverride == BlockParticleOverride.NONE || particleOverride == BlockParticleOverride.VANILLA) {
            return;
        }
        for (int i = 0; i < level.random.nextIntBetweenInclusive(1, 4); ++i) {
            ParticleOptions particleOptions = particleOverride.getParticleOptionForState(blockState, level, BlockPos.containing((double)x, (double)y, (double)z), overrideOrigin);
            if (particleOptions == null) continue;
            level.addParticle(particleOptions, x - 0.5 + (double)level.random.nextFloat(), y + (double)level.random.nextFloat(), z - 0.5 + (double)level.random.nextFloat(), deltaMovement.x * 3.0 * (double)(-particleOverride.getParticleVelocityMultiplier()), deltaMovement.y * 3.0 * (double)(-particleOverride.getParticleVelocityMultiplier()), deltaMovement.z * 3.0 * (double)(-particleOverride.getParticleVelocityMultiplier()));
        }
    }

    public static void spawnFallingBlockLandParticles(ClientLevel level, BlockState blockState, double x, double y, double z, Vec3 deltaMovement) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) {
            return;
        }
        if (!ConfigHandler.fallingBlockEffect_enabled) {
            return;
        }
        int overrideOrigin = 7;
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(blockState, overrideOrigin);
        if (particleOverride == BlockParticleOverride.NONE) {
            return;
        }
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        double movementSpeed = deltaMovement.length();
        double particleY = (double)Math.round(y + deltaMovement.y / 2.0 - 0.1) + 0.0625;
        SpawnParticlesUtil.spawnParticleInCircle(particleOverride == BlockParticleOverride.VANILLA ? TintedParticleOption.BRUSH_OPTION : particleOverride.getParticleOptionForState(blockState, level, blockPos, overrideOrigin), level, new Vec3(x, particleY, z), 16, 0.4f, 0.9f, 1.7f * (float)(movementSpeed * 2.0) * (particleOverride == BlockParticleOverride.VANILLA ? 0.1f : particleOverride.getParticleVelocityMultiplier()), 0.035f, 0.0f);
        SpawnParticlesUtil.spawnParticleInCircle(particleOverride == BlockParticleOverride.VANILLA ? TintedParticleOption.BRUSH_OPTION : particleOverride.getParticleOptionForState(blockState, level, blockPos, overrideOrigin), level, new Vec3(x, particleY + (double)0.7f, z), 16, 0.3f, 0.95f, 0.2f, -0.4f * (float)(movementSpeed * 2.0) * (particleOverride == BlockParticleOverride.VANILLA ? 0.1f : particleOverride.getParticleVelocityMultiplier()), 0.0f);
    }

    public static void spawnSparksAtMinecartWheels(double minecartX, double minecartY, double minecartZ, double minecartHorizontalRot, double minecartVerticalRot, boolean isOnRails, boolean hasPassenger, boolean hasBlock, Vec3 deltaMovement, double maxSpeed, Level level) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, minecartX, minecartY, minecartZ)) {
            return;
        }
        if (!ConfigHandler.minecart_enabled) {
            return;
        }
        if (!isOnRails) {
            return;
        }
        if (!hasBlock && !hasPassenger && ConfigHandler.minecart_onlyWithPassenger) {
            return;
        }
        double speed = MathHelpers.maxVec3(deltaMovement.toVector3f(), true);
        if (speed < 0.05) {
            return;
        }
        float sparksChancePerWheel = (float)(Math.clamp(speed, 0.0, maxSpeed) / maxSpeed) - 0.75f;
        sparksChancePerWheel *= (float)ConfigHandler.minecart_spawnChance / 50.0f;
        float rotX = (float)(minecartHorizontalRot * (Math.PI / 180));
        float rotY = (float)(minecartVerticalRot * (Math.PI / 180));
        float sparkDeltaX = (float)Math.clamp(-deltaMovement.x / 3.0, -0.7, 0.7);
        float sparkDeltaZ = (float)Math.clamp(-deltaMovement.z / 3.0, -0.7, 0.7);
        minecartY += 0.0425;
        if (level.random.nextFloat() < sparksChancePerWheel) {
            Vector3f wheelPos1 = SpawnParticles.minecartWheelPoint(rotX, rotY, 0.45f, 0.35f, 0.45f);
            level.addParticle((ParticleOptions)ModParticleTypes.FLYING_SPARK, (double)wheelPos1.x + minecartX, (double)wheelPos1.y + minecartY, (double)wheelPos1.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
        if (level.random.nextFloat() < sparksChancePerWheel) {
            Vector3f wheelPos2 = SpawnParticles.minecartWheelPoint(rotX, rotY, -0.45f, -0.35f, 0.45f);
            level.addParticle((ParticleOptions)ModParticleTypes.FLYING_SPARK, (double)wheelPos2.x + minecartX, (double)wheelPos2.y + minecartY, (double)wheelPos2.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
        if (level.random.nextFloat() < sparksChancePerWheel) {
            Vector3f wheelPos3 = SpawnParticles.minecartWheelPoint(rotX, rotY, 0.45f, 0.35f, -0.45f);
            level.addParticle((ParticleOptions)ModParticleTypes.FLYING_SPARK, (double)wheelPos3.x + minecartX, (double)wheelPos3.y + minecartY, (double)wheelPos3.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
        if (level.random.nextFloat() < sparksChancePerWheel) {
            Vector3f wheelPos4 = SpawnParticles.minecartWheelPoint(rotX, rotY, -0.45f, -0.35f, -0.45f);
            level.addParticle((ParticleOptions)ModParticleTypes.FLYING_SPARK, (double)wheelPos4.x + minecartX, (double)wheelPos4.y + minecartY, (double)wheelPos4.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
    }

    private static Vector3f minecartWheelPoint(float rotationX, float rotationY, float pointX, float pointY, float pointZ) {
        return new Vector3f((float)((double)pointX * Math.cos(rotationX) - (double)pointZ * Math.sin(rotationX)), pointY * rotationY, (float)((double)pointZ * Math.cos(rotationX) + (double)pointX * Math.sin(rotationX)));
    }

    public static void spawnFlintAndSteelSparkParticle(Level level, BlockPos particlePos) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, particlePos)) {
            return;
        }
        if (!ConfigHandler.flintAndSteelSpark_onUse) {
            return;
        }
        BlockState fireOrLitBlock = level.getBlockState(particlePos);
        boolean isSoulBlock = level.getBlockState(particlePos.below()).is(BlockTags.SOUL_FIRE_BASE_BLOCKS) || fireOrLitBlock.is(Blocks.SOUL_CAMPFIRE);
        double sparkIntensity = (double)ConfigHandler.flintAndSteelSpark_intensity / 12.0;
        for (int i = 0; i < ConfigHandler.maxFlintAndSteelSpark_onUse; ++i) {
            double x = (double)particlePos.getX() + 0.25 + level.random.nextDouble() / 2.0;
            double y = (double)particlePos.getY() + 0.25 + level.random.nextDouble() / 2.0;
            double z = (double)particlePos.getZ() + 0.25 + level.random.nextDouble() / 2.0;
            level.addParticle((ParticleOptions)(isSoulBlock ? ModParticleTypes.FLYING_SOUL_SPARK : ModParticleTypes.FLYING_SPARK), x, y, z, (level.random.nextDouble() - 0.5) * sparkIntensity, (level.random.nextDouble() + 0.5) * sparkIntensity, (level.random.nextDouble() - 0.5) * sparkIntensity);
        }
    }

    public static void spawnAmbientCampfireSparks(Level level, BlockPos particlePos, BlockState campfireState) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, particlePos)) {
            return;
        }
        if (ConfigHandler.campfireSpark_enabled) {
            double sparkIntensity = 0.4166666666666667;
            if (level.random.nextFloat() * 101.0f <= (float)ConfigHandler.campfireSpark_spawnChance) {
                for (int i = 0; i < level.random.nextIntBetweenInclusive(1, 3) + 1; ++i) {
                    SpawnParticlesUtil.spawnMostlyUpwardsMotionParticleOption(level, (ParticleOptions)(campfireState.is(Blocks.SOUL_CAMPFIRE) ? ModParticleTypes.FLOATING_SOUL_SPARK : ModParticleTypes.FLOATING_SPARK), (double)particlePos.getX() + 0.5, (double)particlePos.getY() + 0.5, (double)particlePos.getZ() + 0.5, sparkIntensity);
                }
            }
        }
        if (ConfigHandler.campfireEmber_enabled && level.random.nextFloat() * 101.0f <= (float)ConfigHandler.campfireEmber_spawnChance) {
            for (int i = 0; i < level.random.nextIntBetweenInclusive(1, 4); ++i) {
                level.addParticle((ParticleOptions)(campfireState.is(Blocks.SOUL_CAMPFIRE) ? ModParticleTypes.FLOATING_SOUL_EMBER : ModParticleTypes.FLOATING_EMBER), (double)particlePos.getX() + (double)level.random.nextFloat() * 0.75 + 0.125, (double)particlePos.getY() + (double)level.random.nextFloat() * 0.75 + 0.125, (double)particlePos.getZ() + (double)level.random.nextFloat() * 0.75 + 0.125, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnAmbientFireSparks(Level level, BlockState fireState, BlockPos particlePos, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, particlePos)) {
            return;
        }
        double width = Math.abs(minX - maxX);
        double height = Math.abs(minY - maxY);
        double depth = Math.abs(minZ - maxZ);
        if (ConfigHandler.fireSpark_enabled) {
            double sparkIntensity = 0.4166666666666667;
            if (level.random.nextFloat() * 101.0f <= (float)ConfigHandler.fireSpark_spawnChance) {
                for (int i = 0; i < level.random.nextIntBetweenInclusive(1, 3) + 1; ++i) {
                    SpawnParticlesUtil.spawnMostlyUpwardsMotionParticleOption(level, (ParticleOptions)(fireState.is(Blocks.SOUL_FIRE) ? ModParticleTypes.FLOATING_SOUL_SPARK : ModParticleTypes.FLOATING_SPARK), (double)particlePos.getX() + minX + (double)level.random.nextFloat() * width, (double)particlePos.getY() + minY + (double)level.random.nextFloat() * height, (double)particlePos.getZ() + minZ + (double)level.random.nextFloat() * depth, sparkIntensity);
                }
            }
        }
        if (ConfigHandler.fireEmber_enabled && level.random.nextFloat() * 101.0f <= (float)ConfigHandler.fireEmber_spawnChance) {
            for (int i = 0; i < level.random.nextIntBetweenInclusive(1, 4); ++i) {
                level.addParticle((ParticleOptions)(fireState.is(Blocks.SOUL_FIRE) ? ModParticleTypes.FLOATING_SOUL_EMBER : ModParticleTypes.FLOATING_EMBER), (double)particlePos.getX() + minX + (double)level.random.nextFloat() * width, (double)particlePos.getY() + minY + (double)level.random.nextFloat() * height, (double)particlePos.getZ() + minZ + (double)level.random.nextFloat() * depth, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnFireChargeSmokeParticle(Level level, BlockPos particlePos) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, particlePos)) {
            return;
        }
        if (!ConfigHandler.fireCharge_onUse) {
            return;
        }
        double lavaIntensity = (double)ConfigHandler.fireCharge_intensity / 24.0;
        double smokeIntensity = (double)ConfigHandler.fireCharge_intensity / 58.0;
        for (int i = 0; i < ConfigHandler.maxFireCharge_onUse; ++i) {
            double x = (double)particlePos.getX() + 0.25 + level.random.nextDouble() / 2.0;
            double y = (double)particlePos.getY() + 0.25 + level.random.nextDouble() / 2.0;
            double z = (double)particlePos.getZ() + 0.25 + level.random.nextDouble() / 2.0;
            if ((double)level.random.nextFloat() > 0.2) {
                level.addParticle((ParticleOptions)((double)level.random.nextFloat() > 0.3 ? ParticleTypes.SMOKE : ParticleTypes.LARGE_SMOKE), x, y, z, (level.random.nextDouble() - 0.5) * smokeIntensity, (level.random.nextDouble() + 0.5) * smokeIntensity, (level.random.nextDouble() - 0.5) * smokeIntensity);
                continue;
            }
            level.addParticle((ParticleOptions)ParticleTypes.LAVA, x, y, z, (level.random.nextDouble() - 0.5) * lavaIntensity, (level.random.nextDouble() + 0.5) * lavaIntensity, (level.random.nextDouble() - 0.5) * lavaIntensity);
        }
    }

    public static void spawnHoeTillParticle(Level level, BlockPos blockPos, UseOnContext context) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        if (!ConfigHandler.hoeTill_onUse) {
            return;
        }
        Vec3 clickedPosition = context.getClickLocation();
        Direction clickDirection = context.getClickedFace();
        for (int i = 0; i < ConfigHandler.maxHoeTill_onUse; ++i) {
            double x = (level.random.nextDouble() - 0.5) * 0.5 * (double)(1 - clickDirection.getStepX());
            double y = (level.random.nextDouble() - 0.5) * 0.5 * (double)(1 - clickDirection.getStepY());
            double z = (level.random.nextDouble() - 0.5) * 0.5 * (double)(1 - clickDirection.getStepZ());
            BlockParticleOption blockParticle = new BlockParticleOption(ParticleTypes.BLOCK, level.getBlockState(blockPos));
            level.addParticle((ParticleOptions)blockParticle, clickedPosition.x + x, clickedPosition.y + y, clickedPosition.z + z, (double)clickDirection.getStepX() + (level.random.nextDouble() - 0.5), (double)clickDirection.getStepY() + (level.random.nextDouble() - 0.5), (double)clickDirection.getStepZ() + (level.random.nextDouble() - 0.5));
        }
    }

    public static void spawnShovelFlattenParticle(Level level, BlockPos blockPos, UseOnContext context) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        if (!ConfigHandler.shovelFlatten_onUse) {
            return;
        }
        Vec3 clickedPosition = context.getClickLocation();
        Direction clickDirection = context.getClickedFace();
        for (int i = 0; i < ConfigHandler.maxShovelFlatten_onUse; ++i) {
            double x = (level.random.nextDouble() - 0.5) * 0.5 * (double)(1 - clickDirection.getStepX());
            double y = (level.random.nextDouble() - 0.5) * 0.5 * (double)(1 - clickDirection.getStepY());
            double z = (level.random.nextDouble() - 0.5) * 0.5 * (double)(1 - clickDirection.getStepZ());
            BlockParticleOption blockParticle = new BlockParticleOption(ParticleTypes.BLOCK, level.getBlockState(blockPos));
            level.addParticle((ParticleOptions)blockParticle, clickedPosition.x + x, clickedPosition.y + y, clickedPosition.z + z, (double)clickDirection.getStepX() + (level.random.nextDouble() - 0.5), (double)clickDirection.getStepY() + (level.random.nextDouble() - 0.5), (double)clickDirection.getStepZ() + (level.random.nextDouble() - 0.5));
        }
    }

    public static void spawnAxeStripParticle(Level level, BlockPos blockPos, BlockState unstrippedBlockState, BlockState strippedBlockState, UseOnContext context) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        if (!ConfigHandler.axeStrip_onUse) {
            return;
        }
        Vec3 clickedPosition = context.getClickLocation();
        Direction clickDirection = context.getClickedFace();
        for (int i = 0; i < ConfigHandler.maxAxeStrip_onUse; ++i) {
            double x = (level.random.nextDouble() - 0.5) * 0.5 * (double)(1 - clickDirection.getStepX());
            double y = (level.random.nextDouble() - 0.5) * 0.5 * (double)(1 - clickDirection.getStepY());
            double z = (level.random.nextDouble() - 0.5) * 0.5 * (double)(1 - clickDirection.getStepZ());
            BlockParticleOption blockParticle = (double)level.random.nextFloat() > 0.9 ? new BlockParticleOption(ParticleTypes.BLOCK, strippedBlockState) : new BlockParticleOption(ParticleTypes.BLOCK, unstrippedBlockState);
            level.addParticle((ParticleOptions)blockParticle, clickedPosition.x + x, clickedPosition.y + y, clickedPosition.z + z, (double)clickDirection.getStepX() + (level.random.nextDouble() - 0.5), (double)clickDirection.getStepY() + (level.random.nextDouble() - 0.5), (double)clickDirection.getStepZ() + (level.random.nextDouble() - 0.5));
        }
    }

    public static void spawnFluidPlacedParticle(LevelAccessor levelAccessor, BlockPos particlePos, Fluid placedFluid) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.BLOCK_PLACE_OR_BREAK, particlePos)) {
            return;
        }
        if (placedFluid.isSame(Fluids.EMPTY)) {
            return;
        }
        FluidPlacementParticle particleOverride = FluidPlacementParticle.getParticleForFluid(placedFluid);
        if (particleOverride == FluidPlacementParticle.NONE) {
            return;
        }
        Object particleOption = particleOverride.isBlockStateParticle() ? particleOverride.getBlockParticleOption(placedFluid.defaultFluidState().createLegacyBlock()) : particleOverride.getParticleOption();
        if (particleOption == null) {
            return;
        }
        int maxParticles = FluidPlacementParticle.getParticleMultiplier(particleOverride, true);
        for (int i = 0; i < maxParticles; ++i) {
            double x = (double)particlePos.getX() + levelAccessor.getRandom().nextDouble();
            double y = (double)particlePos.getY() + levelAccessor.getRandom().nextDouble() / 1.5 + 0.6;
            double z = (double)particlePos.getZ() + levelAccessor.getRandom().nextDouble();
            levelAccessor.addParticle(particleOption, x, y, z, 0.0, 0.21, 0.0);
        }
    }

    public static void spawnAnvilUseSparkParticles(ClientLevel level, BlockPos blockPos) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        if (!ConfigHandler.anvilUseSparks_enabled) {
            return;
        }
        double x = (float)blockPos.getX() + 0.5f;
        double y = (double)blockPos.getY() + 1.0 + level.random.nextDouble() / 16.0;
        double z = (float)blockPos.getZ() + 0.5f;
        ParticleEmitterOptions emitter = new ParticleEmitterOptions(ModParticleTypes.FLYING_SPARK_EMITTER, 3, 7, 1, new Vector3f(0.25f, 0.0f, 0.25f));
        SpawnParticlesUtil.spawnParticleInCircle(emitter, level, new Vec3(x, y, z), ConfigHandler.maxAnvilUseSparks_onUse, 0.32f, 0.16f, 2.0f, 0.2f, 2.0f);
    }

    public static void spawnGrindstoneUseSparkParticles(ClientLevel level, BlockPos blockPos) {
        double z;
        double y;
        double x;
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        if (!ConfigHandler.grindstoneUseSparks_enabled) {
            return;
        }
        BlockState grindstoneState = level.getBlockState(blockPos);
        if (!(grindstoneState.getBlock() instanceof GrindstoneBlock)) {
            return;
        }
        Direction facing = (Direction)grindstoneState.getValue((Property)GrindstoneBlock.FACING);
        AttachFace attachFace = (AttachFace)grindstoneState.getValue((Property)GrindstoneBlock.FACE);
        if (attachFace == AttachFace.WALL) {
            x = (double)((float)blockPos.getX() + 0.5f) + (double)facing.getStepX() / 1.9;
            y = (float)blockPos.getY() + 0.5f;
            z = (double)((float)blockPos.getZ() + 0.5f) + (double)facing.getStepZ() / 1.9;
        } else {
            x = (float)blockPos.getX() + 0.5f;
            y = (float)blockPos.getY() + (attachFace == AttachFace.CEILING ? 0.0f : 1.05f);
            z = (float)blockPos.getZ() + 0.5f;
        }
        ParticleEmitterOptions emitter = SpawnParticles.getGrindstoneSparkEmitter(attachFace, facing);
        float HORIZONTAL_MIN_SPEED = 0.05f;
        float HORIZONTAL_MAX_SPEED = 0.3f;
        float UPWARDS_SPEED = 0.5f;
        float DOWNWARDS_SPEED = 0.1f;
        level.addParticle((ParticleOptions)emitter, x, y, z, (double)((float)facing.getStepX() * (attachFace == AttachFace.WALL ? 0.05f : 0.3f)), attachFace == AttachFace.WALL ? 0.5 : 0.0, (double)((float)facing.getStepZ() * (attachFace == AttachFace.WALL ? 0.05f : 0.3f)));
        level.addParticle((ParticleOptions)emitter, x, y, z, (double)((float)facing.getStepX() * (attachFace == AttachFace.WALL ? -0.05f : -0.3f)), attachFace == AttachFace.WALL ? (double)-0.1f : 0.0, (double)((float)facing.getStepZ() * (attachFace == AttachFace.WALL ? -0.05f : -0.3f)));
    }

    @NotNull
    private static ParticleEmitterOptions getGrindstoneSparkEmitter(AttachFace attachFace, Direction facing) {
        float depth;
        float EMITTER_BOUND_WIDTH = 0.1f;
        float EMITTER_BOUND_LENGTH = 0.8f;
        float width = attachFace == AttachFace.WALL ? 0.0f : 0.1f;
        float height = attachFace == AttachFace.WALL ? 0.8f : 0.0f;
        float f = depth = attachFace == AttachFace.WALL ? 0.0f : 0.1f;
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            width = 0.1f;
            depth = attachFace == AttachFace.WALL ? depth : 0.8f;
        } else if (facing == Direction.EAST || facing == Direction.WEST) {
            width = attachFace == AttachFace.WALL ? width : 0.8f;
            depth = 0.1f;
        }
        return new ParticleEmitterOptions(ModParticleTypes.FLYING_SPARK_EMITTER, ConfigHandler.maxGrindstoneUseSparks_onUse < 6 ? ConfigHandler.maxGrindstoneUseSparks_onUse : 6, 1, (int)Math.ceil((double)ConfigHandler.maxGrindstoneUseSparks_onUse / 6.0), new Vector3f(width, height, depth));
    }

    public static void spawnBrushingParticles(ClientLevel level, BlockParticleOverride override, BlockState blockState, Direction brushDirection, Vec3 particlePos, int armDirection, int amountOfParticles, double baseDeltaX, double baseDeltaY, double baseDeltaZ) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, particlePos.x(), particlePos.y(), particlePos.z())) {
            return;
        }
        double outwardVelocity = 0.05;
        for (int i = 0; i < amountOfParticles; ++i) {
            float velocityMultiplier;
            TintedParticleOption particleOption;
            if (ConfigHandler.brushParticleBehaviour == BrushParticleBehaviour.BLOCK_OVERRIDE_OR_VANILLA || ConfigHandler.brushParticleBehaviour == BrushParticleBehaviour.BLOCK_OVERRIDE_OR_DUST && override != BlockParticleOverride.VANILLA && override != BlockParticleOverride.NONE) {
                particleOption = override.getParticleOptionForState(blockState, level, BlockPos.containing((Position)particlePos), 5);
                velocityMultiplier = override.getParticleVelocityMultiplier();
            } else {
                particleOption = TintedParticleOption.BRUSH_OPTION;
                velocityMultiplier = 0.1f;
            }
            if (particleOption == null) continue;
            level.addParticle((ParticleOptions)particleOption, particlePos.x + (double)brushDirection.getStepX() * 0.05, particlePos.y + (double)brushDirection.getStepY() * 0.05, particlePos.z + (double)brushDirection.getStepZ() * 0.05, baseDeltaX * (double)armDirection * level.getRandom().nextDouble() * (double)velocityMultiplier + (double)brushDirection.getStepX() * 0.05, (baseDeltaY + 1.0) * level.getRandom().nextDouble() * (double)velocityMultiplier * (double)brushDirection.getStepY(), baseDeltaZ * (double)armDirection * level.getRandom().nextDouble() * (double)velocityMultiplier + (double)brushDirection.getStepZ() * 0.05);
        }
    }

    public static void spawnBlazeAmbientParticles(ClientLevel level, double x, double y, double z) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) {
            return;
        }
        if (level.random.nextFloat() < (float)ConfigHandler.blaze_spawnChance / 100.0f) {
            float xVel = MathHelpers.randomBetween(-0.2f, 0.2f);
            float yVel = MathHelpers.randomBetween(0.3f, 0.6f);
            float zVel = MathHelpers.randomBetween(-0.2f, 0.2f);
            level.addParticle((ParticleOptions)ModParticleTypes.FLOATING_SPARK, x, y, z, (double)xVel, (double)yVel, (double)zVel);
        }
    }

    public static void spawnBlazeHurtParticles(ClientLevel level, double x, double y, double z) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, x, y, z)) {
            return;
        }
        if (!ConfigHandler.blaze_spawnOnHurt) {
            return;
        }
        for (int i = 0; i < level.random.nextIntBetweenInclusive(ConfigHandler.blaze_amountToSpawnOnHurt <= 1 ? 1 : ConfigHandler.blaze_amountToSpawnOnHurt - 1, ConfigHandler.blaze_amountToSpawnOnHurt + 2); ++i) {
            float xVel = (float)MathHelpers.clampOutside(MathHelpers.randomBetween(-0.5f, 0.5f), -0.2, 0.2);
            float yVel = MathHelpers.randomBetween(0.4f, 0.6f);
            float zVel = (float)MathHelpers.clampOutside(MathHelpers.randomBetween(-0.5f, 0.5f), -0.2, 0.2);
            level.addParticle((ParticleOptions)ModParticleTypes.FLYING_SPARK, x, y, z, (double)xVel, (double)yVel, (double)zVel);
        }
    }

    public static void spawnRedstoneInteractionParticles(ClientLevel level, BlockState blockState, double interactionX, double interactionY, double interactionZ, float spreadX, float spreadY, float spreadZ) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, interactionX, interactionY, interactionZ)) {
            return;
        }
        if (!ConfigHandler.redstoneInteractionDust_enabled) {
            return;
        }
        BlockPos pos = BlockPos.containing((double)interactionX, (double)interactionY, (double)interactionZ);
        for (int i = 0; i < ConfigHandler.redstoneInteractionDust_amount; ++i) {
            double particleX = interactionX + (double)MathHelpers.randomBetween(-spreadX / 2.0f, spreadX / 2.0f);
            double particleY = interactionY + (double)MathHelpers.randomBetween(-spreadY / 2.0f, spreadY / 2.0f);
            double particleZ = interactionZ + (double)MathHelpers.randomBetween(-spreadZ / 2.0f, spreadZ / 2.0f);
            ParticleOptions particleOptions = BlockParticleOverrides.REDSTONE_DUST.getParticleOptionForState(blockState, level, pos, 9);
            if (particleOptions == null) continue;
            level.addParticle(particleOptions, particleX, particleY, particleZ, (double)MathHelpers.randomBetween(-0.05f, 0.05f), (double)0.2f, (double)MathHelpers.randomBetween(-0.05f, 0.05f));
        }
    }

    public static void spawnLavaBubblePopParticles(ClientLevel level, BlockPos fluidPos, FluidState fluidState) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, fluidPos)) {
            return;
        }
        if (!ConfigHandler.lavaBubblePop_enabled) {
            return;
        }
        if (level.random.nextFloat() < (float)ConfigHandler.lavaBubblePop_spawnChance / 2500.0f) {
            double d0 = (double)fluidPos.getX() + level.random.nextDouble();
            double d1 = (double)fluidPos.getY() + 0.95;
            double d2 = (double)fluidPos.getZ() + level.random.nextDouble();
            level.addParticle((ParticleOptions)ModParticleTypes.LAVA_POP, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnRandomUnderwaterBubbleStreams(ClientLevel level, BlockPos blockPos, BlockState blockState) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) {
            return;
        }
        if (!ConfigHandler.underwaterBubbleStreams_enabled) {
            return;
        }
        if (level.random.nextFloat() < (float)ConfigHandler.underwaterBubbleStreams_spawnChance / 2500.0f) {
            double d0 = (double)blockPos.getX() + level.random.nextDouble();
            double d1 = (double)blockPos.getY() + level.random.nextDouble();
            double d2 = (double)blockPos.getZ() + level.random.nextDouble();
            ParticleEmitterOptions emitter = new ParticleEmitterOptions(ModParticleTypes.UNDERWATER_RISING_BUBBLE_SMALL_EMITTER, MathHelpers.randomBetween(9, 30), MathHelpers.randomBetween(2, 4), 1);
            level.addParticle((ParticleOptions)emitter, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnBlockDisturbanceParticles(ClientLevel level, BlockPos blockPos, BlockState blockState, double entityX, double entityY, double entityZ, Vec3 deltaMovement, boolean isSprinting) {
        if (!ConfigHandler.blockRustle_enabled) {
            return;
        }
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        double speed = deltaMovement.length();
        if (speed <= 0.1 && !isSprinting) {
            return;
        }
        ResourceLocation blockLocation = RegistryHelpers.getLocationFromBlock(blockState.getBlock());
        if (!TagUtil.doesListContainBlock(ConfigHandler.blockRustle_Blocks, blockLocation)) {
            return;
        }
        int overrideOrigin = 10;
        int particlesAmount = speed > 0.25 || isSprinting ? 3 : 1;
        for (int i = 0; i < particlesAmount; ++i) {
            ParticleOptions particleToSpawn;
            BlockParticleOverride particleOverride;
            double particleX = entityX + ((double)level.random.nextFloat() * 0.5 - 0.25);
            double particleY = entityY + 0.35 + ((double)level.random.nextFloat() * 0.5 - 0.25);
            double particleZ = entityZ + ((double)level.random.nextFloat() * 0.5 - 0.25);
            BlockPos entityBlockPos = BlockPos.containing((double)particleX, (double)blockPos.getY(), (double)particleZ);
            if (level.getBlockState(entityBlockPos).isAir() || (particleOverride = BlockParticleOverride.getOverrideForBlockState(blockState, overrideOrigin)) == BlockParticleOverride.NONE || (particleToSpawn = particleOverride.getParticleOptionForState(blockState, level, blockPos, overrideOrigin)) == null) continue;
            level.addParticle(particleToSpawn, particleX, particleY, particleZ, deltaMovement.x * 3.0 * (double)particleOverride.getParticleVelocityMultiplier(), Math.min(deltaMovement.y, 0.1) * 3.0 * (double)particleOverride.getParticleVelocityMultiplier() + 0.1, deltaMovement.z * 3.0 * (double)particleOverride.getParticleVelocityMultiplier());
        }
    }

    public static void spawnItemFrameInteractionParticles(ClientLevel level, double x, double y, double z, AABB boundingBox, Direction itemFrameDirection, ItemFrameParticleOrigin particleOrigin, boolean glowingItemFrame) {
        if (!ConfigHandler.itemFrame_enabled) {
            return;
        }
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, x, y, z)) {
            return;
        }
        double particleSpeed = 0.2;
        if (particleOrigin == ItemFrameParticleOrigin.FRAME_KILLED) {
            return;
        }
        TintedParticleOption particleOptionToSpawn = glowingItemFrame ? TintedParticleOption.GLOW_ITEM_FRAME_DUST_OPTION : TintedParticleOption.ITEM_FRAME_DUST_OPTION;
        for (int i = 0; i < ConfigHandler.itemFrame_amount; ++i) {
            double randomX = boundingBox.minX + boundingBox.getXsize() * level.random.nextDouble();
            double randomY = boundingBox.minY + boundingBox.getYsize() * level.random.nextDouble();
            double randomZ = boundingBox.minZ + boundingBox.getZsize() * level.random.nextDouble();
            level.addParticle((ParticleOptions)particleOptionToSpawn, (double)itemFrameDirection.getStepX() * 0.15 + x, (double)itemFrameDirection.getStepY() * 0.15 + y, (double)itemFrameDirection.getStepZ() * 0.15 + z, (double)itemFrameDirection.getStepX() * 0.03 + (randomX - x) * 2.0 * particleSpeed, (double)itemFrameDirection.getStepY() * 0.03 + (randomY - y) * 2.0 * particleSpeed, (double)itemFrameDirection.getStepZ() * 0.03 + (randomZ - z) * 2.0 * particleSpeed);
        }
    }

    public static void spawnSmokerSmokeParticles(ClientLevel level, BlockPos blockPos) {
        if (!ConfigHandler.smokerSmoke_enabled) {
            return;
        }
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) {
            return;
        }
        if ((double)level.random.nextFloat() > 0.3) {
            Vec3 centerPos = blockPos.getCenter();
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, centerPos.x, (double)blockPos.getY() + 0.8, centerPos.z, 0.0, (double)0.07f, 0.0);
        }
    }

    public static void spawnAdditionalFurnaceParticles(ClientLevel level, BlockPos blockPos, BlockState furnaceState) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) {
            return;
        }
        if (!ConfigHandler.furnaceEmbers_enabled) {
            return;
        }
        double[] positions = ParticlePositionHelpers.getRandomFurnaceParticlePosition(blockPos, furnaceState);
        if (level.getBlockState(BlockPos.containing((double)positions[0], (double)positions[1], (double)positions[2])).isSuffocating((BlockGetter)level, blockPos)) {
            return;
        }
        Direction furnaceDirection = (Direction)furnaceState.getValue((Property)FurnaceBlock.FACING);
        boolean spawnSpark = (double)level.random.nextFloat() < 0.7;
        float outwardVelocity = MathHelpers.randomBetween(0.01f, 0.03f) * (float)(spawnSpark ? 1 : 5);
        level.addParticle((ParticleOptions)(spawnSpark ? ModParticleTypes.FLOATING_EMBER : ModParticleTypes.FLOATING_SPARK), positions[0], positions[1], positions[2], (double)((float)furnaceDirection.getStepX() * outwardVelocity), (double)0.05f, (double)((float)furnaceDirection.getStepZ() * outwardVelocity));
    }

    public static void spawnAdditionalBlastFurnaceParticles(ClientLevel level, BlockPos blockPos, BlockState furnaceState) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) {
            return;
        }
        if (!ConfigHandler.blastFurnaceSparks_enabled) {
            return;
        }
        double[] positions = ParticlePositionHelpers.getRandomFurnaceParticlePosition(blockPos, furnaceState);
        if (level.getBlockState(BlockPos.containing((double)positions[0], (double)positions[1], (double)positions[2])).isSuffocating((BlockGetter)level, blockPos)) {
            return;
        }
        Direction furnaceDirection = (Direction)furnaceState.getValue((Property)FurnaceBlock.FACING);
        boolean spawnSpark = (double)level.random.nextFloat() < 0.2;
        float outwardVelocity = MathHelpers.randomBetween(0.01f, 0.03f) * (float)(spawnSpark ? 1 : 5);
        level.addParticle((ParticleOptions)(spawnSpark ? ModParticleTypes.FLOATING_EMBER : ModParticleTypes.FLOATING_SPARK), positions[0], positions[1] + 0.125, positions[2], (double)((float)furnaceDirection.getStepX() * outwardVelocity), (double)0.05f, (double)((float)furnaceDirection.getStepZ() * outwardVelocity));
    }

    public static enum ItemFrameParticleOrigin {
        FRAME_KILLED,
        HELD_ITEM_REMOVED,
        ITEM_ROTATED,
        ITEM_PLACED;

    }
}

