/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.registry;

import games.enchanted.blockplaceparticles.registry.BlockOrTagLocation;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryHelpers {
    public static <T> Stream<ResourceLocation> getMatchingLocations(String search, DefaultedRegistry<T> registryToSearch) {
        int separatorIndex = search.indexOf(58);
        String unspacedSearch = search.replace(' ', '_');
        Predicate<ResourceLocation> filterPredicate = RegistryHelpers.getFilterPredicate(unspacedSearch, separatorIndex, registryToSearch);
        return registryToSearch.keySet().stream().filter(filterPredicate).sorted((location1, location2) -> {
            String path = (separatorIndex == -1 ? unspacedSearch : unspacedSearch.substring(separatorIndex + 1)).toLowerCase();
            boolean location1StartsWith = location1.getPath().toLowerCase().startsWith(path);
            boolean location2StartsWith = location2.getPath().toLowerCase().startsWith(path);
            if (location1StartsWith) {
                return location2StartsWith ? location1.compareTo(location2) : -1;
            }
            return location2StartsWith ? 1 : location1.compareTo(location2);
        });
    }

    public static <T> Stream<ResourceLocation> getMatchingTagLocations(String search, DefaultedRegistry<T> registryToSearch) {
        int separatorIndex = search.indexOf(58);
        String unspacedSearch = search.replace(' ', '_');
        Predicate<ResourceLocation> filterPredicate = RegistryHelpers.getFilterPredicate(unspacedSearch, separatorIndex, registryToSearch);
        return registryToSearch.getTags().map(tag -> tag.key().location()).filter(filterPredicate).sorted((location1, location2) -> {
            String path = (separatorIndex == -1 ? unspacedSearch : unspacedSearch.substring(separatorIndex + 1)).toLowerCase();
            boolean location1StartsWith = location1.getPath().toLowerCase().startsWith(path);
            boolean location2StartsWith = location2.getPath().toLowerCase().startsWith(path);
            if (location1StartsWith) {
                return location2StartsWith ? location1.compareTo(location2) : -1;
            }
            return location2StartsWith ? 1 : location1.compareTo(location2);
        });
    }

    @NotNull
    private static <T> Predicate<ResourceLocation> getFilterPredicate(String search, int separatorIndex, DefaultedRegistry<T> registryToSearch) {
        Predicate<ResourceLocation> filterPredicate;
        if (separatorIndex == -1) {
            filterPredicate = location -> location.getPath().contains(search) || registryToSearch.get(location).toString().toLowerCase().contains(search.toLowerCase());
        } else {
            String namespace = search.substring(0, separatorIndex);
            String path = search.substring(separatorIndex + 1);
            filterPredicate = location -> location.getNamespace().equals(namespace) && location.getPath().startsWith(path);
        }
        return filterPredicate;
    }

    public static Fluid getDefaultedFluid(String location, Fluid fallback) {
        try {
            ResourceLocation fluidLocation = ResourceLocation.parse((String)location.toLowerCase());
            Optional fluidFromLoc = BuiltInRegistries.FLUID.getOptional(fluidLocation);
            if (fluidFromLoc.isEmpty()) {
                return fallback;
            }
            if (fluidFromLoc.get() == Fluids.EMPTY) {
                return fallback;
            }
            return (Fluid)fluidFromLoc.get();
        }
        catch (ResourceLocationException resourceLocationException) {
            return fallback;
        }
    }

    public static ResourceLocation validateBlockLocationWithFallback(String location, ResourceLocation fallback) {
        try {
            ResourceLocation blockLocation = ResourceLocation.parse((String)location.toLowerCase());
            Optional blockFromLoc = BuiltInRegistries.BLOCK.getOptional(blockLocation);
            if (blockFromLoc.isEmpty()) {
                return fallback;
            }
            if (((Block)blockFromLoc.get()).defaultBlockState().isAir()) {
                return fallback;
            }
            return blockLocation;
        }
        catch (ResourceLocationException resourceLocationException) {
            return fallback;
        }
    }

    public static BlockOrTagLocation validateBlockOrTagLocationWithFallback(String location, BlockOrTagLocation fallback) {
        try {
            if (location.startsWith("#")) {
                return new BlockOrTagLocation(ResourceLocation.parse((String)location.replace("#", "").toLowerCase()), true);
            }
            ResourceLocation blockLocation = ResourceLocation.parse((String)location.toLowerCase());
            Optional blockFromLoc = BuiltInRegistries.BLOCK.getOptional(blockLocation);
            if (blockFromLoc.isEmpty()) {
                return fallback;
            }
            if (((Block)blockFromLoc.get()).defaultBlockState().isAir()) {
                return fallback;
            }
            return new BlockOrTagLocation(blockLocation);
        }
        catch (ResourceLocationException resourceLocationException) {
            return fallback;
        }
    }

    public static ResourceLocation validateFluidLocationWithFallback(String location, ResourceLocation fallback) {
        try {
            ResourceLocation fluidLocation = ResourceLocation.parse((String)location.toLowerCase());
            Optional blockFromLoc = BuiltInRegistries.FLUID.getOptional(fluidLocation);
            if (blockFromLoc.isEmpty()) {
                return fallback;
            }
            if (((Fluid)blockFromLoc.get()).defaultFluidState().createLegacyBlock().isAir()) {
                return fallback;
            }
            return fluidLocation;
        }
        catch (ResourceLocationException resourceLocationException) {
            return fallback;
        }
    }

    public static ResourceLocation getLocationFromFluid(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    public static Fluid getFluidFromLocation(ResourceLocation location) {
        return (Fluid)BuiltInRegistries.FLUID.getValue(location);
    }

    public static ResourceLocation getLocationFromBlock(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static BlockOrTagLocation getBlockLocationFromBlock(Block block) {
        return new BlockOrTagLocation(RegistryHelpers.getLocationFromBlock(block));
    }

    public static Block getBlockFromLocation(ResourceLocation location) {
        return (Block)BuiltInRegistries.BLOCK.getValue(location);
    }

    public static Holder<Block> getBlockHolderFromLocation(ResourceLocation location) {
        return BuiltInRegistries.BLOCK.wrapAsHolder((Object)RegistryHelpers.getBlockFromLocation(location));
    }

    public static boolean isBlockInTag(ResourceLocation blockLocation, TagKey<Block> tagKey) {
        Optional tagHolder = BuiltInRegistries.BLOCK.get(tagKey);
        if (tagHolder.isEmpty()) {
            return false;
        }
        Holder<Block> blockHolder = RegistryHelpers.getBlockHolderFromLocation(blockLocation);
        return ((HolderSet.Named)tagHolder.get()).contains(blockHolder);
    }

    public static TagKey<Block> getBlockTagKey(ResourceLocation tagLocation) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagLocation);
    }

    public static List<ResourceLocation> getLoadedBlockTags() {
        return BuiltInRegistries.BLOCK.getTags().map(t -> t.key().location()).toList();
    }

    @Nullable
    public static Registry<Biome> getBiomeRegistry() {
        if (Minecraft.getInstance().level == null) {
            return null;
        }
        return Minecraft.getInstance().level.registryAccess().lookupOrThrow(Registries.BIOME);
    }

    @Nullable
    public static Biome getBiomeFromLocation(ResourceLocation location) {
        Registry<Biome> biomeReg = RegistryHelpers.getBiomeRegistry();
        if (biomeReg == null) {
            return null;
        }
        return (Biome)biomeReg.getValue(location);
    }

    @Nullable
    public static ResourceLocation getLocationFromBiome(Biome biome) {
        Registry<Biome> biomeReg = RegistryHelpers.getBiomeRegistry();
        if (biomeReg == null) {
            return null;
        }
        return biomeReg.getKey((Object)biome);
    }

    @Nullable
    public static Holder<Biome> getBiomeHolderFromLocation(ResourceLocation location) {
        Registry<Biome> biomeReg = RegistryHelpers.getBiomeRegistry();
        Biome biome = RegistryHelpers.getBiomeFromLocation(location);
        if (biomeReg == null || biome == null) {
            return null;
        }
        return biomeReg.wrapAsHolder((Object)biome);
    }

    public static boolean isBiomeInTag(ResourceLocation biomeLocation, TagKey<Biome> tagKey) {
        if (Minecraft.getInstance().level == null) {
            return false;
        }
        Optional tagHolder = Minecraft.getInstance().level.registryAccess().lookupOrThrow(Registries.BIOME).get(tagKey);
        if (tagHolder.isEmpty()) {
            return false;
        }
        Holder<Biome> biomeHolder = RegistryHelpers.getBiomeHolderFromLocation(biomeLocation);
        if (biomeHolder == null) {
            return false;
        }
        return ((HolderSet.Named)tagHolder.get()).contains(biomeHolder);
    }

    public static TagKey<Biome> getBiomeTagKey(ResourceLocation tagLocation) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)tagLocation);
    }
}

