/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.util;

import com.mojang.blaze3d.platform.NativeImage;
import games.enchanted.blockplaceparticles.ParticleInteractionsLogging;
import games.enchanted.blockplaceparticles.mixin.accessor.client.SpriteContentsAccessor;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import games.enchanted.blockplaceparticles.util.TextureHelpers;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ColourUtil {
    private static final HashMap<ResourceLocation, Integer> averageSpriteColourCache = new HashMap();
    private static final int OPAQUE_PIXELS_THRESHOLD = 20;
    private static final HashMap<ResourceLocation, ImageCoordinate[]> spriteOpaquePixelsCache = new HashMap();

    public static int[] getAverageBlockColour(BlockState blockState) {
        TextureAtlasSprite particleSprite = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState).particleIcon();
        ResourceLocation particleSpriteLocation = particleSprite.contents().name();
        if (averageSpriteColourCache.containsKey(particleSpriteLocation)) {
            return ColourUtil.ARGBint_to_ARGB(averageSpriteColourCache.get(particleSpriteLocation));
        }
        int average = ColourUtil.calculateAverageSpriteColour(particleSprite);
        averageSpriteColourCache.put(particleSpriteLocation, average);
        return ColourUtil.ARGBint_to_ARGB(average);
    }

    public static int calculateAverageSpriteColour(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return -1;
        }
        SpriteContents spriteContents = sprite.contents();
        if (spriteContents.getUniqueFrames().count() == 0L) {
            return -1;
        }
        float total = 0.0f;
        float red = 0.0f;
        float blue = 0.0f;
        float green = 0.0f;
        float alpha = 0.0f;
        for (int x = 0; x < spriteContents.width(); ++x) {
            for (int y = 0; y < spriteContents.height(); ++y) {
                int color = ((SpriteContentsAccessor)spriteContents).block_place_particle$getOriginalImage().getPixel(x, y);
                int[] argb = ColourUtil.ARGBint_to_ARGB(color);
                int pixelAlpha = argb[0];
                if (pixelAlpha <= 10) continue;
                total += 1.0f;
                alpha += (float)pixelAlpha;
                red += (float)argb[1];
                green += (float)argb[2];
                blue += (float)argb[3];
            }
        }
        float[] hsb = Color.RGBtoHSB((int)(red / total), (int)(green / total), (int)(blue / total), null);
        hsb[2] = hsb[2] * 1.05f;
        int[] rgb = ColourUtil.RGBint_to_RGB(Color.HSBtoRGB(Math.clamp(hsb[0], 0.0f, 1.0f), Math.clamp(hsb[1], 0.0f, 1.0f), Math.clamp(hsb[2], 0.0f, 1.0f)));
        return ColourUtil.ARGB_to_ARGBint((int)(alpha / total), rgb[0], rgb[1], rgb[2]);
    }

    public static int[] getRandomBlockColour(BlockState blockState) {
        ImageCoordinate[] pixelCoordinatesList;
        TextureAtlasSprite particleSprite = blockState.getBlock() == Blocks.GRASS_BLOCK ? TextureHelpers.getSpriteFromBlockAtlas(ResourceLocation.withDefaultNamespace((String)"block/grass_block_top")) : Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState).particleIcon();
        SpriteContents spriteContents = particleSprite.contents();
        ResourceLocation particleSpriteLocation = particleSprite.contents().name();
        if (spriteOpaquePixelsCache.containsKey(particleSpriteLocation)) {
            pixelCoordinatesList = spriteOpaquePixelsCache.get(particleSpriteLocation);
        } else {
            pixelCoordinatesList = ColourUtil.findOutWhereOpaquePixelCoordinatesAre(spriteContents);
            spriteOpaquePixelsCache.put(particleSpriteLocation, pixelCoordinatesList);
            ParticleInteractionsLogging.textureDebugInfo("Opaque pixels list for sprite: {} has been cached", spriteContents.name());
        }
        if (pixelCoordinatesList.length == 0) {
            return new int[]{0, 255, 255, 255};
        }
        ImageCoordinate randomPixelCoordinate = pixelCoordinatesList.length == 1 && (pixelCoordinatesList[0].x() < 0 || pixelCoordinatesList[0].y() < 0) ? new ImageCoordinate(MathHelpers.randomBetween(0, spriteContents.width() - 1), MathHelpers.randomBetween(0, spriteContents.height() - 1)) : pixelCoordinatesList[MathHelpers.randomBetween(0, pixelCoordinatesList.length - 1)];
        NativeImage particleImage = ((SpriteContentsAccessor)spriteContents).block_place_particle$getOriginalImage();
        if (randomPixelCoordinate.x() > particleImage.getWidth() - 1 || randomPixelCoordinate.y() > particleImage.getHeight() - 1) {
            return new int[]{255, 255, 255, 255};
        }
        int sampledColour = particleImage.getPixel(randomPixelCoordinate.x(), randomPixelCoordinate.y());
        return ColourUtil.ARGBint_to_ARGB(sampledColour);
    }

    private static ImageCoordinate[] findOutWhereOpaquePixelCoordinatesAre(SpriteContents spriteContents) {
        ArrayList<ImageCoordinate> coordinatesList = new ArrayList<ImageCoordinate>();
        int totalOpaquePixels = 0;
        for (int x = 0; x < spriteContents.width(); ++x) {
            for (int y = 0; y < spriteContents.height(); ++y) {
                int sampledColour = ((SpriteContentsAccessor)spriteContents).block_place_particle$getOriginalImage().getPixel(x, y);
                int[] argb = ColourUtil.ARGBint_to_ARGB(sampledColour);
                if (argb[0] <= 20) continue;
                coordinatesList.add(new ImageCoordinate(x, y));
                ++totalOpaquePixels;
            }
        }
        if (totalOpaquePixels >= (spriteContents.width() - 1) * (spriteContents.height() - 1)) {
            ParticleInteractionsLogging.textureDebugInfo("Sprite {} contains entirely opaque pixels", spriteContents.name());
            return new ImageCoordinate[]{new ImageCoordinate(-1, -1)};
        }
        ImageCoordinate[] coordinatesArray = new ImageCoordinate[coordinatesList.size()];
        coordinatesArray = coordinatesList.toArray(coordinatesArray);
        ParticleInteractionsLogging.textureDebugInfo("Sprite {} has {} opaque pixels", spriteContents.name(), totalOpaquePixels);
        return coordinatesArray;
    }

    public static void invalidateCaches() {
        averageSpriteColourCache.clear();
        spriteOpaquePixelsCache.clear();
    }

    public static int ARGB_to_ARGBint(int a, int r, int g, int b) {
        int alpha = MathHelpers.clampInt(a, 0, 255);
        int red = MathHelpers.clampInt(r, 0, 255);
        int green = MathHelpers.clampInt(g, 0, 255);
        int blue = MathHelpers.clampInt(b, 0, 255);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int[] ARGBint_to_ARGB(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return new int[]{a, r, g, b};
    }

    public static int RGB_to_RGBint(int r, int g, int b) {
        int red = MathHelpers.clampInt(r, 0, 255);
        int green = MathHelpers.clampInt(g, 0, 255);
        int blue = MathHelpers.clampInt(b, 0, 255);
        return red << 16 | green << 8 | blue;
    }

    public static int[] RGBint_to_RGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new int[]{r, g, b};
    }

    public static int[] RGBint_to_ARGB(int rgb) {
        int[] rgbArray = ColourUtil.RGBint_to_RGB(rgb);
        return new int[]{255, rgbArray[0], rgbArray[1], rgbArray[2]};
    }

    public static int[] ARGBfloats_to_ARGB(float a, float r, float g, float b) {
        return new int[]{(int)(a * 255.0f), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f)};
    }

    public static int[] randomiseNegative(int[] colours, float amount) {
        int[] randomised = new int[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            randomised[i] = ColourUtil.variateColourComponent(colours[i], -MathHelpers.randomBetween(0.0f, amount));
        }
        return randomised;
    }

    public static int[] randomiseNegativeUniform(int[] colours, float amount) {
        float randomAmount = -MathHelpers.randomBetween(0.0f, amount);
        int[] randomised = new int[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            randomised[i] = ColourUtil.variateColourComponent(colours[i], randomAmount);
        }
        return randomised;
    }

    public static int variateColourComponent(int colour, float variation) {
        return MathHelpers.clampInt(colour + (int)(variation * 255.0f), 0, 255);
    }

    public static int[] multiplyColours(int[] colour1, int[] colour2) {
        if (colour1.length != colour2.length) {
            throw new IllegalArgumentException(ColourUtil.class.getName() + "#multiplyColours: colour1 and colour2 must both be either ARGB or RGB arrays. colour1: " + Arrays.toString(colour1) + ", colour2: " + Arrays.toString(colour2));
        }
        if (colour1.length != 4 && colour1.length != 3) {
            throw new IllegalArgumentException(ColourUtil.class.getName() + "#multiplyColours: both colours must have 4 or 3 values. colour1: " + Arrays.toString(colour1) + ", colour2: " + Arrays.toString(colour2));
        }
        int[] multipliedColour = new int[colour1.length];
        for (int i = 0; i < colour1.length; ++i) {
            multipliedColour[i] = (int)(Math.clamp((float)colour1[i] / 255.0f * ((float)colour2[i] / 255.0f), 0.0f, 255.0f) * 255.0f);
        }
        return multipliedColour;
    }

    private record ImageCoordinate(int x, int y) {
    }
}

