/*
 * Decompiled with CFR 0.152.
 */
package com.example.spidersense;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="spidersense")
@OnlyIn(value=Dist.CLIENT)
public class SpiderSenseMod {
    public static final String MOD_ID = "spidersense";
    private static final int DETECTION_RADIUS = 20;
    private static final SoundEvent ALERT_SOUND = SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"spidersense", (String)"spider_sense_alert"));
    private Monster lastDetectedHostile = null;

    public SpiderSenseMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private boolean hasLineOfSight(Player player, Monster monster) {
        Vec3 playerEyes = player.getEyePosition();
        Vec3 monsterPos = monster.position().add(0.0, (double)(monster.getEyeHeight() / 2.0f), 0.0);
        ClipContext context = new ClipContext(playerEyes, monsterPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = player.level().clip(context);
        return result.getLocation().distanceTo(monsterPos) < 1.5;
    }

    private String getDirection(Player player, Monster monster) {
        double dx = monster.getX() - player.getX();
        double dz = monster.getZ() - player.getZ();
        double yaw = (player.getYRot() + 360.0f) % 360.0f;
        double angle = Math.toDegrees(Math.atan2(dz, dx)) + 180.0 - yaw;
        if ((angle = (angle + 360.0) % 360.0) >= 45.0 && angle < 135.0) {
            return "\u0421\u0437\u0430\u0434\u0438";
        }
        if (angle >= 135.0 && angle < 225.0) {
            return "\u0421\u043b\u0435\u0432\u0430";
        }
        if (angle >= 225.0 && angle < 315.0) {
            return "\u0421\u043f\u0435\u0440\u0435\u0434\u0438";
        }
        return "\u0421\u043f\u0440\u0430\u0432\u0430";
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && !(player = event.player).isSpectator() && !player.isCreative()) {
            List hostiles = player.level().getEntitiesOfClass(Monster.class, player.getBoundingBox().inflate(20.0));
            Monster nearestHostile = null;
            double nearestDistance = Double.MAX_VALUE;
            for (Monster hostile : hostiles) {
                double distance;
                if (!this.hasLineOfSight(player, hostile) || !((distance = player.distanceToSqr((Entity)hostile)) < nearestDistance)) continue;
                nearestDistance = distance;
                nearestHostile = hostile;
            }
            if (nearestHostile != null) {
                boolean isNewTarget;
                boolean bl = isNewTarget = !nearestHostile.equals((Object)this.lastDetectedHostile);
                if (isNewTarget) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)ALERT_SOUND, (float)1.0f, (float)1.0f));
                    this.lastDetectedHostile = nearestHostile;
                }
                double exactDistance = Math.sqrt(nearestDistance);
                String direction = this.getDirection(player, nearestHostile);
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.literal((String)String.format("\u26a0 %s - %s (%.1f\u043c)", nearestHostile.getName().getString(), direction, exactDistance)), false);
            } else {
                this.lastDetectedHostile = null;
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.empty(), false);
            }
        }
    }
}

