/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.tooltip;

import com.anthonyhilyard.iceberg.component.TitleBreakComponent;
import com.anthonyhilyard.iceberg.util.Easing;
import com.anthonyhilyard.iceberg.util.GuiHelper;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.tooltip.ItemModelComponent;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class TooltipDecor {
    public static final ResourceLocation DEFAULT_BORDERS = ResourceLocation.fromNamespaceAndPath((String)"legendarytooltips", (String)"textures/gui/tooltip_borders.png");
    private static float shineTimer = 1.5f;

    public static void setCurrentTooltipBorderStart(int color) {
        Tooltips.currentColors = new Tooltips.TooltipColors(Tooltips.currentColors.backgroundColorStart(), Tooltips.currentColors.backgroundColorEnd(), color, Tooltips.currentColors.borderColorEnd());
    }

    public static void setCurrentTooltipBorderEnd(int color) {
        Tooltips.currentColors = new Tooltips.TooltipColors(Tooltips.currentColors.backgroundColorStart(), Tooltips.currentColors.backgroundColorEnd(), Tooltips.currentColors.borderColorStart(), color);
    }

    public static void setCurrentTooltipBackgroundStart(int color) {
        Tooltips.currentColors = new Tooltips.TooltipColors(color, Tooltips.currentColors.backgroundColorEnd(), Tooltips.currentColors.borderColorStart(), Tooltips.currentColors.borderColorEnd());
    }

    public static void setCurrentTooltipBackgroundEnd(int color) {
        Tooltips.currentColors = new Tooltips.TooltipColors(Tooltips.currentColors.backgroundColorStart(), color, Tooltips.currentColors.borderColorStart(), Tooltips.currentColors.borderColorEnd());
    }

    public static void updateTimer(float deltaTime) {
        if (shineTimer > 0.0f) {
            shineTimer -= deltaTime;
        }
    }

    public static void resetTimer() {
        shineTimer = 1.5f;
    }

    public static void drawShadow(PoseStack poseStack, int x, int y, int width, int height) {
        int shadowColor = 0x44000000;
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x - 1), (int)(y + height + 4), (int)(x + width + 4), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x + width + 4), (int)(y - 1), (int)(x + width + 5), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x + width + 3), (int)(y + height + 3), (int)(x + width + 4), (int)(y + height + 4), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)x, (int)(y + height + 5), (int)(x + width + 5), (int)(y + height + 6), (int)shadowColor, (int)shadowColor);
        GuiHelper.drawGradientRect((Matrix4f)matrix, (int)390, (int)(x + width + 5), (int)y, (int)(x + width + 6), (int)(y + height + 5), (int)shadowColor, (int)shadowColor);
        poseStack.popPose();
    }

    public static void drawSeparator(PoseStack poseStack, int x, int y, int width, int color) {
        poseStack.pushPose();
        Matrix4f matrix = poseStack.last().pose();
        GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)400, (int)x, (int)y, (int)(x + width / 2), (int)(y + 1), (int)(color & 0xFFFFFF), (int)color);
        GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)400, (int)(x + width / 2), (int)y, (int)(x + width), (int)(y + 1), (int)color, (int)(color & 0xFFFFFF));
        poseStack.popPose();
    }

    public static void drawBorder(PoseStack poseStack, int x, int y, int width, int height, ItemStack item, List<ClientTooltipComponent> components, Font font, LegendaryTooltipsConfig.FrameDefinition frameDefinition, boolean comparison, int index) {
        if (comparison) {
            TooltipDecor.drawSeparator(poseStack, x - 3 + 1, y - 3 + 1 + 12, width, Tooltips.currentColors.borderColorStart());
            ++height;
        }
        if (LegendaryTooltipsConfig.getInstance().nameSeparator.get().booleanValue() && (LegendaryTooltipsConfig.getInstance().showSeparatorForEmpty.get().booleanValue() || !item.isEmpty())) {
            int titleLines = Tooltips.calculateTitleLines(components);
            int numComponents = components.size();
            for (int i = 0; i < components.size() && (components.get(i) instanceof ClientTextTooltip || components.get(i) instanceof ItemModelComponent || --numComponents != titleLines); ++i) {
            }
            if (titleLines < numComponents) {
                int i;
                int offset = 0;
                int titleStart = Tooltips.calculateTitleStart(components);
                if (components.stream().anyMatch(c -> c instanceof ItemModelComponent)) {
                    offset -= 2;
                }
                for (i = titleStart + titleLines; i < components.size() && components.get(i) instanceof TitleBreakComponent; ++i) {
                    ++titleLines;
                }
                for (i = 0; i < titleStart + titleLines && i < components.size(); ++i) {
                    ClientTooltipComponent component = components.get(i);
                    if (component instanceof ClientTextTooltip) {
                        int n = component.getHeight();
                        Objects.requireNonNull(font);
                        offset += Math.max(n, 9);
                        continue;
                    }
                    offset += component.getHeight();
                    if (i > titleStart) continue;
                    offset += 2;
                }
                TooltipDecor.drawSeparator(poseStack, x - 3 + 1, y - 3 + 2 + offset, width, Tooltips.currentColors.borderColorStart());
            }
        }
        if (frameDefinition.index() == LegendaryTooltipsConfig.STANDARD_BORDER.index() || frameDefinition.index() == LegendaryTooltipsConfig.NO_BORDER.index()) {
            return;
        }
        if (LegendaryTooltipsConfig.getInstance().shineEffect.get().booleanValue()) {
            int alpha;
            poseStack.pushPose();
            Matrix4f matrix = poseStack.last().pose();
            if (shineTimer >= 0.5f && shineTimer <= 1.5f) {
                float interval = 1.0f - Mth.clamp((float)((shineTimer - 0.5f) * 2.0f - 0.5f), (float)-0.5f, (float)1.5f);
                alpha = 0x77000000;
                int horizontalMin = x - 3;
                int horizontalMax = x + width + 3;
                int left = (int)Easing.Ease((float)horizontalMin, (float)horizontalMax, (float)Math.clamp(interval - 0.35f, 0.0f, 1.0f), (Easing.EasingType)Easing.EasingType.Quad);
                int middle = (int)Easing.Ease((float)horizontalMin, (float)horizontalMax, (float)Math.clamp(interval, 0.0f, 1.0f), (Easing.EasingType)Easing.EasingType.Quad);
                int right = (int)Easing.Ease((float)horizontalMin, (float)horizontalMax, (float)Math.clamp(interval + 0.35f, 0.0f, 1.0f), (Easing.EasingType)Easing.EasingType.Quad);
                GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)400, (int)left, (int)(y - 3), (int)middle, (int)(y - 3 + 1), (int)0xFFFFFF, (int)(0xFFFFFF | alpha));
                GuiHelper.drawGradientRectHorizontal((Matrix4f)matrix, (int)400, (int)middle, (int)(y - 3), (int)right, (int)(y - 3 + 1), (int)(0xFFFFFF | alpha), (int)0xFFFFFF);
            }
            if (shineTimer <= 1.0f) {
                float interval = Mth.clamp((float)shineTimer, (float)0.0f, (float)1.0f);
                alpha = (int)(85.0f * interval) << 24;
                int verticalMin = y - 3 + 1;
                int verticalMax = y + height + 3 - 1;
                int verticalInterval = (int)Mth.lerp((float)(interval * interval), (float)verticalMax, (float)verticalMin);
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)400, (int)(x - 3), (int)Math.max(verticalInterval - 12, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval, verticalMax), (int)0xFFFFFF, (int)(0xFFFFFF | alpha));
                GuiHelper.drawGradientRect((Matrix4f)matrix, (int)400, (int)(x - 3), (int)Math.max(verticalInterval, verticalMin), (int)(x - 3 + 1), (int)Math.min(verticalInterval + 12, verticalMax), (int)(0xFFFFFF | alpha), (int)0xFFFFFF);
            }
            poseStack.popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)frameDefinition.resource());
        Minecraft minecraft = Minecraft.getInstance();
        AbstractTexture borderTexture = minecraft.getTextureManager().getTexture(frameDefinition.resource());
        borderTexture.bind();
        int textureWidth = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
        int textureHeight = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
        int frameIndex = frameDefinition.index();
        int frameWidth = frameDefinition.frameWidth();
        int partSize = frameDefinition.partSize();
        int partOffset = frameDefinition.partOffset();
        int cornerOffset = frameDefinition.cornerOffset();
        int frameHeight = partSize * 2;
        int partWidth = frameWidth - partSize * 2;
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 400.0);
        GuiHelper.blit((PoseStack)poseStack, (int)(x - partSize + cornerOffset), (int)(y - partSize + cornerOffset), (int)partSize, (int)partSize, (float)(frameIndex / 8 * frameWidth), (float)(frameIndex * frameHeight % textureHeight), (int)partSize, (int)partSize, (int)textureWidth, (int)textureHeight);
        GuiHelper.blit((PoseStack)poseStack, (int)(x + width - cornerOffset), (int)(y - partSize + cornerOffset), (int)partSize, (int)partSize, (float)(frameWidth - partSize + frameIndex / 8 * frameWidth), (float)(frameIndex * frameHeight % textureHeight), (int)partSize, (int)partSize, (int)textureWidth, (int)textureHeight);
        GuiHelper.blit((PoseStack)poseStack, (int)(x - partSize + cornerOffset), (int)(y + height - cornerOffset), (int)partSize, (int)partSize, (float)(frameIndex / 8 * frameWidth), (float)(frameIndex * frameHeight % textureHeight + partSize), (int)partSize, (int)partSize, (int)textureWidth, (int)textureHeight);
        GuiHelper.blit((PoseStack)poseStack, (int)(x + width - cornerOffset), (int)(y + height - cornerOffset), (int)partSize, (int)partSize, (float)(frameWidth - partSize + frameIndex / 8 * frameWidth), (float)(frameIndex * frameHeight % textureHeight + partSize), (int)partSize, (int)partSize, (int)textureWidth, (int)textureHeight);
        if (width >= partWidth) {
            GuiHelper.blit((PoseStack)poseStack, (int)(x + width / 2 - partWidth / 2), (int)(y - partSize + partOffset), (int)partWidth, (int)partSize, (float)(partSize + frameIndex / 8 * frameWidth), (float)(frameIndex * frameHeight % textureHeight), (int)partWidth, (int)partSize, (int)textureWidth, (int)textureHeight);
            GuiHelper.blit((PoseStack)poseStack, (int)(x + width / 2 - partWidth / 2), (int)(y + height - partOffset), (int)partWidth, (int)partSize, (float)(partSize + frameIndex / 8 * frameWidth), (float)(frameIndex * frameHeight % textureHeight + partSize), (int)partWidth, (int)partSize, (int)textureWidth, (int)textureHeight);
        }
        poseStack.popPose();
    }
}

