/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.forge;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.client.IcebergClient;
import com.anthonyhilyard.iceberg.config.IIcebergConfigSpec;
import com.anthonyhilyard.iceberg.config.IcebergConfig;
import com.anthonyhilyard.iceberg.forge.client.IcebergForgeClient;
import com.anthonyhilyard.iceberg.forge.common.IcebergForgeCommon;
import com.anthonyhilyard.iceberg.forge.config.ForgeIcebergConfigSpec;
import com.anthonyhilyard.iceberg.forge.server.IcebergForgeServer;
import com.anthonyhilyard.iceberg.forge.services.ForgeKeyMappingRegistrar;
import com.anthonyhilyard.iceberg.forge.services.ForgeReloadListenerRegistrar;
import com.electronwill.nightconfig.core.Config;
import java.util.Locale;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="iceberg")
public final class IcebergForge {
    private static FMLJavaModLoadingContext context;

    public IcebergForge(FMLJavaModLoadingContext context) {
        IcebergForge.context = context;
        MinecraftForge.EVENT_BUS.register(IcebergForgeCommon.class);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            IEventBus modBus = context.getModEventBus();
            IcebergClient.init();
            MinecraftForge.EVENT_BUS.register(IcebergForgeClient.ForgeEvents.class);
            modBus.register(IcebergForgeClient.ModEvents.class);
            modBus.register(ForgeKeyMappingRegistrar.class);
            modBus.register(ForgeReloadListenerRegistrar.class);
        } else {
            MinecraftForge.EVENT_BUS.register(IcebergForgeServer.class);
        }
    }

    private static void registerConfig(Class<? extends IcebergConfig<?>> clazz, IIcebergConfigSpec spec, String modid) {
        Config.setInsertionOrderPreserved((boolean)true);
        ForgeIcebergConfigSpec forgeSpec = (ForgeIcebergConfigSpec)spec;
        if (forgeSpec.isEmpty()) {
            Iceberg.LOGGER.debug("Attempted to register an empty config on mod {}", (Object)modid);
            return;
        }
        FMLModContainer container = context.getContainer();
        container.addConfig(new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)forgeSpec, (ModContainer)container, String.format(Locale.ROOT, "%s.toml", modid)));
    }
}

