/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.forge.config;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.config.IIcebergConfigSpec;
import com.anthonyhilyard.iceberg.services.IIcebergConfigSpecBuilder;
import com.anthonyhilyard.iceberg.util.UnsafeUtil;
import com.electronwill.nightconfig.core.AbstractCommentedConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.InMemoryFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.utils.UnmodifiableConfigWrapper;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.config.IConfigSpec;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class ForgeIcebergConfigSpec
extends UnmodifiableConfigWrapper<UnmodifiableConfig>
implements IConfigSpec<ForgeIcebergConfigSpec>,
IIcebergConfigSpec {
    private Map<List<String>, String> levelComments;
    private Map<List<String>, String> levelTranslationKeys;
    private UnmodifiableConfig values;
    private Config childConfig;
    private boolean isCorrecting = false;
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    private ForgeIcebergConfigSpec(UnmodifiableConfig storage, UnmodifiableConfig values, Map<List<String>, String> levelComments, Map<List<String>, String> levelTranslationKeys) {
        super((UnmodifiableConfig)Config.copy((UnmodifiableConfig)storage));
        this.values = Config.copy((UnmodifiableConfig)values);
        this.levelComments = Map.copyOf(levelComments);
        this.levelTranslationKeys = Map.copyOf(levelTranslationKeys);
        try {
            Field exceptionHandlerField = FileWatcher.class.getDeclaredField("exceptionHandler");
            UnsafeUtil.setField(exceptionHandlerField, FileWatcher.defaultInstance(), e -> LogManager.getLogger().warn(Logging.CORE, "An error occurred while reloading config:", (Throwable)e));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLevelComment(List<String> path) {
        return this.levelComments.get(path);
    }

    public String getLevelTranslationKey(List<String> path) {
        return this.levelTranslationKeys.get(path);
    }

    public void setConfig(CommentedConfig config) {
        this.childConfig = config;
        if (config != null && !this.isCorrect(config)) {
            String string;
            FileConfig fileConfig;
            if (config instanceof FileConfig) {
                fileConfig = (FileConfig)config;
                string = fileConfig.getNioPath().toString();
            } else {
                string = config.toString();
            }
            String configName = string;
            Iceberg.LOGGER.warn("Configuration file {} is not correct. Correcting", (Object)configName);
            this.correct(config, (action, path, incorrectValue, correctedValue) -> Iceberg.LOGGER.warn("Incorrect key {} was corrected from {} to its default, {}. {}", (Object)DOT_JOINER.join((Iterable)path), incorrectValue, correctedValue, (Object)(incorrectValue == correctedValue ? "This seems to be an error." : "")), (action, path, incorrectValue, correctedValue) -> Iceberg.LOGGER.debug("The comment on key {} does not match the spec. This may create a backup.", (Object)DOT_JOINER.join((Iterable)path)));
            if (config instanceof FileConfig) {
                fileConfig = (FileConfig)config;
                fileConfig.save();
            }
        }
        this.afterReload();
    }

    public <T> T getRaw(List<String> path) {
        ForgeConfigSpec.ValueSpec valueSpec;
        Object object;
        Object value = super.getRaw(path);
        if (value != null) {
            return (T)value;
        }
        List<String> subPath = path.subList(0, path.size() - 1);
        Object test = super.getRaw(subPath);
        if (test instanceof ForgeConfigSpec.ValueSpec && (object = (valueSpec = (ForgeConfigSpec.ValueSpec)test).getDefault()) instanceof MutableSubconfig) {
            MutableSubconfig subconfig = (MutableSubconfig)((Object)object);
            value = subconfig.getRaw(path.get(path.size() - 1));
            if (value == null) {
                value = subconfig.defaultValueSpec();
            }
            return (T)value;
        }
        return null;
    }

    public void acceptConfig(CommentedConfig data) {
        this.setConfig(data);
    }

    public boolean isCorrecting() {
        return this.isCorrecting;
    }

    @Override
    public boolean isLoaded() {
        return this.childConfig != null;
    }

    public UnmodifiableConfig getSpec() {
        return this.config;
    }

    public UnmodifiableConfig getValues() {
        return this.values;
    }

    public void afterReload() {
        this.resetCaches(this.getValues().valueMap().values());
    }

    private void resetCaches(Iterable<Object> configValues) {
        configValues.forEach(value -> {
            if (value instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)value;
                configValue.clearCache();
            } else if (value instanceof Config) {
                Config innerConfig = (Config)value;
                this.resetCaches(innerConfig.valueMap().values());
            }
        });
    }

    public void save() {
        Preconditions.checkNotNull((Object)this.childConfig, (Object)"Cannot save config value without assigned Config object present!");
        Config config = this.childConfig;
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            fileConfig.save();
        }
    }

    public synchronized boolean isCorrect(CommentedConfig config) {
        LinkedList<String> parentPath = new LinkedList<String>();
        if (config.valueMap().isEmpty() && config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            File configFile = fileConfig.getFile();
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configFile.length() > 0L) {
                return true;
            }
        }
        return this.correct(this.config, config, parentPath, Collections.unmodifiableList(parentPath), (a, b, c, d) -> {}, null, true) == 0;
    }

    public synchronized int correct(CommentedConfig config) {
        return this.correct(config, (action, path, incorrectValue, correctedValue) -> {}, null);
    }

    public synchronized int correct(CommentedConfig config, ConfigSpec.CorrectionListener listener) {
        return this.correct(config, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int correct(CommentedConfig config, ConfigSpec.CorrectionListener listener, ConfigSpec.CorrectionListener commentListener) {
        LinkedList<String> parentPath = new LinkedList<String>();
        int ret = -1;
        try {
            this.isCorrecting = true;
            ret = this.correct(this.config, config, parentPath, Collections.unmodifiableList(parentPath), listener, commentListener, false);
        }
        finally {
            this.isCorrecting = false;
        }
        return ret;
    }

    private synchronized int correct(UnmodifiableConfig spec, CommentedConfig config, LinkedList<String> parentPath, List<String> parentPathUnmodifiable, ConfigSpec.CorrectionListener listener, ConfigSpec.CorrectionListener commentListener, boolean dryRun) {
        int count = 0;
        Map specMap = spec.valueMap();
        Map configMap = config.valueMap();
        for (Map.Entry specEntry : specMap.entrySet()) {
            ForgeConfigSpec.ValueSpec valueSpec;
            String key = (String)specEntry.getKey();
            Object specValue = specEntry.getValue();
            Object configValue = configMap.get(key);
            ConfigSpec.CorrectionAction action = configValue == null ? ConfigSpec.CorrectionAction.ADD : ConfigSpec.CorrectionAction.REPLACE;
            parentPath.addLast(key);
            String subConfigComment = null;
            if (specValue instanceof ForgeConfigSpec.ValueSpec && (valueSpec = (ForgeConfigSpec.ValueSpec)specValue).getDefault() instanceof UnmodifiableConfig) {
                subConfigComment = valueSpec.getComment();
                specValue = valueSpec.getDefault();
            }
            if (specValue instanceof UnmodifiableConfig) {
                UnmodifiableConfig specConfig = (UnmodifiableConfig)specValue;
                if (configValue instanceof Config) {
                    CommentedConfig commentedConfig;
                    if ((count += this.correct(specConfig, configValue instanceof CommentedConfig ? (commentedConfig = (CommentedConfig)configValue) : CommentedConfig.copy((UnmodifiableConfig)((Config)configValue)), parentPath, parentPathUnmodifiable, listener, commentListener, dryRun)) > 0 && dryRun) {
                        return count;
                    }
                } else {
                    if (dryRun) {
                        return 1;
                    }
                    newValue = config.createSubConfig();
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, newValue);
                    ++count;
                    if (specConfig instanceof MutableSubconfig) {
                        specConfig.valueMap().forEach((arg_0, arg_1) -> ForgeIcebergConfigSpec.lambda$correct$6((CommentedConfig)newValue, arg_0, arg_1));
                    } else {
                        count += this.correct((UnmodifiableConfig)specValue, (CommentedConfig)newValue, parentPath, parentPathUnmodifiable, listener, commentListener, dryRun);
                    }
                }
                String newComment = subConfigComment == null ? this.levelComments.get(parentPath) : subConfigComment;
                String oldComment = config.getComment(key);
                if (!this.stringsMatchIgnoringNewlines(oldComment, newComment)) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)newComment);
                    }
                    if (dryRun) {
                        return 1;
                    }
                    config.setComment(key, newComment);
                }
            } else if (specValue instanceof ForgeConfigSpec.ValueSpec) {
                String oldComment;
                ForgeConfigSpec.ValueSpec valueSpec2 = (ForgeConfigSpec.ValueSpec)specValue;
                if (!valueSpec2.test(configValue)) {
                    if (dryRun) {
                        return 1;
                    }
                    newValue = valueSpec2.correct(configValue);
                    configMap.put(key, newValue);
                    listener.onCorrect(action, parentPathUnmodifiable, configValue, newValue);
                    ++count;
                }
                if (!this.stringsMatchIgnoringNewlines(oldComment = config.getComment(key), valueSpec2.getComment())) {
                    if (commentListener != null) {
                        commentListener.onCorrect(action, parentPathUnmodifiable, (Object)oldComment, (Object)valueSpec2.getComment());
                    }
                    if (dryRun) {
                        return 1;
                    }
                    config.setComment(key, valueSpec2.getComment());
                }
            } else if (spec instanceof MutableSubconfig) {
                MutableSubconfig subconfig = (MutableSubconfig)spec;
                if (configMap.containsKey(key)) {
                    if (!subconfig.keyValidator().test(key)) {
                        if (dryRun) {
                            return 1;
                        }
                        listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, (Object)key, null);
                        configMap.remove(key);
                        ++count;
                    }
                    if (!subconfig.valueValidator().test(configMap.get(key))) {
                        if (dryRun) {
                            return 1;
                        }
                        listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, configMap.get(key), null);
                        configMap.remove(key);
                        ++count;
                    }
                }
            }
            parentPath.removeLast();
        }
        Iterator iterator = configMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (spec instanceof MutableSubconfig || specMap.containsKey(entry.getKey())) continue;
            if (dryRun) {
                return 1;
            }
            iterator.remove();
            parentPath.addLast((String)entry.getKey());
            listener.onCorrect(ConfigSpec.CorrectionAction.REMOVE, parentPathUnmodifiable, entry.getValue(), null);
            parentPath.removeLast();
            ++count;
        }
        return count;
    }

    private boolean stringsMatchIgnoringNewlines(@Nullable Object obj1, @Nullable Object obj2) {
        if (obj1 instanceof String && obj2 instanceof String) {
            String string1 = (String)obj1;
            String string2 = (String)obj2;
            if (string1.length() > 0 && string2.length() > 0) {
                return string1.replaceAll("\r\n", "\n").equals(string2.replaceAll("\r\n", "\n"));
            }
        }
        return Objects.equals(obj1, obj2);
    }

    public static ForgeConfigSpec.ValueSpec createValueSpec(String comment, String langKey, boolean worldRestart, Class<?> clazz, Supplier<?> defaultSupplier, Predicate<Object> validator) {
        Objects.requireNonNull(defaultSupplier, "Default supplier can not be null!");
        Objects.requireNonNull(validator, "Validator can not be null!");
        ForgeConfigSpec.ValueSpec result = UnsafeUtil.newInstance(ForgeConfigSpec.ValueSpec.class);
        try {
            Field commentField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("comment");
            Field langKeyField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("langKey");
            Field rangeField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("range");
            Field worldRestartField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("worldRestart");
            Field clazzField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("clazz");
            Field supplierField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("supplier");
            Field validatorField = ForgeConfigSpec.ValueSpec.class.getDeclaredField("validator");
            UnsafeUtil.setField(commentField, result, comment);
            UnsafeUtil.setField(langKeyField, result, langKey);
            UnsafeUtil.setField(rangeField, result, null);
            UnsafeUtil.setField(worldRestartField, result, worldRestart);
            UnsafeUtil.setField(clazzField, result, clazz);
            UnsafeUtil.setField(supplierField, result, defaultSupplier);
            UnsafeUtil.setField(validatorField, result, validator);
        }
        catch (Exception e) {
            Iceberg.LOGGER.warn("Failed to instantiate ValueSpec!");
            Iceberg.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return result;
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    private static /* synthetic */ void lambda$correct$6(CommentedConfig newValue, String k, Object v) {
        Object object;
        Map map = newValue.valueMap();
        if (v instanceof ForgeConfigSpec.ValueSpec) {
            ForgeConfigSpec.ValueSpec vSpec = (ForgeConfigSpec.ValueSpec)v;
            object = vSpec.getDefault();
        } else {
            object = v;
        }
        map.put(k, object);
    }

    public static final class MutableSubconfig
    extends AbstractCommentedConfig {
        private final ConfigFormat<?> configFormat;
        private final Predicate<Object> keyValidator;
        private final Predicate<Object> valueValidator;
        private static ForgeConfigSpec.ValueSpec defaultValueSpec = null;

        MutableSubconfig(UnmodifiableConfig toCopy, ConfigFormat<?> configFormat, boolean concurrent, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            super(toCopy, concurrent);
            this.configFormat = configFormat;
            this.keyValidator = keyValidator;
            this.valueValidator = valueValidator;
        }

        public ForgeConfigSpec.ValueSpec defaultValueSpec() {
            if (defaultValueSpec == null) {
                defaultValueSpec = ForgeIcebergConfigSpec.createValueSpec(null, null, false, Object.class, () -> null, this.valueValidator);
            }
            return defaultValueSpec;
        }

        public ConfigFormat<?> configFormat() {
            return this.configFormat;
        }

        public Predicate<Object> keyValidator() {
            return this.keyValidator;
        }

        public Predicate<Object> valueValidator() {
            return this.valueValidator;
        }

        public static MutableSubconfig copy(UnmodifiableConfig config, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return new MutableSubconfig(config, config.configFormat(), false, keyValidator, valueValidator);
        }

        public CommentedConfig createSubConfig() {
            throw new UnsupportedOperationException("Can't make a subconfig of a mutable subconfig!");
        }

        public AbstractCommentedConfig clone() {
            throw new UnsupportedOperationException("Can't clone a mutable subconfig!");
        }
    }

    public static class Builder
    extends ForgeConfigSpec.Builder
    implements IIcebergConfigSpecBuilder {
        @Override
        public Builder comment(String comment) {
            return (Builder)super.comment(comment);
        }

        @Override
        public Builder comment(String ... comment) {
            return (Builder)super.comment(comment);
        }

        @Override
        public Builder translation(String translationKey) {
            return (Builder)super.translation(translationKey);
        }

        public Builder worldRestart() {
            return (Builder)super.worldRestart();
        }

        @Override
        public Builder push(String path) {
            return (Builder)super.push(path);
        }

        @Override
        public Builder push(List<String> path) {
            return (Builder)super.push(path);
        }

        @Override
        public Builder pop() {
            return (Builder)super.pop();
        }

        public Builder pop(int count) {
            return (Builder)super.pop(count);
        }

        private ForgeIcebergConfigSpec finishBuild() {
            ForgeIcebergConfigSpec result = null;
            try {
                Field valuesField = ForgeConfigSpec.Builder.class.getDeclaredField("values");
                Field storageField = ForgeConfigSpec.Builder.class.getDeclaredField("storage");
                Field levelCommentsField = ForgeConfigSpec.Builder.class.getDeclaredField("levelComments");
                Field levelTranslationKeysField = ForgeConfigSpec.Builder.class.getDeclaredField("levelTranslationKeys");
                List values = (List)UnsafeUtil.getField(valuesField, this);
                Config storage = (Config)UnsafeUtil.getField(storageField, this);
                Map levelComments = (Map)UnsafeUtil.getField(levelCommentsField, this);
                Map levelTranslationKeys = (Map)UnsafeUtil.getField(levelTranslationKeysField, this);
                Config valueCfg = Config.of((Supplier)Config.getDefaultMapCreator((boolean)true, (boolean)true), (ConfigFormat)InMemoryFormat.withSupport(ForgeConfigSpec.ConfigValue.class::isAssignableFrom));
                values.forEach(v -> valueCfg.set(v.getPath(), v));
                ForgeIcebergConfigSpec ret = new ForgeIcebergConfigSpec((UnmodifiableConfig)storage, (UnmodifiableConfig)valueCfg, levelComments, levelTranslationKeys);
                Field specField = ForgeConfigSpec.ConfigValue.class.getDeclaredField("spec");
                values.forEach(v -> {
                    try {
                        UnsafeUtil.setField(specField, v, ret);
                    }
                    catch (Exception e) {
                        Iceberg.LOGGER.warn("Failed to create spec field {}!", (Object)v.toString());
                        Iceberg.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                });
                result = ret;
            }
            catch (Exception e) {
                Iceberg.LOGGER.warn("Failed to build IcebergConfigSpec!");
                Iceberg.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
            }
            return result;
        }

        @Override
        public void reset() {
            try {
                Field valuesField = ForgeConfigSpec.Builder.class.getDeclaredField("values");
                Field storageField = ForgeConfigSpec.Builder.class.getDeclaredField("storage");
                Field levelCommentsField = ForgeConfigSpec.Builder.class.getDeclaredField("levelComments");
                Field levelTranslationKeysField = ForgeConfigSpec.Builder.class.getDeclaredField("levelTranslationKeys");
                List values = (List)UnsafeUtil.getField(valuesField, this);
                Config storage = (Config)UnsafeUtil.getField(storageField, this);
                Map levelComments = (Map)UnsafeUtil.getField(levelCommentsField, this);
                Map levelTranslationKeys = (Map)UnsafeUtil.getField(levelTranslationKeysField, this);
                storage.clear();
                levelComments.clear();
                levelTranslationKeys.clear();
                values.clear();
            }
            catch (Exception e) {
                Iceberg.LOGGER.warn(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }

        @Override
        public <T> Pair<T, IIcebergConfigSpec> finish(Function<IIcebergConfigSpecBuilder, T> consumer) {
            T o = consumer.apply(this);
            return Pair.of(o, (Object)this.finishBuild());
        }

        @Override
        public <T> Supplier<T> add(String path, T defaultValue) {
            ForgeConfigSpec.ConfigValue value = this.define(path, defaultValue);
            return () -> value.get();
        }

        @Override
        public <T> Supplier<T> add(String path, T defaultValue, Predicate<Object> validator) {
            ForgeConfigSpec.ConfigValue value = this.define(path, defaultValue, validator);
            return () -> value.get();
        }

        @Override
        public <V extends Comparable<? super V>> Supplier<V> addInRange(String path, V defaultValue, V min, V max, Class<V> clazz) {
            ForgeConfigSpec.ConfigValue value = this.defineInRange(path, defaultValue, min, max, clazz);
            return () -> (Comparable)value.get();
        }

        @Override
        public <T> Supplier<T> addInList(String path, T defaultValue, Collection<? extends T> acceptableValues) {
            ForgeConfigSpec.ConfigValue value = this.defineInList(path, defaultValue, acceptableValues);
            return () -> value.get();
        }

        @Override
        public <T> Supplier<List<? extends T>> addList(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            ForgeConfigSpec.ConfigValue value = this.defineList(path, defaultValue, elementValidator);
            return () -> (List)value.get();
        }

        @Override
        public <T> Supplier<List<? extends T>> addListAllowEmpty(String path, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
            ForgeConfigSpec.ConfigValue value = this.defineListAllowEmpty(path, defaultValue, elementValidator);
            return () -> (List)value.get();
        }

        @Override
        public <V extends Enum<V>> Supplier<V> addEnum(String path, V defaultValue) {
            ForgeConfigSpec.EnumValue value = this.defineEnum(path, defaultValue);
            return () -> (Enum)value.get();
        }

        @Override
        public <V extends Enum<V>> Supplier<V> addEnum(String path, V defaultValue, Predicate<Object> validator) {
            ForgeConfigSpec.EnumValue value = this.defineEnum(path, defaultValue, validator);
            return () -> (Enum)value.get();
        }

        @Override
        public Supplier<Boolean> add(String path, boolean defaultValue) {
            ForgeConfigSpec.BooleanValue value = this.define(path, defaultValue);
            return () -> (Boolean)value.get();
        }

        @Override
        public Supplier<Double> addInRange(String path, double defaultValue, double min, double max) {
            ForgeConfigSpec.DoubleValue value = this.defineInRange(path, defaultValue, min, max);
            return () -> (Double)value.get();
        }

        @Override
        public Supplier<Integer> addInRange(String path, int defaultValue, int min, int max) {
            ForgeConfigSpec.IntValue value = this.defineInRange(path, defaultValue, min, max);
            return () -> (Integer)value.get();
        }

        @Override
        public Supplier<Long> addInRange(String path, long defaultValue, long min, long max) {
            ForgeConfigSpec.LongValue value = this.defineInRange(path, defaultValue, min, max);
            return () -> (Long)value.get();
        }

        @Override
        public Supplier<Map<String, Object>> addSubconfig(String path, Map<String, Object> defaultValue, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return this.addSubconfig(ForgeIcebergConfigSpec.split(path), defaultValue, keyValidator, valueValidator);
        }

        public Supplier<Map<String, Object>> addSubconfig(List<String> path, Map<String, Object> defaultValue, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return this.addSubconfig(path, () -> defaultValue, keyValidator, valueValidator);
        }

        public Supplier<Map<String, Object>> addSubconfig(String path, Supplier<Map<String, Object>> defaultSupplier, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            return this.addSubconfig(ForgeIcebergConfigSpec.split(path), defaultSupplier, keyValidator, valueValidator);
        }

        public Supplier<Map<String, Object>> addSubconfig(List<String> path, Supplier<Map<String, Object>> defaultSupplier, Predicate<Object> keyValidator, Predicate<Object> valueValidator) {
            Config defaultConfig = Config.of(defaultSupplier, (ConfigFormat)TomlFormat.instance());
            ForgeConfigSpec.ConfigValue value = this.define(path, () -> Builder.lambda$addSubconfig$15((UnmodifiableConfig)defaultConfig, keyValidator, valueValidator), o -> o != null);
            return () -> ((Config)value.get()).valueMap();
        }

        private static /* synthetic */ Config lambda$addSubconfig$15(UnmodifiableConfig defaultConfig, Predicate keyValidator, Predicate valueValidator) {
            return MutableSubconfig.copy(defaultConfig, keyValidator, valueValidator);
        }
    }
}

