/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.forge.services;

import com.anthonyhilyard.iceberg.services.IReloadListenerRegistrar;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeReloadListenerRegistrar
implements IReloadListenerRegistrar {
    private static Set<PreparableReloadListener> listeners = Sets.newHashSet();
    private static Set<Supplier<PreparableReloadListener>> listenerSuppliers = Sets.newHashSet();

    @Override
    public void registerListener(PreparableReloadListener listener, ResourceLocation listenerId) {
        listeners.add(listener);
    }

    @Override
    public void registerListener(Supplier<PreparableReloadListener> listener, ResourceLocation listenerId) {
        listenerSuppliers.add(listener);
    }

    @SubscribeEvent
    public static void addListeners(RegisterClientReloadListenersEvent event) {
        for (PreparableReloadListener preparableReloadListener : listeners) {
            event.registerReloadListener(preparableReloadListener);
        }
        for (Supplier supplier : listenerSuppliers) {
            event.registerReloadListener((PreparableReloadListener)supplier.get());
        }
    }
}

