/*
 * Decompiled with CFR 0.152.
 */
package starcrop;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import starcrop.Register;

public class EnderArrow
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(EnderArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Potion potion = Potions.f_43598_;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();
    private boolean fixedColor;

    public EnderArrow(EntityType<? extends EnderArrow> p_36858_, Level p_36859_) {
        super(p_36858_, p_36859_);
    }

    public EnderArrow(Level p_36861_, double p_36862_, double p_36863_, double p_36864_) {
        super((EntityType)Register.ender_arrow.get(), p_36862_, p_36863_, p_36864_, p_36861_);
    }

    public EnderArrow(Level p_36866_, LivingEntity p_36867_) {
        super((EntityType)Register.ender_arrow.get(), p_36867_, p_36866_);
    }

    protected void m_5790_(EntityHitResult p_36757_) {
        super.m_5790_(p_36757_);
        Entity entity = p_36757_.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19602_, 200, 0));
        }
    }

    public void setEffectsFromItem(ItemStack p_36879_) {
        if (p_36879_.m_150930_(Items.f_42738_)) {
            int i;
            this.potion = PotionUtils.m_43579_((ItemStack)p_36879_);
            List collection = PotionUtils.m_43571_((ItemStack)p_36879_);
            if (!collection.isEmpty()) {
                for (MobEffectInstance mobeffectinstance : collection) {
                    this.effects.add(new MobEffectInstance(mobeffectinstance));
                }
            }
            if ((i = EnderArrow.getCustomColor(p_36879_)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (p_36879_.m_150930_(Items.f_42412_)) {
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack p_36885_) {
        CompoundTag compoundtag = p_36885_.m_41783_();
        return compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99) ? compoundtag.m_128451_("CustomPotionColor") : -1;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance p_36871_) {
        this.effects.add(p_36871_);
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
                double d5 = this.m_20184_().f_82479_;
                double d6 = this.m_20184_().f_82480_;
                double d1 = this.m_20184_().f_82481_;
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_(), this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6, -d1);
                }
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && !this.effects.isEmpty() && this.f_36704_ >= 600) {
            this.m_9236_().m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    private void makeParticle(int p_36877_) {
        int i = this.getColor();
        if (i != -1 && p_36877_ > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < p_36877_; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_EFFECT_COLOR);
    }

    private void setFixedColor(int p_36883_) {
        this.fixedColor = true;
        this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)p_36883_);
    }

    public void m_7380_(CompoundTag p_36881_) {
        super.m_7380_(p_36881_);
        if (this.potion != Potions.f_43598_) {
            p_36881_.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            p_36881_.m_128405_("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            p_36881_.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    public void m_7378_(CompoundTag p_36875_) {
        super.m_7378_(p_36875_);
        if (p_36875_.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)p_36875_);
        }
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)p_36875_)) {
            this.addEffect(mobeffectinstance);
        }
        if (p_36875_.m_128425_("Color", 99)) {
            this.setFixedColor(p_36875_.m_128451_("Color"));
        } else {
            this.updateColor();
        }
    }

    protected void m_7761_(LivingEntity p_36873_) {
        super.m_7761_(p_36873_);
        Entity entity = this.m_150173_();
        for (MobEffectInstance mobeffectinstance : this.potion.m_43488_()) {
            p_36873_.m_147207_(new MobEffectInstance(mobeffectinstance.m_19544_(), Math.max(mobeffectinstance.m_267696_(p_268168_ -> p_268168_ / 8), 1), mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), entity);
        }
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance mobeffectinstance1 : this.effects) {
                p_36873_.m_147207_(mobeffectinstance1, entity);
            }
        }
    }

    protected ItemStack m_7941_() {
        if (this.effects.isEmpty() && this.potion == Potions.f_43598_) {
            return new ItemStack((ItemLike)Items.f_42412_);
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42738_);
        PotionUtils.m_43549_((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.m_43552_((ItemStack)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.m_41784_().m_128405_("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    public void m_7822_(byte p_36869_) {
        if (p_36869_ == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(p_36869_);
        }
    }
}

