/*
 * Decompiled with CFR 0.152.
 */
package starcrop;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class EntityArcher
extends PathfinderMob
implements NeutralMob,
CrossbowAttackMob,
InventoryCarrier,
Enemy {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(Pillager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final SimpleContainer inventory = new SimpleContainer(5);

    public EntityArcher(EntityType<? extends EntityArcher> p_33262_, Level p_33263_) {
        super(p_33262_, p_33263_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new HoldGroundAttackGoal(this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedCrossbowAttackGoal(this, (PathfinderMob)this, 1.0, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((EntityArcher)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
        this.f_21346_.m_25352_(4, (Goal)new DefendVillageTargetGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    public boolean m_5886_(ProjectileWeaponItem p_33280_) {
        return p_33280_ == Items.f_42717_;
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean p_33302_) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)p_33302_);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_7380_(CompoundTag p_33300_) {
        super.m_7380_(p_33300_);
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            listtag.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        p_33300_.m_128365_("Inventory", (Tag)listtag);
    }

    public void m_7378_(CompoundTag p_33291_) {
        super.m_7378_(p_33291_);
        ListTag listtag = p_33291_.m_128437_("Inventory", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)listtag.m_128728_(i));
            if (itemstack.m_41619_()) continue;
            this.inventory.m_19173_(itemstack);
        }
        this.m_21553_(true);
    }

    public float m_5610_(BlockPos p_33288_, LevelReader p_33289_) {
        return 0.0f;
    }

    public int m_5792_() {
        return 1;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33282_, DifficultyInstance p_33283_, MobSpawnType p_33284_, @Nullable SpawnGroupData p_33285_, @Nullable CompoundTag p_33286_) {
        RandomSource randomsource = p_33282_.m_213780_();
        this.populateDefaultEquipmentSlots(p_33283_);
        this.m_213946_(randomsource, p_33283_);
        return super.m_6518_(p_33282_, p_33283_, p_33284_, p_33285_, p_33286_);
    }

    protected void populateDefaultEquipmentSlots(DifficultyInstance p_33270_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
    }

    protected void m_214095_(RandomSource p_217049_, float p_33316_) {
        ItemStack itemstack;
        super.m_214095_(p_217049_, p_33316_);
        if (this.f_19796_.m_188503_(300) == 0 && (itemstack = this.m_21205_()).m_150930_(Items.f_42717_)) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)itemstack);
            map.putIfAbsent(Enchantments.f_44961_, 1);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
        }
    }

    public boolean m_7307_(Entity p_33314_) {
        if (super.m_7307_(p_33314_)) {
            return true;
        }
        if (p_33314_ instanceof LivingEntity && ((LivingEntity)p_33314_).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && p_33314_.m_5647_() == null;
        }
        return false;
    }

    public void m_6504_(LivingEntity p_33272_, float p_33273_) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }

    public void m_5811_(LivingEntity p_33275_, ItemStack p_33276_, Projectile p_33277_, float p_33278_) {
        this.m_32322_((LivingEntity)this, p_33275_, p_33277_, p_33278_, 1.6f);
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    protected void m_7581_(ItemEntity p_33296_) {
        ItemStack itemstack = p_33296_.m_32055_();
        if (itemstack.m_41720_() instanceof BannerItem) {
            super.m_7581_(p_33296_);
        } else if (this.wantsItem(itemstack)) {
            this.m_21053_(p_33296_);
            ItemStack itemstack1 = this.inventory.m_19173_(itemstack);
            if (itemstack1.m_41619_()) {
                p_33296_.m_146870_();
            } else {
                itemstack.m_41764_(itemstack1.m_41613_());
            }
        }
    }

    private boolean wantsItem(ItemStack p_149745_) {
        return p_149745_.m_150930_(Items.f_42660_);
    }

    public ItemStack m_6298_(ItemStack p_33038_) {
        if (p_33038_.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)p_33038_.m_41720_()).m_6442_();
            ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            return itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemstack;
        }
        return ItemStack.f_41583_;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int p_28859_) {
        this.remainingPersistentAngerTime = p_28859_;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_28855_) {
        this.persistentAngerTarget = p_28855_;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    protected class HoldGroundAttackGoal
    extends Goal {
        private final EntityArcher mob;
        private final float hostileRadiusSqr;
        public final TargetingConditions shoutTargeting = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26893_();

        public HoldGroundAttackGoal(EntityArcher p_37907_, float p_37908_) {
            this.mob = p_37907_;
            this.hostileRadiusSqr = p_37908_ * p_37908_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_21188_();
            return this.mob.m_5448_() != null && !this.mob.m_5912_() && (livingentity == null || livingentity.m_6095_() != EntityType.f_20532_);
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21573_().m_26573_();
            for (Raider raider : this.mob.m_9236_().m_45971_(Raider.class, this.shoutTargeting, (LivingEntity)this.mob, this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0))) {
                raider.m_6710_(this.mob.m_5448_());
            }
        }

        public void m_8041_() {
            super.m_8041_();
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                for (Raider raider : this.mob.m_9236_().m_45971_(Raider.class, this.shoutTargeting, (LivingEntity)this.mob, this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0))) {
                    raider.m_6710_(livingentity);
                    raider.m_21561_(true);
                }
                this.mob.m_21561_(true);
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                if (this.mob.m_20280_((Entity)livingentity) > (double)this.hostileRadiusSqr) {
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                    if (this.mob.f_19796_.m_188503_(50) == 0) {
                        this.mob.m_8032_();
                    }
                } else {
                    this.mob.m_21561_(true);
                }
                super.m_8037_();
            }
        }
    }

    public class RangedCrossbowAttackGoal<T extends PathfinderMob & CrossbowAttackMob>
    extends Goal {
        public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
        private final T mob;
        private CrossbowState crossbowState = CrossbowState.UNCHARGED;
        private final double speedModifier;
        private final float attackRadiusSqr;
        private int seeTime;
        private int attackDelay;
        private int updatePathDelay;
        final /* synthetic */ EntityArcher this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public RangedCrossbowAttackGoal(T t, double p_25816_, float f) {
            void p_25814_;
            this.this$0 = (EntityArcher)this$0;
            this.mob = p_25814_;
            this.speedModifier = p_25815_;
            this.attackRadiusSqr = (float)(p_25816_ * p_25816_);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.isValidTarget() && this.isHoldingCrossbow();
        }

        private boolean isHoldingCrossbow() {
            return this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
        }

        public boolean m_8045_() {
            return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingCrossbow();
        }

        private boolean isValidTarget() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
            this.mob.m_6710_((LivingEntity)null);
            this.seeTime = 0;
            if (this.mob.m_6117_()) {
                this.mob.m_5810_();
                ((CrossbowAttackMob)this.mob).m_6136_(false);
                CrossbowItem.m_40884_((ItemStack)this.mob.m_21211_(), (boolean)false);
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                boolean flag2;
                boolean flag1;
                boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                double d0 = this.mob.m_20280_((Entity)livingentity);
                boolean bl2 = flag2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
                if (flag2) {
                    --this.updatePathDelay;
                    if (this.updatePathDelay <= 0) {
                        this.mob.m_21573_().m_5624_((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                        this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
                    }
                } else {
                    this.updatePathDelay = 0;
                    this.mob.m_21573_().m_26573_();
                }
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                if (this.crossbowState == CrossbowState.UNCHARGED) {
                    if (!flag2) {
                        this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                        this.crossbowState = CrossbowState.CHARGING;
                        ((CrossbowAttackMob)this.mob).m_6136_(true);
                    }
                } else if (this.crossbowState == CrossbowState.CHARGING) {
                    ItemStack itemstack;
                    int i;
                    if (!this.mob.m_6117_()) {
                        this.crossbowState = CrossbowState.UNCHARGED;
                    }
                    if ((i = this.mob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(itemstack = this.mob.m_21211_()))) {
                        this.mob.m_21253_();
                        this.crossbowState = CrossbowState.CHARGED;
                        this.attackDelay = 20 + this.mob.m_217043_().m_188503_(20);
                        ((CrossbowAttackMob)this.mob).m_6136_(false);
                    }
                } else if (this.crossbowState == CrossbowState.CHARGED) {
                    --this.attackDelay;
                    if (this.attackDelay == 0) {
                        this.crossbowState = CrossbowState.READY_TO_ATTACK;
                    }
                } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && flag) {
                    ((RangedAttackMob)this.mob).m_6504_(livingentity, 1.0f);
                    ItemStack itemstack1 = this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                    CrossbowItem.m_40884_((ItemStack)itemstack1, (boolean)false);
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
            }
        }

        private boolean canRun() {
            return this.crossbowState == CrossbowState.UNCHARGED;
        }

        static enum CrossbowState {
            UNCHARGED,
            CHARGING,
            CHARGED,
            READY_TO_ATTACK;

        }
    }

    private class DefendVillageTargetGoal
    extends TargetGoal {
        private final EntityArcher warrior;
        @Nullable
        private LivingEntity potentialTarget;
        private final TargetingConditions attackTargeting;

        public DefendVillageTargetGoal(EntityArcher warrior) {
            super((Mob)warrior, false, true);
            this.attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
            this.warrior = warrior;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            AABB aabb = this.warrior.m_20191_().m_82377_(10.0, 8.0, 10.0);
            List list = this.warrior.m_9236_().m_45971_(Villager.class, this.attackTargeting, (LivingEntity)this.warrior, aabb);
            List list1 = this.warrior.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)this.warrior, aabb);
            for (LivingEntity livingentity : list) {
                Villager villager = (Villager)livingentity;
                for (Player player : list1) {
                    int i = villager.m_35532_(player);
                    if (i > -100) continue;
                    this.potentialTarget = player;
                }
            }
            if (this.potentialTarget == null) {
                return false;
            }
            return !(this.potentialTarget instanceof Player) || !this.potentialTarget.m_5833_() && !((Player)this.potentialTarget).m_7500_();
        }

        public void m_8056_() {
            this.warrior.m_6710_(this.potentialTarget);
            super.m_8056_();
        }
    }
}

