/*
 * Decompiled with CFR 0.152.
 */
package starcrop;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.Vec3;

public class EntityIceSlime
extends Mob
implements Enemy {
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(EntityIceSlime.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int MIN_SIZE = 1;
    public static final int MAX_SIZE = 127;
    public float targetSquish;
    public float squish;
    public float oSquish;
    private boolean wasOnGround;

    public EntityIceSlime(EntityType<? extends EntityIceSlime> p_33588_, Level p_33589_) {
        super(p_33588_, p_33589_);
        this.m_252801_();
        this.f_21342_ = new SlimeMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SlimeFloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SlimeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SlimeRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SlimeKeepOnJumpingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, p_289461_ -> Math.abs(p_289461_.m_20186_() - this.m_20186_()) <= 4.0));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)1);
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        Entity entity;
        if (!this.m_9236_().m_5776_() && p_21016_.m_7639_() != null && (entity = p_21016_.m_7639_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.setSlowEffect(entity2);
            this.addSlowEffect((LivingEntity)this);
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22276_).m_22266_(Attributes.f_22279_).m_22266_(Attributes.f_22281_);
    }

    @VisibleForTesting
    public void setSize(int p_33594_, boolean p_33595_) {
        int i = Mth.m_14045_((int)p_33594_, (int)1, (int)127);
        this.f_19804_.m_135381_(ID_SIZE, (Object)i);
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(i * i));
        this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.2f + 0.1f * (float)i));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)i);
        if (p_33595_) {
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = i;
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    public void m_7380_(CompoundTag p_33619_) {
        super.m_7380_(p_33619_);
        p_33619_.m_128405_("Size", this.getSize() - 1);
        p_33619_.m_128379_("wasOnGround", this.wasOnGround);
    }

    public void m_7378_(CompoundTag p_33607_) {
        this.setSize(p_33607_.m_128451_("Size") + 1, false);
        super.m_7378_(p_33607_);
        this.wasOnGround = p_33607_.m_128471_("wasOnGround");
    }

    public boolean isTiny() {
        return this.getSize() <= 1;
    }

    protected ParticleOptions getParticleType() {
        return ParticleTypes.f_123754_;
    }

    protected boolean m_8028_() {
        return this.getSize() > 0;
    }

    public void m_8119_() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.m_8119_();
        if (this.m_20096_() && !this.wasOnGround) {
            int i = this.getSize();
            if (!this.spawnCustomParticles()) {
                for (int j = 0; j < i * 8; ++j) {
                    float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    float f1 = this.f_19796_.m_188501_() * 0.5f + 0.5f;
                    float f2 = Mth.m_14031_((float)f) * (float)i * 0.5f * f1;
                    float f3 = Mth.m_14089_((float)f) * (float)i * 0.5f * f1;
                    this.m_9236_().m_7106_(this.getParticleType(), this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
                }
            }
            this.m_5496_(this.getSquishSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
            this.targetSquish = -0.5f;
        } else if (!this.m_20096_() && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        this.wasOnGround = this.m_20096_();
        this.decreaseSquish();
    }

    protected void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void m_7350_(EntityDataAccessor<?> p_33609_) {
        if (ID_SIZE.equals(p_33609_)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
            if (this.m_20069_() && this.f_19796_.m_188503_(20) == 0) {
                this.m_5841_();
            }
        }
        super.m_7350_(p_33609_);
    }

    public EntityType<? extends EntityIceSlime> m_6095_() {
        return super.m_6095_();
    }

    public void m_142687_(Entity.RemovalReason p_149847_) {
        int i = this.getSize();
        if (!this.m_9236_().f_46443_ && i > 1 && this.m_21224_()) {
            Component component = this.m_7770_();
            boolean flag = this.m_21525_();
            float f = (float)i / 4.0f;
            int j = i / 2;
            int k = 2 + this.f_19796_.m_188503_(3);
            for (int l = 0; l < k; ++l) {
                float f1 = ((float)(l % 2) - 0.5f) * f;
                float f2 = ((float)(l / 2) - 0.5f) * f;
                EntityIceSlime slime = (EntityIceSlime)this.m_6095_().m_20615_(this.m_9236_());
                if (slime == null) continue;
                if (this.m_21532_()) {
                    slime.m_21530_();
                }
                slime.m_6593_(component);
                slime.m_21557_(flag);
                slime.m_20331_(this.m_20147_());
                slime.setSize(j, true);
                slime.m_7678_(this.m_20185_() + (double)f1, this.m_20186_() + 0.5, this.m_20189_() + (double)f2, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)slime);
            }
        }
        super.m_142687_(p_149847_);
    }

    public void m_7334_(Entity p_33636_) {
        super.m_7334_(p_33636_);
        if (p_33636_ instanceof IronGolem && this.isDealsDamage()) {
            this.dealDamage((LivingEntity)p_33636_);
        }
    }

    public void m_6123_(Player p_33611_) {
        if (this.isDealsDamage()) {
            this.dealDamage((LivingEntity)p_33611_);
        }
    }

    protected void dealDamage(LivingEntity p_33638_) {
        if (this.m_6084_()) {
            int i = this.getSize();
            if (this.m_20280_((Entity)p_33638_) < 0.6 * (double)i * 0.6 * (double)i && this.m_142582_((Entity)p_33638_) && p_33638_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage())) {
                this.m_5496_(SoundEvents.f_11985_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.setSlowEffect(p_33638_);
                this.addSlowEffect((LivingEntity)this);
                this.m_19970_((LivingEntity)this, (Entity)p_33638_);
            }
        }
    }

    void setSlowEffect(LivingEntity p_33638_) {
        if (p_33638_.m_21023_(MobEffects.f_19597_)) {
            int amp = p_33638_.m_21124_(MobEffects.f_19597_).m_19564_();
            int dur = p_33638_.m_21124_(MobEffects.f_19597_).m_19557_();
            p_33638_.m_7292_(new MobEffectInstance(MobEffects.f_19597_, dur + 200, ++amp));
        } else {
            p_33638_.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 0));
        }
    }

    void addSlowEffect(LivingEntity p_33638_) {
        if (p_33638_.m_21023_(MobEffects.f_19596_)) {
            int amp = p_33638_.m_21124_(MobEffects.f_19596_).m_19564_();
            int dur = p_33638_.m_21124_(MobEffects.f_19596_).m_19557_();
            p_33638_.m_7292_(new MobEffectInstance(MobEffects.f_19596_, dur + 200, ++amp));
        } else {
            p_33638_.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 0));
        }
    }

    protected float m_6431_(Pose p_33614_, EntityDimensions p_33615_) {
        return 0.625f * p_33615_.f_20378_;
    }

    protected boolean isDealsDamage() {
        return !this.isTiny() && this.m_21515_();
    }

    protected float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected SoundEvent m_7975_(DamageSource p_33631_) {
        return SoundEvents.f_11985_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11983_;
    }

    protected SoundEvent getSquishSound() {
        return SoundEvents.f_11986_;
    }

    public static boolean checkSlimeSpawnRules(EntityType<EntityIceSlime> p_219113_, LevelAccessor p_219114_, MobSpawnType p_219115_, BlockPos p_219116_, RandomSource p_219117_) {
        if (p_219114_.m_46791_() != Difficulty.PEACEFUL) {
            boolean flag;
            if (p_219114_.m_204166_(p_219116_).m_203656_(BiomeTags.f_215815_) && p_219116_.m_123342_() > 50 && p_219116_.m_123342_() < 70 && p_219117_.m_188501_() < 0.5f && p_219117_.m_188501_() < p_219114_.m_46940_() && p_219114_.m_46803_(p_219116_) <= p_219117_.m_188503_(8)) {
                return EntityIceSlime.m_217057_(p_219113_, (LevelAccessor)p_219114_, (MobSpawnType)p_219115_, (BlockPos)p_219116_, (RandomSource)p_219117_);
            }
            if (!(p_219114_ instanceof WorldGenLevel)) {
                return false;
            }
            ChunkPos chunkpos = new ChunkPos(p_219116_);
            boolean bl = flag = WorldgenRandom.m_224681_((int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (long)((WorldGenLevel)p_219114_).m_7328_(), (long)987234911L).m_188503_(10) == 0;
            if (p_219117_.m_188503_(10) == 0 && flag && p_219116_.m_123342_() < 40) {
                return EntityIceSlime.m_217057_(p_219113_, (LevelAccessor)p_219114_, (MobSpawnType)p_219115_, (BlockPos)p_219116_, (RandomSource)p_219117_);
            }
        }
        return false;
    }

    protected float m_6121_() {
        return 0.4f * (float)this.getSize();
    }

    public int m_8132_() {
        return 0;
    }

    protected boolean doPlayJumpSound() {
        return this.getSize() > 0;
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, this.m_6118_(), vec3.f_82481_);
        this.f_19812_ = true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33601_, DifficultyInstance p_33602_, MobSpawnType p_33603_, @Nullable SpawnGroupData p_33604_, @Nullable CompoundTag p_33605_) {
        RandomSource randomsource = p_33601_.m_213780_();
        int i = randomsource.m_188503_(3);
        if (i < 2 && randomsource.m_188501_() < 0.5f * p_33602_.m_19057_()) {
            ++i;
        }
        int j = 1 << i;
        this.setSize(j, true);
        return super.m_6518_(p_33601_, p_33602_, p_33603_, p_33604_, p_33605_);
    }

    float getSoundPitch() {
        float f = this.isTiny() ? 1.4f : 0.8f;
        return ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * f;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_11987_;
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(0.255f * (float)this.getSize());
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    static class SlimeMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final EntityIceSlime slime;
        private boolean isAggressive;

        public SlimeMoveControl(EntityIceSlime p_33668_) {
            super((Mob)p_33668_);
            this.slime = p_33668_;
            this.yRot = 180.0f * p_33668_.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float p_33673_, boolean p_33674_) {
            this.yRot = p_33673_;
            this.isAggressive = p_33674_;
        }

        public void setWantedMovement(double p_33671_) {
            this.f_24978_ = p_33671_;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                        if (this.slime.doPlayJumpSound()) {
                            this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_(), this.slime.getSoundPitch());
                        }
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.slime.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class SlimeFloatGoal
    extends Goal {
        private final EntityIceSlime slime;

        public SlimeFloatGoal(EntityIceSlime p_33655_) {
            this.slime = p_33655_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            p_33655_.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (this.slime.m_20069_() || this.slime.m_20077_()) && this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            if (this.slime.m_217043_().m_188501_() < 0.8f) {
                this.slime.m_21569_().m_24901_();
            }
            if ((movecontrol = this.slime.m_21566_()) instanceof SlimeMoveControl) {
                SlimeMoveControl slime$slimemovecontrol = (SlimeMoveControl)movecontrol;
                slime$slimemovecontrol.setWantedMovement(1.2);
            }
        }
    }

    static class SlimeAttackGoal
    extends Goal {
        private final EntityIceSlime slime;
        private int growTiredTimer;

        public SlimeAttackGoal(EntityIceSlime p_33648_) {
            this.slime = p_33648_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return !this.slime.m_6779_(livingentity) ? false : this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public void m_8056_() {
            this.growTiredTimer = SlimeAttackGoal.m_186073_((int)300);
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!this.slime.m_6779_(livingentity)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity != null) {
                this.slime.m_21391_((Entity)livingentity, 10.0f, 10.0f);
            }
            if ((movecontrol = this.slime.m_21566_()) instanceof SlimeMoveControl) {
                SlimeMoveControl slime$slimemovecontrol = (SlimeMoveControl)movecontrol;
                slime$slimemovecontrol.setDirection(this.slime.m_146908_(), this.slime.isDealsDamage());
            }
        }
    }

    static class SlimeRandomDirectionGoal
    extends Goal {
        private final EntityIceSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(EntityIceSlime p_33679_) {
            this.slime = p_33679_;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null && (this.slime.m_20096_() || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public void m_8037_() {
            MoveControl movecontrol;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + this.slime.m_217043_().m_188503_(60));
                this.chosenDegrees = this.slime.m_217043_().m_188503_(360);
            }
            if ((movecontrol = this.slime.m_21566_()) instanceof SlimeMoveControl) {
                SlimeMoveControl slime$slimemovecontrol = (SlimeMoveControl)movecontrol;
                slime$slimemovecontrol.setDirection(this.chosenDegrees, false);
            }
        }
    }

    static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final EntityIceSlime slime;

        public SlimeKeepOnJumpingGoal(EntityIceSlime p_33660_) {
            this.slime = p_33660_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.slime.m_20159_();
        }

        public void m_8037_() {
            MoveControl movecontrol = this.slime.m_21566_();
            if (movecontrol instanceof SlimeMoveControl) {
                SlimeMoveControl slime$slimemovecontrol = (SlimeMoveControl)movecontrol;
                slime$slimemovecontrol.setWantedMovement(1.0);
            }
        }
    }
}

