/*
 * Decompiled with CFR 0.152.
 */
package starcrop;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class EntityWarrior
extends PathfinderMob
implements NeutralMob,
InventoryCarrier {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(IronGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final SimpleContainer inventory = new SimpleContainer(5);

    public EntityWarrior(EntityType<? extends EntityWarrior> type, Level level) {
        super(type, level);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new DefendVillageTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((EntityWarrior)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 5, false, false, p_28879_ -> p_28879_ instanceof Enemy && !(p_28879_ instanceof Creeper)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33282_, DifficultyInstance p_33283_, MobSpawnType p_33284_, @Nullable SpawnGroupData p_33285_, @Nullable CompoundTag p_33286_) {
        RandomSource randomsource = p_33282_.m_213780_();
        this.m_213945_(randomsource, p_33283_);
        this.m_213946_(randomsource, p_33283_);
        return super.m_6518_(p_33282_, p_33283_, p_33284_, p_33285_, p_33286_);
    }

    protected void m_213945_(RandomSource p_217063_, DifficultyInstance p_33270_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 15.0);
    }

    protected int m_7302_(int p_28882_) {
        return p_28882_;
    }

    public boolean isPlayerCreated() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void m_7380_(CompoundTag p_28867_) {
        super.m_7380_(p_28867_);
        p_28867_.m_128379_("PlayerCreated", this.isPlayerCreated());
        this.m_21678_(p_28867_);
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            listtag.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        p_28867_.m_128365_("Inventory", (Tag)listtag);
    }

    public void m_7378_(CompoundTag p_28857_) {
        super.m_7378_(p_28857_);
        this.setPlayerCreated(p_28857_.m_128471_("PlayerCreated"));
        this.m_147285_(this.m_9236_(), p_28857_);
        ListTag listtag = p_28857_.m_128437_("Inventory", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)listtag.m_128728_(i));
            if (itemstack.m_41619_()) continue;
            this.inventory.m_19173_(itemstack);
        }
        this.m_21553_(true);
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    protected void m_7581_(ItemEntity p_33296_) {
        ItemStack itemstack = p_33296_.m_32055_();
        if (itemstack.m_41720_() instanceof BannerItem) {
            super.m_7581_(p_33296_);
        } else if (this.wantsItem(itemstack)) {
            this.m_21053_(p_33296_);
            ItemStack itemstack1 = this.inventory.m_19173_(itemstack);
            if (itemstack1.m_41619_()) {
                p_33296_.m_146870_();
            } else {
                itemstack.m_41764_(itemstack1.m_41613_());
            }
        }
    }

    private boolean wantsItem(ItemStack p_149745_) {
        return p_149745_.m_150930_(Items.f_42660_);
    }

    public void setPlayerCreated(boolean p_28888_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (p_28888_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void m_7870_(int p_28859_) {
        this.remainingPersistentAngerTime = p_28859_;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_28855_) {
        this.persistentAngerTarget = p_28855_;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    private class DefendVillageTargetGoal
    extends TargetGoal {
        private final EntityWarrior warrior;
        @Nullable
        private LivingEntity potentialTarget;
        private final TargetingConditions attackTargeting;

        public DefendVillageTargetGoal(EntityWarrior warrior) {
            super((Mob)warrior, false, true);
            this.attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
            this.warrior = warrior;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            AABB aabb = this.warrior.m_20191_().m_82377_(10.0, 8.0, 10.0);
            List list = this.warrior.m_9236_().m_45971_(Villager.class, this.attackTargeting, (LivingEntity)this.warrior, aabb);
            List list1 = this.warrior.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)this.warrior, aabb);
            for (LivingEntity livingentity : list) {
                Villager villager = (Villager)livingentity;
                for (Player player : list1) {
                    int i = villager.m_35532_(player);
                    if (i > -100) continue;
                    this.potentialTarget = player;
                }
            }
            if (this.potentialTarget == null) {
                return false;
            }
            return !(this.potentialTarget instanceof Player) || !this.potentialTarget.m_5833_() && !((Player)this.potentialTarget).m_7500_();
        }

        public void m_8056_() {
            this.warrior.m_6710_(this.potentialTarget);
            super.m_8056_();
        }
    }
}

