/*
 * Decompiled with CFR 0.152.
 */
package starcrop;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import starcrop.IceArrow;
import starcrop.Register;
import starcrop.SlowStringArrow;

public class IceArrowLeft
extends SlowStringArrow {
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(IceArrowLeft.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Potion potion = Potions.f_43598_;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();
    private boolean fixedColor;

    public IceArrowLeft(EntityType<? extends IceArrowLeft> p_36858_, Level p_36859_) {
        super(p_36858_, p_36859_, true);
    }

    public IceArrowLeft(Level p_36861_, double p_36862_, double p_36863_, double p_36864_, boolean isSommon) {
        super((EntityType<? extends SlowStringArrow>)((EntityType)Register.ice_arrow_left.get()), p_36862_, p_36863_, p_36864_, p_36861_, isSommon);
    }

    public IceArrowLeft(Level p_36866_, LivingEntity p_36867_) {
        super((EntityType<? extends SlowStringArrow>)((EntityType)Register.ice_arrow_left.get()), p_36867_, p_36866_, true);
    }

    @Override
    protected void m_5790_(EntityHitResult p_36757_) {
        super.m_5790_(p_36757_);
        Entity entity = p_36757_.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 2));
        }
    }

    @Override
    protected boolean tryPickup(Player p_150121_) {
        return false;
    }

    public void setEffectsFromItem(ItemStack p_36879_) {
        if (p_36879_.m_150930_(Items.f_42738_)) {
            int i;
            this.potion = PotionUtils.m_43579_((ItemStack)p_36879_);
            List collection = PotionUtils.m_43571_((ItemStack)p_36879_);
            if (!collection.isEmpty()) {
                for (MobEffectInstance mobeffectinstance : collection) {
                    this.effects.add(new MobEffectInstance(mobeffectinstance));
                }
            }
            if ((i = IceArrowLeft.getCustomColor(p_36879_)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (p_36879_.m_150930_(Items.f_42412_)) {
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack p_36885_) {
        CompoundTag compoundtag = p_36885_.m_41783_();
        return compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99) ? compoundtag.m_128451_("CustomPotionColor") : -1;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance p_36871_) {
        this.effects.add(p_36871_);
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
    }

    public void setIsShooted(boolean isShooted) {
        IceArrow abstractarrow = new IceArrow(this.m_9236_(), (LivingEntity)this.m_19749_());
        abstractarrow = this.customIceArrow(abstractarrow);
        abstractarrow.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        abstractarrow.m_37251_(this.m_19749_(), this.m_19749_().m_146909_(), this.m_19749_().m_146908_(), 0.0f, 0.3f, 1.0f);
        this.m_9236_().m_7967_((Entity)abstractarrow);
        this.m_6074_();
    }

    IceArrow customIceArrow(IceArrow arrow) {
        return arrow;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
        double sideOffset = 1.0;
        double leftX = this.m_19749_().m_20185_() + sideOffset * Math.cos(Math.toRadians(this.m_19749_().m_146908_()));
        double leftZ = this.m_19749_().m_20189_() + sideOffset * Math.sin(Math.toRadians(this.m_19749_().m_146908_()));
        this.m_6027_(leftX, this.m_19749_().m_20186_() + 2.0, leftZ);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_EFFECT_COLOR);
    }

    private void setFixedColor(int p_36883_) {
        this.fixedColor = true;
        this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)p_36883_);
    }

    @Override
    public void m_7380_(CompoundTag p_36881_) {
        super.m_7380_(p_36881_);
        if (this.potion != Potions.f_43598_) {
            p_36881_.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            p_36881_.m_128405_("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            p_36881_.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    @Override
    public void m_7378_(CompoundTag p_36875_) {
        super.m_7378_(p_36875_);
        if (p_36875_.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)p_36875_);
        }
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)p_36875_)) {
            this.addEffect(mobeffectinstance);
        }
        if (p_36875_.m_128425_("Color", 99)) {
            this.setFixedColor(p_36875_.m_128451_("Color"));
        } else {
            this.updateColor();
        }
    }

    @Override
    protected void doPostHurtEffects(LivingEntity p_36873_) {
        super.doPostHurtEffects(p_36873_);
        Entity entity = this.m_150173_();
        for (MobEffectInstance mobeffectinstance : this.potion.m_43488_()) {
            p_36873_.m_147207_(new MobEffectInstance(mobeffectinstance.m_19544_(), Math.max(mobeffectinstance.m_267696_(p_268168_ -> p_268168_ / 8), 1), mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), entity);
        }
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance mobeffectinstance1 : this.effects) {
                p_36873_.m_147207_(mobeffectinstance1, entity);
            }
        }
    }

    @Override
    protected ItemStack getPickupItem() {
        if (this.effects.isEmpty() && this.potion == Potions.f_43598_) {
            return new ItemStack((ItemLike)Items.f_42412_);
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42738_);
        PotionUtils.m_43549_((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.m_43552_((ItemStack)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.m_41784_().m_128405_("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }
}

