/*
 * Decompiled with CFR 0.152.
 */
package starcrop.ancianshark;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import starcrop.Register;
import starcrop.ancianshark.AncianSharkPart;
import starcrop.ancianshark.AncianSharkPhase;
import starcrop.ancianshark.AncianSharkPhaseManager;
import starcrop.ancianshark.CannonBall;

public class AncianShark
extends Mob
implements Enemy {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.m_135353_(AncianShark.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final double[][] positions = new double[64][3];
    public int posPointer = -1;
    private final AncianSharkPart[] subEntities;
    private final AncianSharkPart head;
    private final AncianSharkPart body;
    private final AncianSharkPart tail1;
    private final AncianSharkPart tail2;
    private final AncianSharkPart tail3;
    public boolean inWall;
    public int dragonDeathTime;
    public float yRotA;
    private BlockPos fightOrigin = BlockPos.f_121853_;
    private final AncianSharkPhaseManager phaseManager;
    private int growlTime = 100;
    private final Node[] nodes = new Node[24];
    private final int[] nodeAdjacency = new int[24];
    private final BinaryHeap openSet = new BinaryHeap();
    private final EntityDimensions size;
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.m_135353_(AncianShark.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState move = new AnimationState();
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    @Nullable
    private Player unlimitedLastHurtByPlayer = null;
    public int chargeTime = -20;

    public AncianShark(EntityType<? extends AncianShark> p_31096_, Level p_31097_) {
        super((EntityType)Register.ancian_shark.get(), p_31097_);
        this.size = EntityDimensions.m_20395_((float)p_31096_.m_20680_().f_20377_, (float)p_31096_.m_20680_().f_20378_);
        this.m_6210_();
        this.head = new AncianSharkPart(this, "head", 3.5f, 3.0f);
        this.body = new AncianSharkPart(this, "body", 4.1f, 3.0f);
        this.tail1 = new AncianSharkPart(this, "tail1", 3.0f, 2.5f);
        this.tail2 = new AncianSharkPart(this, "tail2", 2.0f, 2.0f);
        this.tail3 = new AncianSharkPart(this, "tail3", 2.5f, 4.0f);
        this.subEntities = new AncianSharkPart[]{this.head, this.body, this.tail1, this.tail2, this.tail3};
        this.m_21153_(this.m_21233_());
        this.f_19811_ = true;
        this.phaseManager = new AncianSharkPhaseManager(this);
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        this.m_20011_(new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + (double)this.size.f_20377_, this.m_20186_() + (double)this.size.f_20378_, this.m_20189_() + (double)this.size.f_20377_));
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.move.m_246184_(true, this.f_19797_);
        }
        super.m_8119_();
    }

    public EntityDimensions m_6972_(Pose p_31023_) {
        return this.size;
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_20235_ + i + 1);
        }
    }

    public void setFightOrigin(BlockPos p_287665_) {
        this.fightOrigin = p_287665_;
    }

    public BlockPos getFightOrigin() {
        return this.fightOrigin;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_PHASE, (Object)AncianSharkPhase.HOVERING.getId());
        this.f_19804_.m_135372_(DATA_ID_INV, (Object)200);
    }

    public int getInvulnerableTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int p_31511_) {
        this.f_19804_.m_135381_(DATA_ID_INV, (Object)p_31511_);
    }

    public double[] getLatencyPos(int p_31102_, float p_31103_) {
        if (this.m_21224_()) {
            p_31103_ = 0.0f;
        }
        p_31103_ = 1.0f - p_31103_;
        int i = this.posPointer - p_31102_ & 0x3F;
        int j = this.posPointer - p_31102_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.positions[i][0];
        double d1 = Mth.m_14175_((double)(this.positions[j][0] - d0));
        adouble[0] = d0 + d1 * (double)p_31103_;
        d0 = this.positions[i][1];
        d1 = this.positions[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_31103_;
        adouble[2] = Mth.m_14139_((double)p_31103_, (double)this.positions[i][2], (double)this.positions[j][2]);
        return adouble;
    }

    public void m_6457_(ServerPlayer p_31483_) {
        super.m_6457_(p_31483_);
        this.bossEvent.m_6543_(p_31483_);
    }

    public void m_6452_(ServerPlayer p_31488_) {
        super.m_6452_(p_31488_);
        this.bossEvent.m_6539_(p_31488_);
    }

    public void m_8107_() {
        int k1 = this.getInvulnerableTicks() - 1;
        this.bossEvent.m_142711_(1.0f - (float)k1 / 220.0f);
        if (this.f_20888_ == null) {
            this.f_20888_ = this.m_9236_().m_45930_((Entity)this, 150.0);
        }
        if (this.f_20888_ != null) {
            this.unlimitedLastHurtByPlayer = this.f_20888_;
        }
        if (this.unlimitedLastHurtByPlayer != null && this.unlimitedLastHurtByPlayer.m_213877_()) {
            this.unlimitedLastHurtByPlayer = null;
        }
        this.m_146874_();
        if (this.m_9236_().m_5776_()) {
            this.m_21153_(this.m_21223_());
        }
        if (this.m_21224_()) {
            float f8 = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            float f10 = (this.f_19796_.m_188501_() - 0.5f) * 4.0f;
            float f11 = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + (double)f8, this.m_20186_() + 2.0 + (double)f10, this.m_20189_() + (double)f11, 0.0, 0.0, 0.0);
        } else {
            this.m_146922_(Mth.m_14177_((float)this.m_146908_()));
            if (!this.m_21525_()) {
                if (this.posPointer < 0) {
                    for (int i = 0; i < this.positions.length; ++i) {
                        this.positions[i][0] = this.m_146908_();
                        this.positions[i][1] = this.m_20186_();
                    }
                }
                if (++this.posPointer == this.positions.length) {
                    this.posPointer = 0;
                }
                this.positions[this.posPointer][0] = this.m_146908_();
                this.positions[this.posPointer][1] = this.m_20186_();
                if (this.m_9236_().m_5776_()) {
                    if (this.f_20903_ > 0) {
                        double d6 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
                        double d0 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
                        double d1 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
                        double d2 = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
                        this.m_146922_(this.m_146908_() + (float)d2 / (float)this.f_20903_);
                        this.m_146926_(this.m_146909_() + (float)(this.f_20908_ - (double)this.m_146909_()) / (float)this.f_20903_);
                        --this.f_20903_;
                        this.m_6034_(d6, d0, d1);
                        this.m_19915_(this.m_146908_(), this.m_146909_());
                    }
                    this.phaseManager.getCurrentPhase().doClientTick();
                } else {
                    if (--this.growlTime < 0) {
                        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)Register.ancian_shark_growl.get(), SoundSource.HOSTILE, 2.5f * this.m_6134_(), (0.8f + this.f_19796_.m_188501_() * 0.3f) * this.m_6134_());
                        this.growlTime = 200 + this.f_19796_.m_188503_(200);
                    }
                    this.f_19794_ = this.m_20069_();
                    if (!this.m_20069_()) {
                        super.m_8107_();
                    } else if (this.m_9236_().m_8055_(this.m_20183_().m_6630_(2)).m_60819_().m_205070_(FluidTags.f_13131_)) {
                        if (this.unlimitedLastHurtByPlayer != null) {
                            double moveYPoint = this.m_20186_() > this.unlimitedLastHurtByPlayer.m_20186_() + 1.0 ? this.m_20186_() - 0.05 : (this.m_20186_() < this.unlimitedLastHurtByPlayer.m_20186_() - 1.0 && this.m_9236_().m_8055_(this.m_20183_().m_6630_(4)).m_60819_().m_205070_(FluidTags.f_13131_) ? this.m_20186_() + 0.05 : this.m_20186_());
                            this.m_6027_(this.m_20185_(), moveYPoint, this.m_20189_());
                        } else {
                            this.m_146922_(this.m_146908_() - 0.5f);
                        }
                        this.m_20256_(this.m_20156_().m_82490_(this.unlimitedLastHurtByPlayer != null ? -0.25 : -0.125));
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                    } else {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                    }
                    if (this.unlimitedLastHurtByPlayer != null) {
                        this.m_146922_(Mth.m_14189_((float)(this.m_20069_() ? 0.1f : 0.01f), (float)this.m_146908_(), (float)((float)(Mth.m_14136_((double)(this.unlimitedLastHurtByPlayer.m_20189_() - this.m_20189_()), (double)(this.unlimitedLastHurtByPlayer.m_20185_() - this.m_20185_())) * 57.29577951308232) - 180.0f)));
                        ++this.chargeTime;
                        Vec3 forward = this.m_20156_();
                        Vec3 right = new Vec3(-forward.f_82481_, 0.0, forward.f_82479_);
                        Vec3 toPlayer = this.unlimitedLastHurtByPlayer.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                        double dot = right.m_82526_(toPlayer);
                        if (dot > 0.0) {
                            if (this.chargeTime == 20) {
                                this.shoot(this.unlimitedLastHurtByPlayer, -0.6, -1.0);
                            }
                            if (this.chargeTime == 30) {
                                this.shoot(this.unlimitedLastHurtByPlayer, -0.6, -0.6);
                            }
                        } else {
                            if (this.chargeTime == 20) {
                                this.shoot(this.unlimitedLastHurtByPlayer, 0.6, -1.0);
                            }
                            if (this.chargeTime == 30) {
                                this.shoot(this.unlimitedLastHurtByPlayer, 0.6, -0.6);
                            }
                        }
                        if (this.chargeTime > 40) {
                            this.chargeTime = -10;
                        }
                    }
                }
                this.f_20883_ = this.m_146908_();
                Vec3[] avec3 = new Vec3[this.subEntities.length];
                for (int j = 0; j < this.subEntities.length; ++j) {
                    avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
                }
                this.head.m_6034_(this.m_20185_() + (double)(Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 7.0f), this.m_20186_() + 0.4, this.m_20189_() + (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 7.0f));
                this.body.m_6034_(this.m_20185_() + (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 3.1, this.m_20186_() + 0.4, this.m_20189_() + (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))) * 3.1);
                this.tail1.m_6034_(this.m_20185_() + (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * -0.5, this.m_20186_() + 0.6, this.m_20189_() + (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))) * -0.5);
                this.tail2.m_6034_(this.m_20185_() + (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * -3.0, this.m_20186_() + 0.9, this.m_20189_() + (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))) * -3.0);
                this.tail3.m_6034_(this.m_20185_() + (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * -5.3, this.m_20186_() + 0.1, this.m_20189_() + (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))) * -5.3);
                if (!this.m_9236_().m_5776_() && this.m_20069_()) {
                    this.inWall = this.checkWalls(this.head.m_20191_()) | this.checkWalls(this.body.m_20191_()) | this.checkWalls(this.tail1.m_20191_()) | this.checkWalls(this.tail2.m_20191_()) | this.checkWalls(this.tail3.m_20191_());
                }
                for (int l = 0; l < this.subEntities.length; ++l) {
                    this.subEntities[l].f_19854_ = avec3[l].f_82479_;
                    this.subEntities[l].f_19855_ = avec3[l].f_82480_;
                    this.subEntities[l].f_19856_ = avec3[l].f_82481_;
                    this.subEntities[l].f_19790_ = avec3[l].f_82479_;
                    this.subEntities[l].f_19791_ = avec3[l].f_82480_;
                    this.subEntities[l].f_19792_ = avec3[l].f_82481_;
                }
            }
            if (this.m_20072_()) {
                this.m_20301_(300);
            }
        }
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void shoot(Player nearestPlayer, double dx, double dz) {
        double dy = -1.0;
        double rotatedDx = dx * Math.cos(Math.toRadians(this.m_146908_())) - dz * Math.sin(Math.toRadians(this.m_146908_()));
        double rotatedDz = dx * Math.sin(Math.toRadians(this.m_146908_())) + dz * Math.cos(Math.toRadians(this.m_146908_()));
        double d2 = nearestPlayer.m_20185_() - (this.m_20185_() + rotatedDx * 4.0);
        double d3 = nearestPlayer.m_20227_(0.5) - (0.5 + (this.m_20227_(0.5) + dy));
        double d4 = nearestPlayer.m_20189_() - (this.m_20189_() + rotatedDz * 4.0);
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)Register.ancian_shark_shoot.get(), SoundSource.HOSTILE, 10.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        CannonBall largefireball = new CannonBall(this.m_9236_(), (LivingEntity)this, d2, d3, d4, 1);
        largefireball.m_6034_(this.m_20185_() + rotatedDx * 4.0, this.m_20227_(0.5) + dy + 0.5, this.m_20189_() + rotatedDz * 4.0);
        this.m_9236_().m_7967_((Entity)largefireball);
    }

    public boolean hurt(AncianSharkPart p_31121_, DamageSource p_31122_, float p_31123_) {
        p_31123_ = this.phaseManager.getCurrentPhase().onHurt(p_31122_, p_31123_);
        if (p_31123_ < 0.01f) {
            return false;
        }
        if (p_31122_.m_7639_() instanceof Player) {
            this.reallyHurt(p_31122_, p_31123_);
            if (this.m_21224_() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.m_21153_(1.0f);
            }
        }
        return true;
    }

    private boolean checkWalls(AABB p_31140_) {
        int i = Mth.m_14107_((double)p_31140_.f_82288_);
        int j = Mth.m_14107_((double)p_31140_.f_82289_);
        int k = Mth.m_14107_((double)p_31140_.f_82290_);
        int l = Mth.m_14107_((double)p_31140_.f_82291_);
        int i1 = Mth.m_14107_((double)p_31140_.f_82292_);
        int j1 = Mth.m_14107_((double)p_31140_.f_82293_);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (blockstate.m_60795_() || blockstate.m_204336_(BlockTags.f_215822_)) continue;
                    if (ForgeHooks.canEntityDestroy((Level)this.m_9236_(), (BlockPos)blockpos, (LivingEntity)this) && !blockstate.m_204336_(BlockTags.f_13069_)) {
                        flag1 = this.m_9236_().m_7471_(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.f_19796_.m_188503_(l - i + 1), j + this.f_19796_.m_188503_(i1 - j + 1), k + this.f_19796_.m_188503_(j1 - k + 1));
            this.m_9236_().m_46796_(2008, blockpos1, 0);
        }
        return flag;
    }

    protected boolean reallyHurt(DamageSource p_31162_, float p_31163_) {
        return super.m_6469_(p_31162_, p_31163_);
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float f = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            float f1 = (this.f_19796_.m_188501_() - 0.5f) * 4.0f;
            float f2 = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_() + (double)f, this.m_20186_() + 2.0 + (double)f1, this.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        int i = 500;
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0 && flag) {
                int award = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (Player)this.unlimitedLastHurtByPlayer, (int)Mth.m_14143_((float)((float)i * 0.08f)));
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20182_(), (int)award);
            }
            if (this.dragonDeathTime == 1 && !this.m_20067_()) {
                this.m_9236_().m_6798_(1028, this.m_20183_(), 0);
            }
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, (double)0.1f, 0.0));
        if (this.dragonDeathTime == 200 && this.m_9236_() instanceof ServerLevel) {
            if (flag) {
                int award = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (Player)this.unlimitedLastHurtByPlayer, (int)Mth.m_14143_((float)((float)i * 0.2f)));
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20182_(), (int)award);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int i = 0; i < 24; ++i) {
                int i1;
                int l;
                int j = 5;
                if (i < 12) {
                    l = Mth.m_14143_((float)(60.0f * Mth.m_14089_((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)))));
                    i1 = Mth.m_14143_((float)(60.0f * Mth.m_14031_((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)))));
                } else if (i < 20) {
                    int $$2 = i - 12;
                    l = Mth.m_14143_((float)(40.0f * Mth.m_14089_((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)))));
                    i1 = Mth.m_14143_((float)(40.0f * Mth.m_14031_((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)))));
                    j += 10;
                } else {
                    int k1 = i - 20;
                    l = Mth.m_14143_((float)(20.0f * Mth.m_14089_((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)))));
                    i1 = Mth.m_14143_((float)(20.0f * Mth.m_14031_((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)))));
                }
                int j1 = Math.max(this.m_9236_().m_5736_() + 10, this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(l, 0, i1)).m_123342_() + j);
                this.nodes[i] = new Node(l, j1, i1);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public int findClosestNode(double p_31171_, double p_31172_, double p_31173_) {
        int j;
        float f = 10000.0f;
        int i = 0;
        Node node = new Node(Mth.m_14107_((double)p_31171_), Mth.m_14107_((double)p_31172_), Mth.m_14107_((double)p_31173_));
        for (int k = j = 0; k < 24; ++k) {
            float f1;
            if (this.nodes[k] == null || !((f1 = this.nodes[k].m_77299_(node)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @javax.annotation.Nullable
    public Path findPath(int p_31105_, int p_31106_, @javax.annotation.Nullable Node p_31107_) {
        for (int i = 0; i < 24; ++i) {
            Node node = this.nodes[i];
            node.f_77279_ = false;
            node.f_77277_ = 0.0f;
            node.f_77275_ = 0.0f;
            node.f_77276_ = 0.0f;
            node.f_77278_ = null;
            node.f_77274_ = -1;
        }
        Node node4 = this.nodes[p_31105_];
        Node node5 = this.nodes[p_31106_];
        node4.f_77275_ = 0.0f;
        node4.f_77277_ = node4.f_77276_ = node4.m_77293_(node5);
        this.openSet.m_77081_();
        this.openSet.m_77084_(node4);
        Node node1 = node4;
        int j = 0;
        while (!this.openSet.m_77092_()) {
            Node node2 = this.openSet.m_77091_();
            if (node2.equals((Object)node5)) {
                if (p_31107_ != null) {
                    p_31107_.f_77278_ = node5;
                    node5 = p_31107_;
                }
                return this.reconstructPath(node4, node5);
            }
            if (node2.m_77293_(node5) < node1.m_77293_(node5)) {
                node1 = node2;
            }
            node2.f_77279_ = true;
            int k = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.nodes[l] != node2) continue;
                k = l;
                break;
            }
            for (int i1 = j; i1 < 24; ++i1) {
                if ((this.nodeAdjacency[k] & 1 << i1) <= 0) continue;
                Node node3 = this.nodes[i1];
                if (node3.f_77279_) continue;
                float f = node2.f_77275_ + node2.m_77293_(node3);
                if (node3.m_77303_() && !(f < node3.f_77275_)) continue;
                node3.f_77278_ = node2;
                node3.f_77275_ = f;
                node3.f_77276_ = node3.m_77293_(node5);
                if (node3.m_77303_()) {
                    this.openSet.m_77086_(node3, node3.f_77275_ + node3.f_77276_);
                    continue;
                }
                node3.f_77277_ = node3.f_77275_ + node3.f_77276_;
                this.openSet.m_77084_(node3);
            }
        }
        if (node1 == node4) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)p_31105_, (Object)p_31106_);
        if (p_31107_ != null) {
            p_31107_.f_77278_ = node1;
            node1 = p_31107_;
        }
        return this.reconstructPath(node4, node1);
    }

    private Path reconstructPath(Node p_31129_, Node p_31130_) {
        ArrayList list = Lists.newArrayList();
        Node node = p_31130_;
        list.add(0, p_31130_);
        while (node.f_77278_ != null) {
            node = node.f_77278_;
            list.add(0, node);
        }
        return new Path((List)list, new BlockPos(p_31130_.f_77271_, p_31130_.f_77272_, p_31130_.f_77273_), true);
    }

    public void m_7380_(CompoundTag p_31144_) {
        super.m_7380_(p_31144_);
        p_31144_.m_128405_("DragonPhase", this.phaseManager.getCurrentPhase().getPhase().getId());
        p_31144_.m_128405_("DragonDeathTime", this.dragonDeathTime);
        p_31144_.m_128405_("Invul", this.getInvulnerableTicks());
    }

    public void m_7378_(CompoundTag p_31134_) {
        super.m_7378_(p_31134_);
        if (p_31134_.m_128441_("DragonPhase")) {
            this.phaseManager.setPhase(AncianSharkPhase.getById(p_31134_.m_128451_("DragonPhase")));
        }
        if (p_31134_.m_128441_("DragonDeathTime")) {
            this.dragonDeathTime = p_31134_.m_128451_("DragonDeathTime");
        }
        this.setInvulnerableTicks(p_31134_.m_128451_("Invul"));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@javax.annotation.Nullable Component p_31476_) {
        super.m_6593_(p_31476_);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6043_() {
    }

    public AncianSharkPart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean m_6087_() {
        return false;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource p_31154_) {
        return null;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public void m_7350_(EntityDataAccessor<?> p_31136_) {
        if (DATA_PHASE.equals(p_31136_) && this.m_9236_().f_46443_) {
            this.phaseManager.setPhase(AncianSharkPhase.getById((Integer)this.m_20088_().m_135370_(DATA_PHASE)));
        }
        super.m_7350_(p_31136_);
    }

    public AncianSharkPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    public boolean m_147207_(MobEffectInstance p_182394_, @javax.annotation.Nullable Entity p_182395_) {
        return false;
    }

    protected boolean m_7341_(Entity p_31169_) {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_141965_(ClientboundAddEntityPacket p_218825_) {
        super.m_141965_(p_218825_);
    }

    public boolean m_6779_(LivingEntity p_149576_) {
        return p_149576_.m_142066_();
    }
}

