/*
 * Decompiled with CFR 0.152.
 */
package starcrop.babydragon;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import starcrop.babydragon.AbstractBabyDragonPhaseInstance;
import starcrop.babydragon.BabyEnderDragon;
import starcrop.babydragon.BabyEnderDragonPhase;

public class BabyDragonChargePlayerPhase
extends AbstractBabyDragonPhaseInstance {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private Vec3 targetLocation;
    private int timeSinceCharge;

    public BabyDragonChargePlayerPhase(BabyEnderDragon p_31206_) {
        super(p_31206_);
    }

    @Override
    public void doServerTick() {
        if (this.targetLocation == null) {
            LOGGER.warn("Aborting charge player as no target was set.");
            this.dragon.getPhaseManager().setPhase(BabyEnderDragonPhase.HOLDING_PATTERN);
        } else if (this.timeSinceCharge > 0 && this.timeSinceCharge++ >= 10) {
            this.dragon.getPhaseManager().setPhase(BabyEnderDragonPhase.HOLDING_PATTERN);
        } else {
            double d0 = this.targetLocation.m_82531_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_());
            if (d0 < 100.0 || d0 > 22500.0 || this.dragon.f_19862_ || this.dragon.f_19863_) {
                ++this.timeSinceCharge;
            }
        }
    }

    @Override
    public void begin() {
        this.targetLocation = null;
        this.timeSinceCharge = 0;
    }

    public void setTarget(Vec3 p_31208_) {
        this.targetLocation = p_31208_;
    }

    @Override
    public float getFlySpeed() {
        return 3.0f;
    }

    @Override
    @Nullable
    public Vec3 getFlyTargetLocation() {
        return this.targetLocation;
    }

    public BabyEnderDragonPhase<BabyDragonChargePlayerPhase> getPhase() {
        return BabyEnderDragonPhase.CHARGING_PLAYER;
    }
}

