/*
 * Decompiled with CFR 0.152.
 */
package starcrop.babydragon;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import starcrop.babydragon.AbstractBabyDragonPhaseInstance;
import starcrop.babydragon.BabyEnderDragon;
import starcrop.babydragon.BabyEnderDragonPhase;

public class BabyDragonHoldingPatternPhase
extends AbstractBabyDragonPhaseInstance {
    private static final TargetingConditions NEW_TARGET_TARGETING = TargetingConditions.m_148352_().m_148355_();
    @Nullable
    private Path currentPath;
    @Nullable
    private Vec3 targetLocation;
    private boolean clockwise;

    public BabyDragonHoldingPatternPhase(BabyEnderDragon p_31230_) {
        super(p_31230_);
    }

    public BabyEnderDragonPhase<BabyDragonHoldingPatternPhase> getPhase() {
        return BabyEnderDragonPhase.HOLDING_PATTERN;
    }

    @Override
    public void doServerTick() {
        double d0;
        double d = d0 = this.targetLocation == null ? 0.0 : this.targetLocation.m_82531_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_());
        if (d0 < 100.0 || d0 > 22500.0 || this.dragon.f_19862_ || this.dragon.f_19863_) {
            this.findNewTarget();
        }
    }

    @Override
    public void begin() {
        this.currentPath = null;
        this.targetLocation = null;
    }

    @Override
    @Nullable
    public Vec3 getFlyTargetLocation() {
        return this.targetLocation;
    }

    private void findNewTarget() {
        if (this.currentPath != null && this.currentPath.m_77392_()) {
            BlockPos blockpos = this.dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos((Vec3i)EndPodiumFeature.m_287210_((BlockPos)BlockPos.f_121853_)));
            int i = 0;
            if (this.dragon.m_217043_().m_188503_(i + 3) == 0) {
                this.dragon.getPhaseManager().setPhase(BabyEnderDragonPhase.LANDING_APPROACH);
                return;
            }
            Player player = this.dragon.m_9236_().m_45949_(NEW_TARGET_TARGETING, (LivingEntity)this.dragon, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
            double d0 = player != null ? blockpos.m_203193_((Position)player.m_20182_()) / 512.0 : 64.0;
            if (player != null && (this.dragon.m_217043_().m_188503_((int)(d0 + 2.0)) == 0 || this.dragon.m_217043_().m_188503_(i + 2) == 0)) {
                this.strafePlayer(player);
                return;
            }
        }
        if ((this.currentPath == null || this.currentPath.m_77392_()) && this.dragon.m_217043_().m_188503_(8) == 0) {
            this.clockwise = !this.clockwise;
        }
        this.navigateToNextPathNode();
    }

    private void strafePlayer(Player p_31237_) {
        this.dragon.getPhaseManager().setPhase(BabyEnderDragonPhase.STRAFE_PLAYER);
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.m_77392_()) {
            double d2;
            BlockPos vec3i = this.currentPath.m_77400_();
            this.currentPath.m_77374_();
            double d0 = vec3i.m_123341_();
            double d1 = vec3i.m_123343_();
            while ((d2 = (double)((float)vec3i.m_123342_() + this.dragon.m_217043_().m_188501_() * 20.0f)) < (double)vec3i.m_123342_()) {
            }
            this.targetLocation = new Vec3(d0, d2, d1);
        }
    }

    @Override
    public void onCrystalDestroyed(EndCrystal p_31232_, BlockPos p_31233_, DamageSource p_31234_, @Nullable Player p_31235_) {
        if (p_31235_ != null && this.dragon.m_6779_((LivingEntity)p_31235_)) {
            this.strafePlayer(p_31235_);
        }
    }
}

