/*
 * Decompiled with CFR 0.152.
 */
package starcrop.babydragon;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.Vec3;
import starcrop.babydragon.AbstractBabyDragonPhaseInstance;
import starcrop.babydragon.BabyEnderDragon;
import starcrop.babydragon.BabyEnderDragonPhase;

public class BabyDragonLandingPhase
extends AbstractBabyDragonPhaseInstance {
    @Nullable
    private Vec3 targetLocation;

    public BabyDragonLandingPhase(BabyEnderDragon p_31305_) {
        super(p_31305_);
    }

    @Override
    public void doClientTick() {
        Vec3 vec3 = this.dragon.getHeadLookVector(1.0f).m_82541_();
        vec3.m_82524_(-0.7853982f);
        double d0 = this.dragon.head.m_20185_();
        double d1 = this.dragon.head.m_20227_(0.5);
        double d2 = this.dragon.head.m_20189_();
        for (int i = 0; i < 8; ++i) {
            RandomSource randomsource = this.dragon.m_217043_();
            double d3 = d0 + randomsource.m_188583_() / 2.0;
            double d4 = d1 + randomsource.m_188583_() / 2.0;
            double d5 = d2 + randomsource.m_188583_() / 2.0;
            Vec3 vec31 = this.dragon.m_20184_();
            this.dragon.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, d3, d4, d5, -vec3.f_82479_ * (double)0.08f + vec31.f_82479_, -vec3.f_82480_ * (double)0.3f + vec31.f_82480_, -vec3.f_82481_ * (double)0.08f + vec31.f_82481_);
            vec3.m_82524_(0.19634955f);
        }
    }

    @Override
    public void doServerTick() {
        if (this.targetLocation == null) {
            this.targetLocation = Vec3.m_82539_((Vec3i)this.dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.m_287210_((BlockPos)BlockPos.f_121853_)));
        }
        if (this.targetLocation.m_82531_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_()) < 1.0) {
            this.dragon.getPhaseManager().getPhase(BabyEnderDragonPhase.SITTING_FLAMING).resetFlameCount();
            this.dragon.getPhaseManager().setPhase(BabyEnderDragonPhase.SITTING_SCANNING);
        }
    }

    @Override
    public float getFlySpeed() {
        return 1.5f;
    }

    @Override
    public float getTurnSpeed() {
        float f = (float)this.dragon.m_20184_().m_165924_() + 1.0f;
        float f1 = Math.min(f, 40.0f);
        return f1 / f;
    }

    @Override
    public void begin() {
        this.targetLocation = null;
    }

    @Override
    @Nullable
    public Vec3 getFlyTargetLocation() {
        return this.targetLocation;
    }

    public BabyEnderDragonPhase<BabyDragonLandingPhase> getPhase() {
        return BabyEnderDragonPhase.LANDING;
    }
}

