/*
 * Decompiled with CFR 0.152.
 */
package starcrop.babydragon;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BabyDragonRespawnAnimation {
    START{

        @Override
        public void tick(ServerLevel p_64017_, List<EndCrystal> p_64019_, int p_64020_, BlockPos p_64021_) {
            BlockPos blockpos = new BlockPos(0, 128, 0);
            for (EndCrystal endcrystal : p_64019_) {
                endcrystal.m_31052_(blockpos);
            }
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS{

        @Override
        public void tick(ServerLevel p_64026_, List<EndCrystal> p_64028_, int p_64029_, BlockPos p_64030_) {
            if (p_64029_ < 100 && (p_64029_ == 0 || p_64029_ == 50 || p_64029_ == 51 || p_64029_ == 52 || p_64029_ >= 95)) {
                p_64026_.m_46796_(3001, new BlockPos(0, 128, 0), 0);
            }
        }
    }
    ,
    SUMMONING_PILLARS{

        @Override
        public void tick(ServerLevel p_64035_, List<EndCrystal> p_64037_, int p_64038_, BlockPos p_64039_) {
            boolean flag1;
            boolean flag = p_64038_ % 40 == 0;
            boolean bl = flag1 = p_64038_ % 40 == 39;
            if (flag || flag1) {
                int j = p_64038_ / 40;
                List list = SpikeFeature.m_66858_((WorldGenLevel)p_64035_);
                if (j < list.size()) {
                    SpikeFeature.EndSpike spikefeature$endspike = (SpikeFeature.EndSpike)list.get(j);
                    if (flag) {
                        for (EndCrystal endcrystal : p_64037_) {
                            endcrystal.m_31052_(new BlockPos(spikefeature$endspike.m_66886_(), spikefeature$endspike.m_66899_() + 1, spikefeature$endspike.m_66893_()));
                        }
                    } else {
                        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)new BlockPos(spikefeature$endspike.m_66886_() - 10, spikefeature$endspike.m_66899_() - 10, spikefeature$endspike.m_66893_() - 10), (BlockPos)new BlockPos(spikefeature$endspike.m_66886_() + 10, spikefeature$endspike.m_66899_() + 10, spikefeature$endspike.m_66893_() + 10))) {
                            p_64035_.m_7471_(blockpos, false);
                        }
                        p_64035_.m_254849_((Entity)null, (double)((float)spikefeature$endspike.m_66886_() + 0.5f), (double)spikefeature$endspike.m_66899_(), (double)((float)spikefeature$endspike.m_66893_() + 0.5f), 5.0f, Level.ExplosionInteraction.BLOCK);
                        SpikeConfiguration spikeconfiguration = new SpikeConfiguration(true, (List)ImmutableList.of((Object)spikefeature$endspike), new BlockPos(0, 128, 0));
                        Feature.f_65732_.m_225028_((FeatureConfiguration)spikeconfiguration, (WorldGenLevel)p_64035_, p_64035_.m_7726_().m_8481_(), RandomSource.m_216327_(), new BlockPos(spikefeature$endspike.m_66886_(), 45, spikefeature$endspike.m_66893_()));
                    }
                } else if (flag) {
                    // empty if block
                }
            }
        }
    }
    ,
    SUMMONING_DRAGON{

        @Override
        public void tick(ServerLevel p_64044_, List<EndCrystal> p_64046_, int p_64047_, BlockPos p_64048_) {
            if (p_64047_ >= 100) {
                for (EndCrystal endcrystal : p_64046_) {
                    endcrystal.m_31052_((BlockPos)null);
                    p_64044_.m_254849_((Entity)endcrystal, endcrystal.m_20185_(), endcrystal.m_20186_(), endcrystal.m_20189_(), 6.0f, Level.ExplosionInteraction.NONE);
                    endcrystal.m_146870_();
                }
            } else if (p_64047_ >= 80) {
                p_64044_.m_46796_(3001, new BlockPos(0, 128, 0), 0);
            } else if (p_64047_ == 0) {
                for (EndCrystal endcrystal1 : p_64046_) {
                    endcrystal1.m_31052_(new BlockPos(0, 128, 0));
                }
            } else if (p_64047_ < 5) {
                p_64044_.m_46796_(3001, new BlockPos(0, 128, 0), 0);
            }
        }
    }
    ,
    END{

        @Override
        public void tick(ServerLevel p_64053_, List<EndCrystal> p_64055_, int p_64056_, BlockPos p_64057_) {
        }
    };


    public abstract void tick(ServerLevel var1, List<EndCrystal> var2, int var3, BlockPos var4);
}

