/*
 * Decompiled with CFR 0.152.
 */
package starcrop.babydragon;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import starcrop.babydragon.AbstractBabyDragonSittingPhase;
import starcrop.babydragon.BabyEnderDragon;
import starcrop.babydragon.BabyEnderDragonPhase;

public class BabyDragonSittingFlamingPhase
extends AbstractBabyDragonSittingPhase {
    private int flameTicks;
    private int flameCount;
    @Nullable
    private AreaEffectCloud flame;

    public BabyDragonSittingFlamingPhase(BabyEnderDragon p_31330_) {
        super(p_31330_);
    }

    @Override
    public void doClientTick() {
        ++this.flameTicks;
        if (this.flameTicks % 2 == 0 && this.flameTicks < 10) {
            Vec3 vec3 = this.dragon.getHeadLookVector(1.0f).m_82541_();
            vec3.m_82524_(-0.7853982f);
            double d0 = this.dragon.head.m_20185_();
            double d1 = this.dragon.head.m_20227_(0.5);
            double d2 = this.dragon.head.m_20189_();
            for (int i = 0; i < 8; ++i) {
                double d3 = d0 + this.dragon.m_217043_().m_188583_() / 2.0;
                double d4 = d1 + this.dragon.m_217043_().m_188583_() / 2.0;
                double d5 = d2 + this.dragon.m_217043_().m_188583_() / 2.0;
                for (int j = 0; j < 6; ++j) {
                    this.dragon.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, d3, d4, d5, -vec3.f_82479_ * (double)0.08f * (double)j, -vec3.f_82480_ * (double)0.6f, -vec3.f_82481_ * (double)0.08f * (double)j);
                }
                vec3.m_82524_(0.19634955f);
            }
        }
    }

    @Override
    public void doServerTick() {
        ++this.flameTicks;
        if (this.flameTicks >= 200) {
            if (this.flameCount >= 4) {
                this.dragon.getPhaseManager().setPhase(BabyEnderDragonPhase.TAKEOFF);
            } else {
                this.dragon.getPhaseManager().setPhase(BabyEnderDragonPhase.SITTING_SCANNING);
            }
        } else if (this.flameTicks == 10) {
            double d2;
            Vec3 vec3 = new Vec3(this.dragon.head.m_20185_() - this.dragon.m_20185_(), 0.0, this.dragon.head.m_20189_() - this.dragon.m_20189_()).m_82541_();
            double d0 = this.dragon.head.m_20185_() + vec3.f_82479_ * 5.0 / 2.0;
            double d1 = this.dragon.head.m_20189_() + vec3.f_82481_ * 5.0 / 2.0;
            double d3 = d2 = this.dragon.head.m_20227_(0.5);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(d0, d2, d1);
            while (this.dragon.m_9236_().m_46859_((BlockPos)blockpos$mutableblockpos)) {
                if ((d3 -= 1.0) < 0.0) {
                    d3 = d2;
                    break;
                }
                blockpos$mutableblockpos.m_122169_(d0, d3, d1);
            }
            d3 = Mth.m_14107_((double)d3) + 1;
            this.flame = new AreaEffectCloud(this.dragon.m_9236_(), d0, d3, d1);
            this.flame.m_19718_((LivingEntity)this.dragon);
            this.flame.m_19712_(5.0f);
            this.flame.m_19734_(200);
            this.flame.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
            this.flame.m_19716_(new MobEffectInstance(MobEffects.f_19602_));
            this.dragon.m_9236_().m_7967_((Entity)this.flame);
        }
    }

    @Override
    public void begin() {
        this.flameTicks = 0;
        ++this.flameCount;
    }

    @Override
    public void end() {
        if (this.flame != null) {
            this.flame.m_146870_();
            this.flame = null;
        }
    }

    public BabyEnderDragonPhase<BabyDragonSittingFlamingPhase> getPhase() {
        return BabyEnderDragonPhase.SITTING_FLAMING;
    }

    public void resetFlameCount() {
        this.flameCount = 0;
    }
}

