/*
 * Decompiled with CFR 0.152.
 */
package starcrop.babydragon;

import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import starcrop.Register;
import starcrop.babydragon.BabyDragonPhaseInstance;
import starcrop.babydragon.BabyEnderDragonPart;
import starcrop.babydragon.BabyEnderDragonPhase;
import starcrop.babydragon.BabyEnderDragonPhaseManager;
import starcrop.babydragon.ConvertEntity;

public class BabyEnderDragon
extends ConvertEntity {
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.m_135353_(BabyEnderDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(BabyEnderDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> DATA_AGE = SynchedEntityData.m_135353_(BabyEnderDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public final double[][] positions = new double[64][3];
    public int posPointer = -1;
    private final BabyEnderDragonPart[] subEntities;
    public final BabyEnderDragonPart head;
    private final BabyEnderDragonPart neck;
    private final BabyEnderDragonPart body;
    private final BabyEnderDragonPart tail1;
    private final BabyEnderDragonPart tail2;
    private final BabyEnderDragonPart tail3;
    private final BabyEnderDragonPart wing1;
    private final BabyEnderDragonPart wing2;
    private final BabyEnderDragonPhaseManager phaseManager;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public float yRotA;
    private int growlTime = 100;
    private final EntityDimensions size;
    TemptGoal temp;

    public BabyEnderDragon(EntityType<? extends BabyEnderDragon> p_31096_, Level p_31097_) {
        super((EntityType<? extends ConvertEntity>)((EntityType)Register.dragon_baby.get()), p_31097_);
        this.size = EntityDimensions.m_20395_((float)(p_31096_.m_20680_().f_20377_ * this.Scale()), (float)(p_31096_.m_20680_().f_20378_ * this.Scale()));
        this.m_6210_();
        this.head = new BabyEnderDragonPart(this, "head", 1.0f * this.Scale(), 1.0f * this.Scale());
        this.neck = new BabyEnderDragonPart(this, "neck", 3.0f * this.Scale(), 3.0f * this.Scale());
        this.body = new BabyEnderDragonPart(this, "body", 5.0f * this.Scale(), 3.0f * this.Scale());
        this.tail1 = new BabyEnderDragonPart(this, "tail", 2.0f * this.Scale(), 2.0f * this.Scale());
        this.tail2 = new BabyEnderDragonPart(this, "tail", 2.0f * this.Scale(), 2.0f * this.Scale());
        this.tail3 = new BabyEnderDragonPart(this, "tail", 2.0f * this.Scale(), 2.0f * this.Scale());
        this.wing1 = new BabyEnderDragonPart(this, "wing", 4.0f * this.Scale(), 2.0f * this.Scale());
        this.wing2 = new BabyEnderDragonPart(this, "wing", 4.0f * this.Scale(), 2.0f * this.Scale());
        this.subEntities = new BabyEnderDragonPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.m_21153_(this.m_21233_());
        this.f_19794_ = true;
        this.f_19811_ = true;
        this.phaseManager = new BabyEnderDragonPhaseManager(this);
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        this.f_21342_ = new DragonMoveControl(this);
        this.m_20011_(new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + (double)this.size.f_20377_, this.m_20186_() + (double)this.size.f_20378_, this.m_20189_() + (double)this.size.f_20377_));
    }

    protected void m_8099_() {
        this.temp = new TemptGoal(this, Ingredient.m_204132_((TagKey)ItemTags.f_13156_), false);
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal(this, 0.1));
        this.f_21345_.m_25352_(3, (Goal)this.temp);
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new DragonShootFireball(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomFloatAroundGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public InteractionResult m_6071_(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.m_21120_(p_30413_);
        if (itemstack.m_204117_(ItemTags.f_13156_)) {
            if (this.m_269323_() == null && this.m_269323_() != p_30412_ || this.m_21223_() < this.m_21233_()) {
                itemstack.m_41774_(1);
                if (this.m_269323_() != p_30412_) {
                    if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_30412_)) {
                        if (this.m_269323_() != p_30412_) {
                            this.m_21828_(p_30412_);
                        }
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                }
                if (this.m_21223_() < this.m_21233_()) {
                    this.growUp();
                    this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                }
                if (this.m_9236_().m_5776_()) {
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.SUCCESS;
            }
            return super.m_6071_(p_30412_, p_30413_);
        }
        return super.m_6071_(p_30412_, p_30413_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_PHASE, (Object)BabyEnderDragonPhase.HOVERING.getId());
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_AGE, (Object)Float.valueOf(1.0f));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (source.m_7639_() != null && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            double x = attacker.m_20185_();
            double y = attacker.m_20186_();
            double z = attacker.m_20189_();
            Player nearestPlayer = this.m_9236_().m_45930_((Entity)attacker, 20.0);
            Vec3 directionVector = attacker.m_20182_().m_82546_(this.m_20182_()).m_82541_();
            double angle = Math.atan2(directionVector.f_82481_, directionVector.f_82479_);
            double offsetX = Math.cos(angle) * 20.0;
            double offsetZ = Math.sin(angle) * 20.0;
            x = nearestPlayer.m_20185_() - offsetX;
            z = nearestPlayer.m_20189_() - offsetZ;
            if (this.m_9236_().m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_60795_()) {
                this.teleport(x, y, z);
            }
        }
        return super.m_6469_(source, amount);
    }

    protected boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        this.m_6021_(p_32544_, p_32545_, p_32546_);
        this.m_9236_().m_214171_(GameEvent.f_238175_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
        return true;
    }

    public float Scale() {
        return 0.25f * (float)this.m_146764_();
    }

    public EntityDimensions m_6972_(Pose p_31023_) {
        return this.size;
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_20235_ + i + 1);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0);
    }

    public boolean m_142039_() {
        float f = Mth.m_14089_((float)(this.flapTime * ((float)Math.PI * 2)));
        float f1 = Mth.m_14089_((float)(this.oFlapTime * ((float)Math.PI * 2)));
        return f1 <= -0.3f && f >= -0.3f;
    }

    public void m_142043_() {
        if (this.m_9236_().m_5776_() && !this.m_20067_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11893_, this.m_5720_(), 5.0f * this.m_6134_(), (0.8f + this.f_19796_.m_188501_() * 0.3f) * this.m_6134_(), false);
        }
    }

    public double[] getLatencyPos(int p_31102_, float p_31103_) {
        if (this.m_21224_()) {
            p_31103_ = 0.0f;
        }
        p_31103_ = 1.0f - p_31103_;
        int i = this.posPointer - p_31102_ & 0x3F;
        int j = this.posPointer - p_31102_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.positions[i][0];
        double d1 = Mth.m_14175_((double)(this.positions[j][0] - d0));
        adouble[0] = d0 + d1 * (double)p_31103_;
        d0 = this.positions[i][1];
        d1 = this.positions[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_31103_;
        adouble[2] = Mth.m_14139_((double)p_31103_, (double)this.positions[i][2], (double)this.positions[j][2]);
        return adouble;
    }

    public void m_8107_() {
        this.m_146874_();
        if (this.m_9236_().m_5776_()) {
            this.m_21153_(this.m_21223_());
            if (!this.m_20067_() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11894_, this.m_5720_(), 2.5f * this.m_6134_(), (0.8f + this.f_19796_.m_188501_() * 0.3f) * this.m_6134_(), false);
                this.growlTime = 200 + this.f_19796_.m_188503_(200);
            }
        }
        this.oFlapTime = this.flapTime;
        if (!this.m_21224_()) {
            Vec3 vec34 = this.m_20184_();
            float f9 = 0.2f / ((float)vec34.m_165924_() * 10.0f + 1.0f);
            this.flapTime = this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (this.inWall ? (this.flapTime += f9 * 0.5f) : (this.flapTime += (f9 *= (float)Math.pow(2.0, vec34.f_82480_))));
            this.m_146922_(Mth.m_14177_((float)this.m_146908_()));
            if (this.m_21525_()) {
                this.flapTime = 0.5f;
            } else {
                if (this.posPointer < 0) {
                    for (int i = 0; i < this.positions.length; ++i) {
                        this.positions[i][0] = this.m_146908_();
                        this.positions[i][1] = this.m_20186_();
                    }
                }
                if (++this.posPointer == this.positions.length) {
                    this.posPointer = 0;
                }
                this.positions[this.posPointer][0] = this.m_146908_();
                this.positions[this.posPointer][1] = this.m_20186_();
                if (this.m_9236_().m_5776_()) {
                    if (this.f_20903_ > 0) {
                        double d6 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
                        double d0 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
                        double d1 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
                        double d2 = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
                        this.m_146922_(this.m_146908_() + (float)d2 / (float)this.f_20903_);
                        this.m_146926_(this.m_146909_() + (float)(this.f_20908_ - (double)this.m_146909_()) / (float)this.f_20903_);
                        --this.f_20903_;
                        this.m_6034_(d6, d0, d1);
                        this.m_19915_(this.m_146908_(), this.m_146909_());
                    }
                    this.phaseManager.getCurrentPhase().doClientTick();
                } else {
                    BabyDragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
                    dragonphaseinstance.doServerTick();
                    if (this.phaseManager.getCurrentPhase() != dragonphaseinstance) {
                        dragonphaseinstance = this.phaseManager.getCurrentPhase();
                        dragonphaseinstance.doServerTick();
                    }
                }
                this.f_20883_ = this.m_146908_();
                Vec3[] avec3 = new Vec3[this.subEntities.length];
                for (int j = 0; j < this.subEntities.length; ++j) {
                    avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
                }
                float f12 = (float)(this.getLatencyPos(5, this.Scale())[1] - this.getLatencyPos(10, this.Scale())[1]) * 10.0f * ((float)Math.PI / 180);
                float f13 = Mth.m_14089_((float)f12);
                float f = Mth.m_14031_((float)f12);
                float f14 = this.m_146908_() * ((float)Math.PI / 180);
                float f1 = Mth.m_14031_((float)f14);
                float f15 = Mth.m_14089_((float)f14);
                this.tickPart(this.body, f1 * 0.5f * this.Scale(), 0.0, -f15 * 0.5f * this.Scale());
                this.tickPart(this.wing1, f15 * 4.5f * this.Scale(), 2.0 * (double)this.Scale(), f1 * 4.5f * this.Scale());
                this.tickPart(this.wing2, f15 * -4.5f * this.Scale(), 2.0 * (double)this.Scale(), f1 * -4.5f * this.Scale());
                float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f16 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f3 = this.getHeadYOffset();
                this.tickPart(this.head, f2 * 6.5f * f13 * this.Scale(), (f3 + f * 6.5f) * this.Scale(), -f16 * 6.5f * f13 * this.Scale());
                this.tickPart(this.neck, f2 * 6.5f * f13 * this.Scale(), (f3 + f * 5.5f) * this.Scale(), -f16 * 5.5f * f13 * this.Scale());
                double[] adouble = this.getLatencyPos(5, this.Scale());
                for (int k = 0; k < 3; ++k) {
                    BabyEnderDragonPart testEnderDragonPart = null;
                    if (k == 0) {
                        testEnderDragonPart = this.tail1;
                    }
                    if (k == 1) {
                        testEnderDragonPart = this.tail2;
                    }
                    if (k == 2) {
                        testEnderDragonPart = this.tail3;
                    }
                    double[] adouble1 = this.getLatencyPos(12 + k * 2, this.Scale());
                    float f17 = this.m_146908_() * ((float)Math.PI / 180) + this.rotWrap(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f18 = Mth.m_14031_((float)f17);
                    float f20 = Mth.m_14089_((float)f17);
                    float f22 = (float)(k + 1) * 2.0f * this.Scale();
                    this.tickPart(testEnderDragonPart, -(f1 * (1.5f * this.Scale()) + f18 * f22) * f13, adouble1[1] - adouble[1] - (double)((f22 + 1.5f) * f * this.Scale()) + 1.5 * (double)this.Scale(), (f15 * (1.5f * this.Scale()) + f20 * f22) * f13);
                }
                if (!this.m_9236_().m_5776_()) {
                    this.inWall = this.checkWalls(this.head.m_20191_()) | this.checkWalls(this.neck.m_20191_()) | this.checkWalls(this.body.m_20191_());
                }
                for (int l = 0; l < this.subEntities.length; ++l) {
                    this.subEntities[l].f_19854_ = avec3[l].f_82479_;
                    this.subEntities[l].f_19855_ = avec3[l].f_82480_;
                    this.subEntities[l].f_19856_ = avec3[l].f_82481_;
                    this.subEntities[l].f_19790_ = avec3[l].f_82479_;
                    this.subEntities[l].f_19791_ = avec3[l].f_82480_;
                    this.subEntities[l].f_19792_ = avec3[l].f_82481_;
                }
            }
        }
        super.m_8107_();
    }

    private void tickPart(BabyEnderDragonPart p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.m_6034_(this.m_20185_() - p_31117_, this.m_20186_() + p_31118_, this.m_20189_() - p_31119_);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        double[] adouble = this.getLatencyPos(5, 1.0f);
        double[] adouble1 = this.getLatencyPos(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private float rotWrap(double p_31165_) {
        return (float)Mth.m_14175_((double)p_31165_);
    }

    private boolean checkWalls(AABB p_31140_) {
        int i = Mth.m_14107_((double)p_31140_.f_82288_);
        int j = Mth.m_14107_((double)p_31140_.f_82289_);
        int k = Mth.m_14107_((double)p_31140_.f_82290_);
        int l = Mth.m_14107_((double)p_31140_.f_82291_);
        int i1 = Mth.m_14107_((double)p_31140_.f_82292_);
        int j1 = Mth.m_14107_((double)p_31140_.f_82293_);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (blockstate.m_60795_() || blockstate.m_204336_(BlockTags.f_215822_)) continue;
                    if (ForgeHooks.canEntityDestroy((Level)this.m_9236_(), (BlockPos)blockpos, (LivingEntity)this) && !blockstate.m_204336_(BlockTags.f_13069_)) {
                        flag1 = false;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.f_19796_.m_188503_(l - i + 1), j + this.f_19796_.m_188503_(i1 - j + 1), k + this.f_19796_.m_188503_(j1 - k + 1));
            this.m_9236_().m_46796_(2008, blockpos1, 0);
        }
        return flag;
    }

    public void m_7380_(CompoundTag p_31144_) {
        super.m_7380_(p_31144_);
        p_31144_.m_128350_("Age", ((Float)this.f_19804_.m_135370_(DATA_AGE)).floatValue());
        p_31144_.m_128405_("DragonPhase", this.phaseManager.getCurrentPhase().getPhase().getId());
    }

    public void m_7378_(CompoundTag p_31134_) {
        this.setAge(p_31134_.m_128457_("Age"));
        super.m_7378_(p_31134_);
        if (p_31134_.m_128441_("DragonPhase")) {
            this.phaseManager.setPhase(BabyEnderDragonPhase.getById(p_31134_.m_128451_("DragonPhase")));
        }
    }

    public boolean hurt(BabyEnderDragonPart p_31121_, DamageSource p_31122_, float p_31123_) {
        if (this.phaseManager.getCurrentPhase().getPhase() == BabyEnderDragonPhase.DYING) {
            return false;
        }
        p_31123_ = this.phaseManager.getCurrentPhase().onHurt(p_31122_, p_31123_);
        if (p_31121_ != this.head) {
            p_31123_ = p_31123_ / 4.0f + Math.min(p_31123_, 1.0f);
        }
        if (p_31123_ < 0.01f) {
            return false;
        }
        if (p_31122_.m_7639_() instanceof Player || p_31122_.m_269533_(DamageTypeTags.f_273821_)) {
            this.reallyHurt(p_31122_, p_31123_);
            if (this.m_21224_() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.m_21153_(1.0f);
                this.phaseManager.setPhase(BabyEnderDragonPhase.DYING);
            }
        }
        return true;
    }

    protected boolean reallyHurt(DamageSource p_31162_, float p_31163_) {
        return super.m_6469_(p_31162_, p_31163_);
    }

    public BabyEnderDragonPart[] getSubEntities() {
        return this.subEntities;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11890_;
    }

    protected SoundEvent m_7975_(DamageSource p_31154_) {
        return SoundEvents.f_11895_;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public float getHeadPartYOffset(int p_31109_, double[] p_31110_, double[] p_31111_) {
        double d0;
        BabyDragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
        BabyEnderDragonPhase<? extends BabyDragonPhaseInstance> enderdragonphase = dragonphaseinstance.getPhase();
        if (enderdragonphase != BabyEnderDragonPhase.LANDING && enderdragonphase != BabyEnderDragonPhase.TAKEOFF) {
            d0 = dragonphaseinstance.isSitting() ? (double)p_31109_ : (p_31109_ == 6 ? 0.0 : p_31111_[1] - p_31110_[1]);
        } else {
            BlockPos blockpos = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.m_287210_((BlockPos)BlockPos.f_121853_));
            double d1 = Math.max(Math.sqrt(blockpos.m_203193_((Position)this.m_20182_())) / 4.0, 1.0);
            d0 = (double)p_31109_ / d1;
        }
        return (float)d0;
    }

    public Vec3 getHeadLookVector(float p_31175_) {
        Vec3 vec3;
        BabyDragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
        BabyEnderDragonPhase<? extends BabyDragonPhaseInstance> enderdragonphase = dragonphaseinstance.getPhase();
        if (enderdragonphase != BabyEnderDragonPhase.LANDING && enderdragonphase != BabyEnderDragonPhase.TAKEOFF) {
            if (dragonphaseinstance.isSitting()) {
                float f4 = this.m_146909_();
                this.m_146926_(-45.0f);
                vec3 = this.m_20252_(p_31175_);
                this.m_146926_(f4);
            } else {
                vec3 = this.m_20252_(p_31175_);
            }
        } else {
            BlockPos blockpos = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.m_287210_((BlockPos)BlockPos.f_121853_));
            float f = Math.max((float)Math.sqrt(blockpos.m_203193_((Position)this.m_20182_())) / 4.0f, 1.0f);
            float f1 = 6.0f / f;
            float f2 = this.m_146909_();
            this.m_146926_(-f1 * 1.5f * 5.0f);
            vec3 = this.m_20252_(p_31175_);
            this.m_146926_(f2);
        }
        return vec3;
    }

    public void m_7350_(EntityDataAccessor<?> p_31136_) {
        if (DATA_PHASE.equals(p_31136_) && this.m_9236_().f_46443_) {
            this.phaseManager.setPhase(BabyEnderDragonPhase.getById((Integer)this.m_20088_().m_135370_(DATA_PHASE)));
        }
        super.m_7350_(p_31136_);
    }

    public BabyEnderDragonPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public boolean m_6779_(LivingEntity p_149576_) {
        return p_149576_.m_142066_();
    }

    public double m_6048_() {
        return this.body.m_20206_();
    }

    public int m_146764_() {
        float a = ((Float)this.f_19804_.m_135370_(DATA_AGE)).floatValue();
        return a < 10.0f ? 1 : (a < 100.0f ? 2 : (a < 1000.0f ? 3 : 4));
    }

    public void setAge(float age) {
        this.f_19804_.m_135381_(DATA_AGE, (Object)Float.valueOf(age));
    }

    public void growUp() {
        float currentAge = ((Float)this.f_19804_.m_135370_(DATA_AGE)).floatValue();
        if (currentAge < 1000.0f) {
            this.setAge(currentAge + 1.0f);
        }
    }

    static class DragonMoveControl
    extends MoveControl {
        private final BabyEnderDragon dragon;
        private int floatDuration;
        protected double Modifierspeed;

        public DragonMoveControl(BabyEnderDragon p_32768_) {
            super((Mob)p_32768_);
            this.dragon = p_32768_;
        }

        public void m_6849_(double p_24984_, double p_24985_, double p_24986_, double p_24987_) {
            super.m_6849_(p_24984_, p_24985_, p_24986_, p_24987_);
            this.Modifierspeed = p_24987_;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.dragon.m_217043_().m_188503_(5) + 2;
                Vec3 vec3 = new Vec3(this.f_24975_ - this.dragon.m_20185_(), this.f_24976_ - this.dragon.m_20186_(), this.f_24977_ - this.dragon.m_20189_());
                double d0 = vec3.m_82553_();
                if (this.canReach(vec3 = vec3.m_82541_(), Mth.m_14165_((double)d0))) {
                    double mosp = 0.1 + this.Modifierspeed;
                    this.dragon.m_20256_(this.dragon.m_20184_().m_82549_(vec3.m_82490_(mosp)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 p_32771_, int p_32772_) {
            AABB aabb = this.dragon.m_20191_();
            for (int i = 1; i < p_32772_; ++i) {
                aabb = aabb.m_82383_(p_32771_);
                if (this.dragon.m_9236_().m_45756_((Entity)this.dragon, aabb)) continue;
                return false;
            }
            return true;
        }
    }

    public class TemptGoal
    extends Goal {
        private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
        private final TargetingConditions targetingConditions;
        protected final BabyEnderDragon dragon;
        private double px;
        private double py;
        private double pz;
        private double pRotX;
        private double pRotY;
        @Nullable
        protected Player player;
        private boolean isRunning;
        private final Ingredient items;
        private final boolean canScare;

        public TemptGoal(BabyEnderDragon p_25939_, Ingredient p_25941_, boolean p_25942_) {
            this.dragon = p_25939_;
            this.items = p_25941_;
            this.canScare = p_25942_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
        }

        public boolean m_8036_() {
            this.player = this.dragon.m_9236_().m_45946_(this.targetingConditions, (LivingEntity)this.dragon);
            return this.player != null;
        }

        private boolean shouldFollow(LivingEntity p_148139_) {
            return this.items.test(p_148139_.m_21205_()) || this.items.test(p_148139_.m_21206_());
        }

        public boolean m_8045_() {
            if (this.canScare()) {
                if (this.dragon.m_20280_((Entity)this.player) < 36.0) {
                    if (this.player.m_20275_(this.px, this.py, this.pz) > 0.010000000000000002) {
                        return false;
                    }
                    if (Math.abs((double)this.player.m_146909_() - this.pRotX) > 5.0 || Math.abs((double)this.player.m_146908_() - this.pRotY) > 5.0) {
                        return false;
                    }
                } else {
                    this.px = this.player.m_20185_();
                    this.py = this.player.m_20186_();
                    this.pz = this.player.m_20189_();
                }
                this.pRotX = this.player.m_146909_();
                this.pRotY = this.player.m_146908_();
            }
            return this.m_8036_();
        }

        protected boolean canScare() {
            return this.canScare;
        }

        public void m_8056_() {
            this.px = this.player.m_20185_();
            this.py = this.player.m_20186_();
            this.pz = this.player.m_20189_();
            this.isRunning = true;
        }

        public void m_8041_() {
            this.player = null;
            this.dragon.m_21573_().m_26573_();
            this.isRunning = false;
        }

        public void m_8037_() {
            if (this.dragon.m_20280_((Entity)this.player) < 9.25) {
                this.dragon.m_21573_().m_26573_();
            } else {
                this.look(this.player);
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        void look(Player target) {
            double d1 = target.m_20185_() - this.dragon.m_20185_();
            double d2 = target.m_20189_() - this.dragon.m_20189_();
            this.dragon.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
            this.dragon.f_20883_ = this.dragon.m_146908_();
        }
    }

    class PanicGoal
    extends Goal {
        public static final int WATER_CHECK_DISTANCE_VERTICAL = 1;
        protected final BabyEnderDragon dragon;
        protected final double speedModifier;
        protected double posX;
        protected double posY;
        protected double posZ;
        protected boolean isRunning;

        public PanicGoal(BabyEnderDragon dragon, double p_25692_) {
            this.dragon = dragon;
            this.speedModifier = p_25692_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.shouldPanic()) {
                return this.findRandomPosition();
            }
            if (this.unableToMove()) {
                return false;
            }
            return false;
        }

        private boolean unableToMove() {
            return this.dragon.m_21827_() || this.dragon.m_20159_() || this.dragon.m_21523_();
        }

        protected boolean shouldPanic() {
            return this.dragon.m_21188_() != null || this.dragon.m_203117_();
        }

        protected boolean findRandomPosition() {
            double distance = this.dragon.m_20270_((Entity)this.dragon.m_21188_());
            int far = (int)distance;
            if (far > 21) {
                return false;
            }
            double angle = Math.atan2(this.dragon.m_21188_().m_20185_(), this.dragon.m_21188_().m_20189_());
            double offsetX = Math.cos(angle) * 10.0;
            double offsetZ = Math.sin(angle) * 10.0;
            this.posX = this.dragon.m_20185_() - offsetX;
            this.posY = this.dragon.m_20186_();
            this.posZ = this.dragon.m_20189_() - offsetZ;
            return true;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void m_8056_() {
            if (!this.dragon.temp.isRunning()) {
                if (!this.dragon.m_9236_().m_8055_(BlockPos.m_274561_((double)this.posX, (double)this.posY, (double)this.posZ)).m_60795_()) {
                    this.m_8041_();
                } else {
                    this.look(this.posX, this.posZ);
                    ((DragonMoveControl)this.dragon.m_21566_()).m_6849_(this.posX, this.posY, this.posZ, this.speedModifier);
                }
            }
            this.isRunning = true;
        }

        public void m_8041_() {
            this.isRunning = false;
        }

        void look(double x, double z) {
            double d1 = x - this.dragon.m_20185_();
            double d2 = z - this.dragon.m_20189_();
            this.dragon.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
            this.dragon.f_20883_ = this.dragon.m_146908_();
        }

        public boolean m_8045_() {
            return !this.dragon.m_21573_().m_26571_();
        }
    }

    class FollowOwnerGoal
    extends Goal {
        public static final int TELEPORT_WHEN_DISTANCE_IS = 12;
        private final BabyEnderDragon dragon;
        private LivingEntity owner;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private float oldWaterCost;
        double x;
        double y;
        double z;

        public FollowOwnerGoal(BabyEnderDragon p_25294_) {
            this.dragon = p_25294_;
            this.navigation = p_25294_.m_21573_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.dragon.m_269323_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            if (this.dragon.m_5448_() != null) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            return !this.unableToMove();
        }

        private boolean unableToMove() {
            return this.dragon.m_21827_() || this.dragon.m_20159_() || this.dragon.m_5448_() != null;
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.dragon.m_21439_(BlockPathTypes.WATER);
            this.dragon.m_21441_(BlockPathTypes.WATER, 0.0f);
            this.x = this.owner.m_20185_() + (double)this.randPos(40);
            this.y = this.owner.m_20186_() + (double)(26 + this.randPos(20));
            this.z = this.owner.m_20189_() + (double)this.randPos(40);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            this.dragon.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            if (!this.dragon.m_21523_()) {
                this.look(this.owner.m_20185_(), this.owner.m_20189_());
                if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = this.m_183277_(10);
                    if (this.dragon.m_20280_((Entity)this.owner) > 586.0) {
                        this.dragon.teleport(this.x, this.y, this.z);
                    } else {
                        ((DragonMoveControl)this.dragon.m_21566_()).m_6849_(this.x, this.y, this.z, 0.22);
                    }
                }
            }
        }

        int randPos(int max) {
            return -20 + this.dragon.m_217043_().m_188503_(max);
        }

        void look(double x, double z) {
            double d1 = x - this.dragon.m_20185_();
            double d2 = z - this.dragon.m_20189_();
            this.dragon.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
            this.dragon.f_20883_ = this.dragon.m_146908_();
        }
    }

    class DragonShootFireball
    extends Goal {
        private final BabyEnderDragon dragon;
        public int chargeTime;

        public DragonShootFireball(BabyEnderDragon p_32776_) {
            this.dragon = p_32776_;
        }

        public boolean m_8036_() {
            return this.dragon.m_5448_() != null && !this.dragon.m_20159_() && !this.dragon.m_21523_();
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.dragon.m_5448_();
            if (livingentity != null) {
                this.look(livingentity.m_20185_(), livingentity.m_20189_());
                if (livingentity.m_20280_((Entity)this.dragon) < 4096.0 && this.dragon.m_142582_((Entity)livingentity)) {
                    Level level = this.dragon.m_9236_();
                    ++this.chargeTime;
                    if (this.chargeTime == 10) {
                        Vec3 vec3 = this.dragon.m_20252_(1.0f);
                        double d2 = livingentity.m_20185_() - (this.dragon.m_20185_() + vec3.f_82479_ * 4.0);
                        double d3 = livingentity.m_20227_(0.5) - (0.5 + this.dragon.m_20227_(0.5));
                        double d4 = livingentity.m_20189_() - (this.dragon.m_20189_() + vec3.f_82481_ * 4.0);
                        SmallFireball smallfireball = this.dragon.m_146764_() < 2 ? new SmallFireball(level, (LivingEntity)this.dragon, d2, d3, d4) : (this.dragon.m_146764_() < 3 ? new LargeFireball(level, (LivingEntity)this.dragon, d2, d3, d4, 1) : new DragonFireball(level, (LivingEntity)this.dragon, d2, d3, d4));
                        smallfireball.m_6034_(this.dragon.m_20185_() + vec3.f_82479_ * 4.0, this.dragon.m_20227_(0.5) + 0.5, smallfireball.m_20189_() + vec3.f_82481_ * 4.0);
                        level.m_7967_((Entity)smallfireball);
                        this.chargeTime = -40;
                    }
                } else {
                    ((DragonMoveControl)this.dragon.m_21566_()).m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 0.22);
                }
            }
        }

        void look(double x, double z) {
            double d1 = x - this.dragon.m_20185_();
            double d2 = z - this.dragon.m_20189_();
            this.dragon.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
            this.dragon.f_20883_ = this.dragon.m_146908_();
        }
    }

    static class RandomFloatAroundGoal
    extends Goal {
        private final BabyEnderDragon dragon;

        public RandomFloatAroundGoal(BabyEnderDragon p_32783_) {
            this.dragon = p_32783_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movecontrol = this.dragon.m_21566_();
            if (!movecontrol.m_24995_()) {
                return true;
            }
            if (this.unableToMove()) {
                return false;
            }
            if (this.dragon.m_269323_() != null) {
                return false;
            }
            double d0 = movecontrol.m_25000_() - this.dragon.m_20185_();
            double d3 = d0 * d0 + (d1 = movecontrol.m_25001_() - this.dragon.m_20186_()) * d1 + (d2 = movecontrol.m_25002_() - this.dragon.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        private boolean unableToMove() {
            return this.dragon.m_21827_() || this.dragon.m_20159_() || this.dragon.m_21523_();
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource randomsource = this.dragon.m_217043_();
            double d0 = this.dragon.m_20185_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.dragon.m_20186_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.dragon.m_20189_() + (double)((randomsource.m_188501_() * 2.0f - 1.0f) * 16.0f);
            if (!this.dragon.temp.isRunning() && this.dragon.m_269323_() == null) {
                this.look(d0, d2);
                ((DragonMoveControl)this.dragon.m_21566_()).m_6849_(d0, d1, d2, 0.0);
            }
        }

        void look(double x, double z) {
            double d1 = x - this.dragon.m_20185_();
            double d2 = z - this.dragon.m_20189_();
            this.dragon.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
            this.dragon.f_20883_ = this.dragon.m_146908_();
        }
    }
}

