/*
 * Decompiled with CFR 0.152.
 */
package starcrop.babydragon;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import starcrop.babydragon.BabyDragonPhaseInstance;
import starcrop.babydragon.BabyEnderDragon;
import starcrop.babydragon.BabyEnderDragonPhase;

public class BabyEnderDragonPhaseManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BabyEnderDragon dragon;
    private final BabyDragonPhaseInstance[] phases = new BabyDragonPhaseInstance[BabyEnderDragonPhase.getCount()];
    @Nullable
    private BabyDragonPhaseInstance currentPhase;

    public BabyEnderDragonPhaseManager(BabyEnderDragon p_31414_) {
        this.dragon = p_31414_;
        this.setPhase(BabyEnderDragonPhase.HOVERING);
    }

    public void setPhase(BabyEnderDragonPhase<?> p_31417_) {
        if (this.currentPhase == null || p_31417_ != this.currentPhase.getPhase()) {
            if (this.currentPhase != null) {
                this.currentPhase.end();
            }
            this.currentPhase = this.getPhase(p_31417_);
            if (!this.dragon.m_9236_().f_46443_) {
                this.dragon.m_20088_().m_135381_(BabyEnderDragon.DATA_PHASE, (Object)p_31417_.getId());
            }
            LOGGER.debug("Dragon is now in phase {} on the {}", p_31417_, (Object)(this.dragon.m_9236_().f_46443_ ? "client" : "server"));
            this.currentPhase.begin();
        }
    }

    public BabyDragonPhaseInstance getCurrentPhase() {
        return this.currentPhase;
    }

    public <T extends BabyDragonPhaseInstance> T getPhase(BabyEnderDragonPhase<T> p_31419_) {
        int i = p_31419_.getId();
        if (this.phases[i] == null) {
            this.phases[i] = p_31419_.createInstance(this.dragon);
        }
        return (T)this.phases[i];
    }
}

