/*
 * Decompiled with CFR 0.152.
 */
package starcrop.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import starcrop.Register;
import starcrop.VoxelShapeHelper;
import starcrop.block.TileEntityEggNest;

public class EggNest
extends Block
implements EntityBlock {
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalDirectionalBlock.f_54117_;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public EggNest() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60955_());
        this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH);
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        TileEntityEggNest tileentity = (TileEntityEggNest)worldIn.m_7702_(pos);
        if (tileentity instanceof TileEntityEggNest) {
            if (tileentity.m_8020_(0).m_41619_()) {
                if (player.m_21120_(handIn).m_41720_() == Items.f_42521_ || player.m_21120_(handIn).m_41720_() == Items.f_42279_ || player.m_21120_(handIn).m_41720_() == Items.f_42104_) {
                    if (player.m_21120_(handIn).m_41613_() == 1) {
                        tileentity.m_6836_(0, player.m_21120_(handIn));
                        player.m_21008_(handIn, new ItemStack((ItemLike)Items.f_41852_));
                    } else {
                        tileentity.m_6836_(0, player.m_21120_(handIn));
                        player.m_21120_(handIn).m_41764_(player.m_21120_(handIn).m_41613_() - 1);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] Main = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)3.4, (double)0.0, (double)3.4, (double)12.6, (double)6.8, (double)12.6), Direction.NORTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(Main[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new TileEntityEggNest(p_153215_, p_153216_);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153273_, BlockState p_153274_, BlockEntityType<T> p_153275_) {
        return EggNest.createFurnaceTicker(p_153273_, p_153275_, (BlockEntityType<? extends TileEntityEggNest>)((BlockEntityType)Register.TileEntityEggNest.get()));
    }

    protected static <T extends BlockEntity> BlockEntityTicker<T> createFurnaceTicker(Level p_151988_, BlockEntityType<T> p_151989_, BlockEntityType<? extends TileEntityEggNest> p_151990_) {
        return EggNest.createTickerHelper(p_151989_, p_151990_, TileEntityEggNest::serverTick);
    }

    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }
}

