/*
 * Decompiled with CFR 0.152.
 */
package starcrop.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.util.ITeleporter;
import starcrop.Register;

public class FrozenHellPortal
extends NetherPortalBlock {
    public FrozenHellPortal() {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_60977_().m_60978_(-1.0f).m_60918_(SoundType.f_56744_).m_60953_(p_50870_ -> 11));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.m_123341_() + rand.m_188500_();
        double d1 = (double)pos.m_123342_() + 0.8;
        double d2 = (double)pos.m_123343_() + rand.m_188500_();
        level.m_7106_((ParticleOptions)Register.frozen_hell_portal.get(), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
            ArrayList<BlockState> stateList = new ArrayList<BlockState>();
            BlockPos doors = pos.m_7495_().m_122012_().m_122024_();
            for (int y = 0; y < 4; ++y) {
                BlockPos doorsY = doors.m_6630_(y);
                for (int z = 0; z < 3; ++z) {
                    BlockPos doorsZ = doorsY.m_122020_(z);
                    for (int x = 0; x < 3; ++x) {
                        posList.add(doorsZ.m_122030_(x));
                        stateList.add(level.m_8055_(doorsZ.m_122030_(x)));
                    }
                }
            }
            if (!entity.m_20092_()) {
                ResourceKey<Level> worldID = player.m_9236_().m_46472_() == Register.FrozenHellWorld ? Level.f_46428_ : Register.FrozenHellWorld;
                FrozenHellPortal.teleportTo(player, player.m_20183_(), worldID, posList, stateList);
                entity.m_20091_();
            } else {
                entity.m_20091_();
            }
        }
    }

    private static void teleportTo(ServerPlayer player, BlockPos pos, ResourceKey<Level> id, List<BlockPos> posList, List<BlockState> stateList) {
        ServerLevel world = player.m_20194_().m_129880_(id);
        FrozenHellPortal.teleport(player, world, pos, false);
        FrozenHellPortal.createportal(world, posList, stateList);
    }

    static void createportal(ServerLevel level, List<BlockPos> posList, List<BlockState> stateList) {
        int i;
        for (i = 0; i < posList.size(); ++i) {
            if (stateList.get(i).m_60734_() == Register.frozen_hell_partal.get()) continue;
            level.m_7731_(posList.get(i), stateList.get(i), 3);
        }
        for (i = 0; i < posList.size(); ++i) {
            if (stateList.get(i).m_60734_() != Register.frozen_hell_partal.get()) continue;
            level.m_7731_(posList.get(i), stateList.get(i), 3);
        }
    }

    public static void teleport(ServerPlayer entity, final ServerLevel destination, final BlockPos pos, final boolean findTop) {
        entity.changeDimension(destination, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                entity = repositionEntity.apply(false);
                int y = pos.m_123342_();
                if (findTop) {
                    y = destination.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_());
                }
                entity.m_6021_((double)pos.m_123341_(), (double)y, (double)pos.m_123343_());
                return entity;
            }
        });
    }
}

