/*
 * Decompiled with CFR 0.152.
 */
package starcrop.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import starcrop.Register;
import starcrop.VoxelShapeHelper;
import starcrop.block.TileEntityLeavesBanana;

public class LeavesBanana
extends Block
implements EntityBlock {
    protected static boolean renderTranslucent;
    public static final DirectionProperty FACING;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public LeavesBanana() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.2f).m_60918_(SoundType.f_56740_).m_60977_());
        this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
        ((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61408_, (Comparable)Integer.valueOf(5));
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] Main = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)0.0, (double)7.5, (double)16.0, (double)16.0, (double)8.5), Direction.NORTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(Main[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (worldIn.m_46758_(pos.m_7494_()) && rand.m_188503_(15) == 1 && !(blockstate = worldIn.m_8055_(blockpos = pos.m_7495_())).m_60804_((BlockGetter)worldIn, blockpos)) {
            double d0 = (float)pos.m_123341_() + rand.m_188501_();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (float)pos.m_123343_() + rand.m_188501_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setRenderTranslucent(boolean fancy) {
        renderTranslucent = fancy;
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new TileEntityLeavesBanana(p_153215_, p_153216_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState generate(Direction de) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)de);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61408_});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153273_, BlockState p_153274_, BlockEntityType<T> p_153275_) {
        return LeavesBanana.createFurnaceTicker(p_153273_, p_153275_, (BlockEntityType<? extends TileEntityLeavesBanana>)((BlockEntityType)Register.TileEntityLeavesBanana.get()));
    }

    protected static <T extends BlockEntity> BlockEntityTicker<T> createFurnaceTicker(Level p_151988_, BlockEntityType<T> p_151989_, BlockEntityType<? extends TileEntityLeavesBanana> p_151990_) {
        return p_151988_.f_46443_ ? null : LeavesBanana.createTickerHelper(p_151989_, p_151990_, TileEntityLeavesBanana::serverTick);
    }

    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    static {
        FACING = HorizontalDirectionalBlock.f_54117_;
    }
}

