/*
 * Decompiled with CFR 0.152.
 */
package starcrop.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import realsurvivor.DataFake;
import realsurvivor.network.Dispatcher;
import realsurvivor.network.server.PacketServerSetEnergy;
import starcrop.VoxelShapeHelper;

public class TeaCake
extends Block {
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)4);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());

    public TeaCake() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56745_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(4)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_36324_().m_38721_() && !player.m_7500_()) {
            int i;
            player.m_36324_().m_38707_(2, 0.1f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 2400));
            worldIn.m_5594_(player, pos, SoundEvents.f_11912_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ArrayList<String> modlist = new ArrayList<String>();
            for (IModInfo info : ModList.get().getMods()) {
                modlist.add(info.getModId());
            }
            if (modlist.contains("realsurvivor")) {
                DataFake data = new DataFake();
                if (data.getEnergy() <= 13) {
                    Dispatcher.sendToServer((Object)new PacketServerSetEnergy(data.getEnergy() + 7));
                } else {
                    Dispatcher.sendToServer((Object)new PacketServerSetEnergy(20));
                }
            }
            if ((i = ((Integer)state.m_61143_((Property)BITES)).intValue()) == 0) {
                worldIn.m_7471_(pos, false);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(i - 1)), 3);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] Main = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)3.2, (double)0.0, (double)3.2, (double)12.8, (double)4.8, (double)12.8), Direction.NORTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(Main[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BITES, (Comparable)((Integer)this.m_49966_().m_61143_((Property)BITES)));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)BITES, (Comparable)((Integer)this.m_49966_().m_61143_((Property)BITES)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{BITES});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

