/*
 * Decompiled with CFR 0.152.
 */
package starcrop.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import starcrop.Bullet;
import starcrop.EntityRangePirate;
import starcrop.Register;
import starcrop.item.BulletItem;

public class FlintLock
extends CrossbowItem {
    public static final int DEFAULT_RANGE = 8;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;

    public FlintLock(Item.Properties p_40850_) {
        super(p_40850_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_40920_, Player p_40921_, InteractionHand p_40922_) {
        ItemStack itemstack = p_40921_.m_21120_(p_40922_);
        ItemStack bulletStack = FlintLock.findAmmo((LivingEntity)p_40921_, (Item)Register.bulletItem.get());
        ItemStack gunpowderStack = FlintLock.findAmmo((LivingEntity)p_40921_, Items.f_42403_);
        if (FlintLock.m_40932_(itemstack)) {
            FlintLock.m_40887_(p_40920_, (LivingEntity)p_40921_, p_40922_, itemstack, FlintLock.getShootingPower(), 1.0f);
            FlintLock.m_40884_(itemstack, false);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!bulletStack.m_41619_() && !gunpowderStack.m_41619_() || p_40921_.m_7500_()) {
            if (!FlintLock.m_40932_(itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                p_40921_.m_6672_(p_40922_);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    private static float getShootingPower() {
        return 4.5f;
    }

    public void m_5551_(ItemStack p_40875_, Level p_40876_, LivingEntity p_40877_, int p_40878_) {
        int i = this.m_8105_(p_40875_) - p_40878_;
        float f = FlintLock.m_40853_(i, p_40875_);
        if (f >= 1.0f && !FlintLock.m_40932_(p_40875_) && FlintLock.tryLoadAmmo(p_40877_, p_40875_)) {
            FlintLock.m_40884_(p_40875_, true);
            SoundSource soundsource = p_40877_ instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            p_40876_.m_6263_((Player)null, p_40877_.m_20185_(), p_40877_.m_20186_(), p_40877_.m_20189_(), (SoundEvent)Register.reload_1.get(), soundsource, 1.0f, 1.0f / (p_40876_.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadAmmo(LivingEntity shooter, ItemStack gunStack) {
        ItemStack gunpowderStack;
        boolean isCreative = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
        ItemStack bulletStack = shooter instanceof Player ? FlintLock.findAmmo(shooter, (Item)Register.bulletItem.get()) : new ItemStack((ItemLike)Register.bulletItem.get());
        ItemStack itemStack = gunpowderStack = shooter instanceof Player ? FlintLock.findAmmo(shooter, Items.f_42403_) : new ItemStack((ItemLike)Items.f_42403_);
        if (!isCreative && (bulletStack.m_41619_() || gunpowderStack.m_41619_())) {
            return false;
        }
        return FlintLock.loadAmmo(shooter, gunStack, bulletStack, gunpowderStack, isCreative);
    }

    private static boolean loadAmmo(LivingEntity shooter, ItemStack gunStack, ItemStack bulletStack, ItemStack gunpowderStack, boolean isCreative) {
        if (!isCreative) {
            bulletStack.m_41774_(1);
            gunpowderStack.m_41774_(1);
        }
        FlintLock.m_40928_(gunStack, new ItemStack((ItemLike)Register.bulletItem.get()));
        return true;
    }

    private static ItemStack findAmmo(LivingEntity entity, Item itemType) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (stack.m_41619_() || stack.m_41720_() != itemType) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean m_40932_(ItemStack p_40933_) {
        CompoundTag compoundtag = p_40933_.m_41783_();
        return compoundtag != null && compoundtag.m_128471_("Charged");
    }

    public static void m_40884_(ItemStack p_40885_, boolean p_40886_) {
        CompoundTag compoundtag = p_40885_.m_41784_();
        compoundtag.m_128379_("Charged", p_40886_);
    }

    private static void m_40928_(ItemStack p_40929_, ItemStack p_40930_) {
        CompoundTag compoundtag = p_40929_.m_41784_();
        ListTag listtag = compoundtag.m_128425_("ChargedProjectiles", 9) ? compoundtag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag compoundtag1 = new CompoundTag();
        p_40930_.m_41739_(compoundtag1);
        listtag.add((Object)compoundtag1);
        compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
    }

    private static List<ItemStack> m_40941_(ItemStack p_40942_) {
        ListTag listtag;
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundtag = p_40942_.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("ChargedProjectiles", 9) && (listtag = compoundtag.m_128437_("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag1 = listtag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundtag1));
            }
        }
        return list;
    }

    private static void m_40943_(ItemStack p_40944_) {
        CompoundTag compoundtag = p_40944_.m_41783_();
        if (compoundtag != null) {
            ListTag listtag = compoundtag.m_128437_("ChargedProjectiles", 9);
            listtag.clear();
            compoundtag.m_128365_("ChargedProjectiles", (Tag)listtag);
        }
    }

    public static boolean m_40871_(ItemStack p_40872_, Item p_40873_) {
        return FlintLock.m_40941_(p_40872_).stream().anyMatch(p_40870_ -> p_40870_.m_150930_(p_40873_));
    }

    private static void m_40894_(Level p_40895_, LivingEntity p_40896_, InteractionHand p_40897_, ItemStack p_40898_, ItemStack p_40899_, float p_40900_, boolean p_40901_, float p_40902_, float p_40903_, float p_40904_) {
        if (!p_40895_.f_46443_) {
            Bullet projectile = FlintLock.getBullet(p_40895_, p_40896_, p_40898_, p_40899_);
            if (p_40896_ instanceof EntityRangePirate) {
                EntityRangePirate crossbowattackmob = (EntityRangePirate)p_40896_;
                crossbowattackmob.shootFlintLockProjectile(crossbowattackmob.m_5448_(), p_40898_, projectile, p_40904_);
            } else {
                Vec3 vec31 = p_40896_.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(p_40904_ * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                Vec3 vec3 = p_40896_.m_20252_(1.0f);
                Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
                projectile.m_6686_(vector3f.x(), vector3f.y(), vector3f.z(), p_40902_, p_40903_);
            }
            p_40895_.m_7967_((Entity)projectile);
            p_40895_.m_6263_((Player)null, p_40896_.m_20185_(), p_40896_.m_20186_(), p_40896_.m_20189_(), (SoundEvent)Register.shoot.get(), SoundSource.PLAYERS, 1.0f, p_40900_);
        }
        Vec3 forward = p_40896_.m_20154_().m_82541_();
        double smokeX = p_40896_.m_20185_() + forward.f_82479_ * 1.0;
        double smokeY = p_40896_.m_20188_() - 0.2;
        double smokeZ = p_40896_.m_20189_() + forward.f_82481_ * 1.0;
        for (int i = 0; i < 10; ++i) {
            double xOffset = (p_40895_.f_46441_.m_188500_() - 0.5) * 0.4;
            double yOffset = p_40895_.f_46441_.m_188500_() * 0.2;
            double zOffset = (p_40895_.f_46441_.m_188500_() - 0.5) * 0.4;
            p_40895_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, smokeX + xOffset, smokeY + yOffset, smokeZ + zOffset, 0.0, 0.02, 0.0);
        }
    }

    private static Bullet getBullet(Level p_40915_, LivingEntity p_40916_, ItemStack p_40917_, ItemStack p_40918_) {
        BulletItem bulletitem = (BulletItem)(p_40918_.m_41720_() instanceof BulletItem ? p_40918_.m_41720_() : (Item)Register.bulletItem.get());
        Bullet bullet = bulletitem.createBullet(p_40915_, p_40918_, p_40916_);
        bullet.setShotFromCrossbow(true);
        return bullet;
    }

    public static void m_40887_(Level p_40888_, LivingEntity p_40889_, InteractionHand p_40890_, ItemStack p_40891_, float p_40892_, float p_40893_) {
        List<ItemStack> list = FlintLock.m_40941_(p_40891_);
        float[] afloat = FlintLock.m_220023_(p_40889_.m_217043_());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = p_40889_ instanceof Player && ((Player)p_40889_).m_150110_().f_35937_;
            if (itemstack.m_41619_()) continue;
            if (i == 0) {
                FlintLock.m_40894_(p_40888_, p_40889_, p_40890_, p_40891_, itemstack, afloat[i], flag, p_40892_, p_40893_, 0.0f);
                continue;
            }
            if (i == 1) {
                FlintLock.m_40894_(p_40888_, p_40889_, p_40890_, p_40891_, itemstack, afloat[i], flag, p_40892_, p_40893_, -10.0f);
                continue;
            }
            if (i != 2) continue;
            FlintLock.m_40894_(p_40888_, p_40889_, p_40890_, p_40891_, itemstack, afloat[i], flag, p_40892_, p_40893_, 10.0f);
        }
        FlintLock.m_40905_(p_40888_, p_40889_, p_40891_);
    }

    private static float[] m_220023_(RandomSource p_220024_) {
        boolean flag = p_220024_.m_188499_();
        return new float[]{1.0f, FlintLock.m_220025_(flag, p_220024_), FlintLock.m_220025_(!flag, p_220024_)};
    }

    private static float m_220025_(boolean p_220026_, RandomSource p_220027_) {
        float f = p_220026_ ? 0.63f : 0.43f;
        return 1.0f / (p_220027_.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static void m_40905_(Level p_40906_, LivingEntity p_40907_, ItemStack p_40908_) {
        if (p_40907_ instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)p_40907_;
            if (!p_40906_.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverplayer, p_40908_);
            }
            serverplayer.m_36246_(Stats.f_12982_.m_12902_((Object)p_40908_.m_41720_()));
        }
        FlintLock.m_40943_(p_40908_);
    }

    public void m_5929_(Level p_40910_, LivingEntity p_40911_, ItemStack p_40912_, int p_40913_) {
        if (!p_40910_.f_46443_) {
            int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)p_40912_);
            SoundEvent soundevent1 = i == 0 ? (SoundEvent)Register.reload_0.get() : null;
            float f = (float)(p_40912_.m_41779_() - p_40913_) / (float)FlintLock.m_40939_(p_40912_);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
            }
            if (f >= 0.5f && soundevent1 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                p_40910_.m_6263_((Player)null, p_40911_.m_20185_(), p_40911_.m_20186_(), p_40911_.m_20189_(), soundevent1, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int m_8105_(ItemStack p_40938_) {
        return FlintLock.m_40939_(p_40938_) + 3;
    }

    public static int m_40939_(ItemStack p_40940_) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)p_40940_);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    public UseAnim m_6164_(ItemStack p_40935_) {
        return UseAnim.CROSSBOW;
    }

    private static float m_40853_(int p_40854_, ItemStack p_40855_) {
        float f = (float)p_40854_ / (float)FlintLock.m_40939_(p_40855_);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void m_7373_(ItemStack p_40880_, @Nullable Level p_40881_, List<Component> p_40882_, TooltipFlag p_40883_) {
        List<ItemStack> list = FlintLock.m_40941_(p_40880_);
        if (FlintLock.m_40932_(p_40880_) && !list.isEmpty()) {
            ItemStack itemstack = list.get(0);
            p_40882_.add((Component)Component.m_237115_((String)"item.minecraft.crossbow.projectile").m_7220_(CommonComponents.f_263701_).m_7220_(itemstack.m_41611_()));
            if (p_40883_.m_7050_() && itemstack.m_150930_(Items.f_42688_)) {
                ArrayList list1 = Lists.newArrayList();
                Items.f_42688_.m_7373_(itemstack, p_40881_, (List)list1, p_40883_);
                if (!list1.isEmpty()) {
                    for (int i = 0; i < list1.size(); ++i) {
                        list1.set(i, Component.m_237113_((String)"  ").m_7220_((Component)list1.get(i)).m_130940_(ChatFormatting.GRAY));
                    }
                    p_40882_.addAll(list1);
                }
            }
        }
    }

    public boolean m_41463_(ItemStack p_150801_) {
        return p_150801_.m_150930_((Item)this);
    }

    public int m_6615_() {
        return 8;
    }
}

