/*
 * Decompiled with CFR 0.152.
 */
package starcrop.magmadragoon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import starcrop.Register;
import starcrop.magmadragoon.MagmaDragonPart;
import starcrop.magmadragoon.MagmaDragonPhase;
import starcrop.magmadragoon.MagmaDragonPhaseInstance;
import starcrop.magmadragoon.MagmaDragonPhaseManager;

public class MagmaDragon
extends Mob
implements Enemy {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.m_135353_(MagmaDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final TargetingConditions CRYSTAL_DESTROY_TARGETING = TargetingConditions.m_148352_().m_26883_(64.0);
    public final double[][] positions = new double[64][3];
    public int posPointer = -1;
    private final MagmaDragonPart[] subEntities;
    public final MagmaDragonPart head;
    private final MagmaDragonPart neck;
    private final MagmaDragonPart body;
    private final MagmaDragonPart tail1;
    private final MagmaDragonPart tail2;
    private final MagmaDragonPart tail3;
    private final MagmaDragonPart wing1;
    private final MagmaDragonPart wing2;
    public float oFlapTime;
    public float flapTime;
    public boolean inWall;
    public int dragonDeathTime;
    public float yRotA;
    @javax.annotation.Nullable
    public EndCrystal nearestCrystal;
    private BlockPos fightOrigin = BlockPos.f_121853_;
    private final MagmaDragonPhaseManager phaseManager;
    private int growlTime = 100;
    private float sittingDamageReceived;
    private final Node[] nodes = new Node[24];
    private final int[] nodeAdjacency = new int[24];
    private final BinaryHeap openSet = new BinaryHeap();
    private int crystalsAlive;
    private final EntityDimensions size;
    private static final EntityDataAccessor<Integer> DATA_ID_INV = SynchedEntityData.m_135353_(MagmaDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
    @Nullable
    private Player unlimitedLastHurtByPlayer = null;

    public MagmaDragon(EntityType<? extends MagmaDragon> p_31096_, Level p_31097_) {
        super((EntityType)Register.magma_dragon.get(), p_31097_);
        this.size = EntityDimensions.m_20395_((float)(p_31096_.m_20680_().f_20377_ * this.Scale()), (float)(p_31096_.m_20680_().f_20378_ * this.Scale()));
        this.m_6210_();
        this.head = new MagmaDragonPart(this, "head", 1.0f * this.Scale(), 1.0f * this.Scale());
        this.neck = new MagmaDragonPart(this, "neck", 3.0f * this.Scale(), 3.0f * this.Scale());
        this.body = new MagmaDragonPart(this, "body", 5.0f * this.Scale(), 3.0f * this.Scale());
        this.tail1 = new MagmaDragonPart(this, "tail", 2.0f * this.Scale(), 2.0f * this.Scale());
        this.tail2 = new MagmaDragonPart(this, "tail", 2.0f * this.Scale(), 2.0f * this.Scale());
        this.tail3 = new MagmaDragonPart(this, "tail", 2.0f * this.Scale(), 2.0f * this.Scale());
        this.wing1 = new MagmaDragonPart(this, "wing", 4.0f * this.Scale(), 2.0f * this.Scale());
        this.wing2 = new MagmaDragonPart(this, "wing", 4.0f * this.Scale(), 2.0f * this.Scale());
        this.subEntities = new MagmaDragonPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.wing1, this.wing2};
        this.m_21153_(this.m_21233_());
        this.f_19794_ = true;
        this.f_19811_ = true;
        this.phaseManager = new MagmaDragonPhaseManager(this);
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        this.m_20011_(new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + (double)this.size.f_20377_, this.m_20186_() + (double)this.size.f_20378_, this.m_20189_() + (double)this.size.f_20377_));
    }

    public float Scale() {
        return 0.25f;
    }

    public EntityDimensions m_6972_(Pose p_31023_) {
        return this.size;
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_20235_ + i + 1);
        }
    }

    public void setFightOrigin(BlockPos p_287665_) {
        this.fightOrigin = p_287665_;
    }

    public BlockPos getFightOrigin() {
        return this.fightOrigin;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0);
    }

    public boolean m_142039_() {
        float f = Mth.m_14089_((float)(this.flapTime * ((float)Math.PI * 2)));
        float f1 = Mth.m_14089_((float)(this.oFlapTime * ((float)Math.PI * 2)));
        return f1 <= -0.3f && f >= -0.3f;
    }

    public void m_142043_() {
        if (this.m_9236_().m_5776_() && !this.m_20067_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11893_, this.m_5720_(), 5.0f * this.m_6134_(), (0.8f + this.f_19796_.m_188501_() * 0.3f) * this.m_6134_(), false);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_PHASE, (Object)EnderDragonPhase.f_31387_.m_31405_());
        this.f_19804_.m_135372_(DATA_ID_INV, (Object)200);
    }

    public int getInvulnerableTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int p_31511_) {
        this.f_19804_.m_135381_(DATA_ID_INV, (Object)p_31511_);
    }

    public double[] getLatencyPos(int p_31102_, float p_31103_) {
        if (this.m_21224_()) {
            p_31103_ = 0.0f;
        }
        p_31103_ = 1.0f - p_31103_;
        int i = this.posPointer - p_31102_ & 0x3F;
        int j = this.posPointer - p_31102_ - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.positions[i][0];
        double d1 = Mth.m_14175_((double)(this.positions[j][0] - d0));
        adouble[0] = d0 + d1 * (double)p_31103_;
        d0 = this.positions[i][1];
        d1 = this.positions[j][1] - d0;
        adouble[1] = d0 + d1 * (double)p_31103_;
        adouble[2] = Mth.m_14139_((double)p_31103_, (double)this.positions[i][2], (double)this.positions[j][2]);
        return adouble;
    }

    public void m_6457_(ServerPlayer p_31483_) {
        super.m_6457_(p_31483_);
        this.bossEvent.m_6543_(p_31483_);
    }

    public void m_6452_(ServerPlayer p_31488_) {
        super.m_6452_(p_31488_);
        this.bossEvent.m_6539_(p_31488_);
    }

    public void m_8107_() {
        int k1 = this.getInvulnerableTicks() - 1;
        this.bossEvent.m_142711_(1.0f - (float)k1 / 220.0f);
        if (this.f_20888_ != null) {
            this.unlimitedLastHurtByPlayer = this.f_20888_;
        }
        if (this.unlimitedLastHurtByPlayer != null && this.unlimitedLastHurtByPlayer.m_213877_()) {
            this.unlimitedLastHurtByPlayer = null;
        }
        this.m_146874_();
        if (this.m_9236_().m_5776_()) {
            this.m_21153_(this.m_21223_());
            if (!this.m_20067_() && !this.phaseManager.getCurrentPhase().isSitting() && --this.growlTime < 0) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11894_, this.m_5720_(), 2.5f * this.m_6134_(), (0.8f + this.f_19796_.m_188501_() * 0.3f) * this.m_6134_(), false);
                this.growlTime = 200 + this.f_19796_.m_188503_(200);
            }
        }
        this.oFlapTime = this.flapTime;
        if (this.m_21224_()) {
            float f8 = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            float f10 = (this.f_19796_.m_188501_() - 0.5f) * 4.0f;
            float f11 = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + (double)f8, this.m_20186_() + 2.0 + (double)f10, this.m_20189_() + (double)f11, 0.0, 0.0, 0.0);
        } else {
            this.checkCrystals();
            Vec3 vec34 = this.m_20184_();
            float f9 = 0.2f / ((float)vec34.m_165924_() * 10.0f + 1.0f);
            this.flapTime = this.phaseManager.getCurrentPhase().isSitting() ? (this.flapTime += 0.1f) : (this.inWall ? (this.flapTime += f9 * 0.5f) : (this.flapTime += (f9 *= (float)Math.pow(2.0, vec34.f_82480_))));
            this.m_146922_(Mth.m_14177_((float)this.m_146908_()));
            if (this.m_21525_()) {
                this.flapTime = 0.5f;
            } else {
                if (this.posPointer < 0) {
                    for (int i = 0; i < this.positions.length; ++i) {
                        this.positions[i][0] = this.m_146908_();
                        this.positions[i][1] = this.m_20186_();
                    }
                }
                if (++this.posPointer == this.positions.length) {
                    this.posPointer = 0;
                }
                this.positions[this.posPointer][0] = this.m_146908_();
                this.positions[this.posPointer][1] = this.m_20186_();
                if (this.m_9236_().m_5776_()) {
                    if (this.f_20903_ > 0) {
                        double d6 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
                        double d0 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
                        double d1 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
                        double d2 = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
                        this.m_146922_(this.m_146908_() + (float)d2 / (float)this.f_20903_);
                        this.m_146926_(this.m_146909_() + (float)(this.f_20908_ - (double)this.m_146909_()) / (float)this.f_20903_);
                        --this.f_20903_;
                        this.m_6034_(d6, d0, d1);
                        this.m_19915_(this.m_146908_(), this.m_146909_());
                    }
                    this.phaseManager.getCurrentPhase().doClientTick();
                } else {
                    Vec3 vec3;
                    MagmaDragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
                    dragonphaseinstance.doServerTick();
                    if (this.phaseManager.getCurrentPhase() != dragonphaseinstance) {
                        dragonphaseinstance = this.phaseManager.getCurrentPhase();
                        dragonphaseinstance.doServerTick();
                    }
                    if ((vec3 = dragonphaseinstance.getFlyTargetLocation()) != null) {
                        double d7 = vec3.f_82479_ - this.m_20185_();
                        double d8 = vec3.f_82480_ - this.m_20186_();
                        double d9 = vec3.f_82481_ - this.m_20189_();
                        double d3 = d7 * d7 + d8 * d8 + d9 * d9;
                        float f4 = dragonphaseinstance.getFlySpeed();
                        double d4 = Math.sqrt(d7 * d7 + d9 * d9);
                        if (d4 > 0.0) {
                            d8 = Mth.m_14008_((double)(d8 / d4), (double)(-f4), (double)f4);
                        }
                        this.m_20256_(this.m_20184_().m_82520_(0.0, d8 * 0.01, 0.0));
                        this.m_146922_(Mth.m_14177_((float)this.m_146908_()));
                        Vec3 vec31 = vec3.m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82541_();
                        Vec3 vec32 = new Vec3((double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), this.m_20184_().f_82480_, (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))))).m_82541_();
                        float f5 = Math.max(((float)vec32.m_82526_(vec31) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d7) > (double)1.0E-5f || Math.abs(d9) > (double)1.0E-5f) {
                            float f6 = Mth.m_14036_((float)Mth.m_14177_((float)(180.0f - (float)Mth.m_14136_((double)d7, (double)d9) * 57.295776f - this.m_146908_())), (float)-50.0f, (float)50.0f);
                            this.yRotA *= 0.8f;
                            this.yRotA += f6 * dragonphaseinstance.getTurnSpeed();
                            this.m_146922_(this.m_146908_() + this.yRotA * 0.1f);
                        }
                        float f19 = (float)(2.0 / (d3 + 1.0));
                        this.m_19920_(0.06f * (f5 * f19 + (1.0f - f19)), new Vec3(0.0, 0.0, -1.0));
                        if (this.inWall) {
                            this.m_6478_(MoverType.SELF, this.m_20184_().m_82490_((double)0.8f));
                        } else {
                            this.m_6478_(MoverType.SELF, this.m_20184_());
                        }
                        Vec3 vec33 = this.m_20184_().m_82541_();
                        double d5 = 0.8 + 0.15 * (vec33.m_82526_(vec32) + 1.0) / 2.0;
                        this.m_20256_(this.m_20184_().m_82542_(d5, (double)0.91f, d5));
                    }
                }
                this.f_20883_ = this.m_146908_();
                Vec3[] avec3 = new Vec3[this.subEntities.length];
                for (int j = 0; j < this.subEntities.length; ++j) {
                    avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
                }
                float f12 = (float)(this.getLatencyPos(5, 1.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f13 = Mth.m_14089_((float)f12);
                float f = Mth.m_14031_((float)f12);
                float f14 = this.m_146908_() * ((float)Math.PI / 180);
                float f1 = Mth.m_14031_((float)f14);
                float f15 = Mth.m_14089_((float)f14);
                this.tickPart(this.body, f1 * 0.5f * this.Scale(), 0.0, -f15 * 0.5f * this.Scale());
                this.tickPart(this.wing1, f15 * 4.5f * this.Scale(), 2.0 * (double)this.Scale(), f1 * 4.5f * this.Scale());
                this.tickPart(this.wing2, f15 * -4.5f * this.Scale(), 2.0 * (double)this.Scale(), f1 * -4.5f * this.Scale());
                if (!this.m_9236_().m_5776_() && this.f_20916_ == 0) {
                    this.knockBack(this.m_9236_().m_6249_((Entity)this, this.wing1.m_20191_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
                    this.knockBack(this.m_9236_().m_6249_((Entity)this, this.wing2.m_20191_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
                    this.hurt(this.m_9236_().m_6249_((Entity)this, this.head.m_20191_().m_82400_(1.0), EntitySelector.f_20406_));
                    this.hurt(this.m_9236_().m_6249_((Entity)this, this.neck.m_20191_().m_82400_(1.0), EntitySelector.f_20406_));
                }
                float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f16 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f3 = this.getHeadYOffset();
                this.tickPart(this.head, f2 * 6.5f * f13 * this.Scale(), (f3 + f * 6.5f) * this.Scale(), -f16 * 6.5f * f13 * this.Scale());
                this.tickPart(this.neck, f2 * 6.5f * f13 * this.Scale(), (f3 + f * 5.5f) * this.Scale(), -f16 * 5.5f * f13 * this.Scale());
                double[] adouble = this.getLatencyPos(5, 1.0f);
                for (int k = 0; k < 3; ++k) {
                    MagmaDragonPart enderdragonpart = null;
                    if (k == 0) {
                        enderdragonpart = this.tail1;
                    }
                    if (k == 1) {
                        enderdragonpart = this.tail2;
                    }
                    if (k == 2) {
                        enderdragonpart = this.tail3;
                    }
                    double[] adouble1 = this.getLatencyPos(12 + k * 2, this.Scale());
                    float f17 = this.m_146908_() * ((float)Math.PI / 180) + this.rotWrap(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f18 = Mth.m_14031_((float)f17);
                    float f20 = Mth.m_14089_((float)f17);
                    float f22 = (float)(k + 1) * 2.0f * this.Scale();
                    this.tickPart(enderdragonpart, -(f1 * (1.5f * this.Scale()) + f18 * f22) * f13, adouble1[1] - adouble[1] - (double)((f22 + 1.5f) * f * this.Scale()) + 1.5 * (double)this.Scale(), (f15 * (1.5f * this.Scale()) + f20 * f22) * f13);
                }
                if (!this.m_9236_().m_5776_()) {
                    this.inWall = this.checkWalls(this.head.m_20191_()) | this.checkWalls(this.neck.m_20191_()) | this.checkWalls(this.body.m_20191_());
                }
                for (int l = 0; l < this.subEntities.length; ++l) {
                    this.subEntities[l].f_19854_ = avec3[l].f_82479_;
                    this.subEntities[l].f_19855_ = avec3[l].f_82480_;
                    this.subEntities[l].f_19856_ = avec3[l].f_82481_;
                    this.subEntities[l].f_19790_ = avec3[l].f_82479_;
                    this.subEntities[l].f_19791_ = avec3[l].f_82480_;
                    this.subEntities[l].f_19792_ = avec3[l].f_82481_;
                }
            }
        }
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    private void tickPart(MagmaDragonPart p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.m_6034_(this.m_20185_() + p_31117_, this.m_20186_() + p_31118_, this.m_20189_() + p_31119_);
    }

    private float getHeadYOffset() {
        if (this.phaseManager.getCurrentPhase().isSitting()) {
            return -1.0f;
        }
        double[] adouble = this.getLatencyPos(5, 1.0f);
        double[] adouble1 = this.getLatencyPos(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void checkCrystals() {
        if (this.nearestCrystal != null) {
            if (this.nearestCrystal.m_213877_()) {
                this.nearestCrystal = null;
            } else if (this.f_19797_ % 10 == 0 && this.m_21223_() < this.m_21233_()) {
                this.m_21153_(this.m_21223_() + 1.0f);
            }
        }
        if (this.f_19796_.m_188503_(10) == 0) {
            List list = this.m_9236_().m_45976_(EndCrystal.class, this.m_20191_().m_82400_(32.0));
            EndCrystal endcrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EndCrystal endcrystal1 : list) {
                double d1 = endcrystal1.m_20280_((Entity)this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                endcrystal = endcrystal1;
            }
            this.nearestCrystal = endcrystal;
        }
    }

    private void knockBack(List<Entity> p_31132_) {
        double d0 = (this.body.m_20191_().f_82288_ + this.body.m_20191_().f_82291_) / 2.0;
        double d1 = (this.body.m_20191_().f_82290_ + this.body.m_20191_().f_82293_) / 2.0;
        for (Entity entity : p_31132_) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.getCurrentPhase().isSitting() || ((LivingEntity)entity).m_21213_() >= entity.f_19797_ - 2) continue;
            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 5.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    private void hurt(List<Entity> p_31142_) {
        for (Entity entity : p_31142_) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 10.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    private float rotWrap(double p_31165_) {
        return (float)Mth.m_14175_((double)p_31165_);
    }

    private boolean checkWalls(AABB p_31140_) {
        int i = Mth.m_14107_((double)p_31140_.f_82288_);
        int j = Mth.m_14107_((double)p_31140_.f_82289_);
        int k = Mth.m_14107_((double)p_31140_.f_82290_);
        int l = Mth.m_14107_((double)p_31140_.f_82291_);
        int i1 = Mth.m_14107_((double)p_31140_.f_82292_);
        int j1 = Mth.m_14107_((double)p_31140_.f_82293_);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (blockstate.m_60795_() || blockstate.m_204336_(BlockTags.f_215822_)) continue;
                    if (ForgeHooks.canEntityDestroy((Level)this.m_9236_(), (BlockPos)blockpos, (LivingEntity)this) && !blockstate.m_204336_(BlockTags.f_13069_)) {
                        flag1 = this.m_9236_().m_7471_(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.f_19796_.m_188503_(l - i + 1), j + this.f_19796_.m_188503_(i1 - j + 1), k + this.f_19796_.m_188503_(j1 - k + 1));
            this.m_9236_().m_46796_(2008, blockpos1, 0);
        }
        return flag;
    }

    public boolean hurt(MagmaDragonPart p_31121_, DamageSource p_31122_, float p_31123_) {
        if (this.phaseManager.getCurrentPhase().getPhase() == MagmaDragonPhase.DYING) {
            return false;
        }
        p_31123_ = this.phaseManager.getCurrentPhase().onHurt(p_31122_, p_31123_);
        if (p_31121_ != this.head) {
            p_31123_ = p_31123_ / 4.0f + Math.min(p_31123_, 1.0f);
        }
        if (p_31123_ < 0.01f) {
            return false;
        }
        if (p_31122_.m_7639_() instanceof Player || p_31122_.m_269533_(DamageTypeTags.f_273821_)) {
            float f = this.m_21223_();
            this.reallyHurt(p_31122_, p_31123_);
            if (this.m_21224_() && !this.phaseManager.getCurrentPhase().isSitting()) {
                this.m_21153_(1.0f);
                this.phaseManager.setPhase(MagmaDragonPhase.DYING);
            }
            if (this.phaseManager.getCurrentPhase().isSitting()) {
                this.sittingDamageReceived = this.sittingDamageReceived + f - this.m_21223_();
                if (this.sittingDamageReceived > 0.25f * this.m_21233_()) {
                    this.sittingDamageReceived = 0.0f;
                    this.phaseManager.setPhase(MagmaDragonPhase.TAKEOFF);
                }
            }
        }
        return true;
    }

    public boolean m_6469_(DamageSource p_31113_, float p_31114_) {
        return !this.m_9236_().m_5776_() ? this.hurt(this.body, p_31113_, p_31114_) : false;
    }

    protected boolean reallyHurt(DamageSource p_31162_, float p_31163_) {
        return super.m_6469_(p_31162_, p_31163_);
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        if (this.dragonDeathTime >= 180 && this.dragonDeathTime <= 200) {
            float f = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            float f1 = (this.f_19796_.m_188501_() - 0.5f) * 4.0f;
            float f2 = (this.f_19796_.m_188501_() - 0.5f) * 8.0f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_() + (double)f, this.m_20186_() + 2.0 + (double)f1, this.m_20189_() + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        int i = 500;
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.dragonDeathTime > 150 && this.dragonDeathTime % 5 == 0 && flag) {
                int award = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (Player)this.unlimitedLastHurtByPlayer, (int)Mth.m_14143_((float)((float)i * 0.08f)));
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20182_(), (int)award);
            }
            if (this.dragonDeathTime == 1 && !this.m_20067_()) {
                this.m_9236_().m_6798_(1028, this.m_20183_(), 0);
            }
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, (double)0.1f, 0.0));
        if (this.dragonDeathTime == 200 && this.m_9236_() instanceof ServerLevel) {
            if (flag) {
                int award = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (Player)this.unlimitedLastHurtByPlayer, (int)Mth.m_14143_((float)((float)i * 0.2f)));
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20182_(), (int)award);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public int findClosestNode() {
        if (this.nodes[0] == null) {
            for (int i = 0; i < 24; ++i) {
                int i1;
                int l;
                int j = 5;
                if (i < 12) {
                    l = Mth.m_14143_((float)(60.0f * Mth.m_14089_((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)))));
                    i1 = Mth.m_14143_((float)(60.0f * Mth.m_14031_((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i)))));
                } else if (i < 20) {
                    int $$2 = i - 12;
                    l = Mth.m_14143_((float)(40.0f * Mth.m_14089_((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)))));
                    i1 = Mth.m_14143_((float)(40.0f * Mth.m_14031_((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)$$2)))));
                    j += 10;
                } else {
                    int k1 = i - 20;
                    l = Mth.m_14143_((float)(20.0f * Mth.m_14089_((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)))));
                    i1 = Mth.m_14143_((float)(20.0f * Mth.m_14031_((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1)))));
                }
                int j1 = Math.max(this.m_9236_().m_5736_() + 10, this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(l, 0, i1)).m_123342_() + j);
                this.nodes[i] = new Node(l, j1, i1);
            }
            this.nodeAdjacency[0] = 6146;
            this.nodeAdjacency[1] = 8197;
            this.nodeAdjacency[2] = 8202;
            this.nodeAdjacency[3] = 16404;
            this.nodeAdjacency[4] = 32808;
            this.nodeAdjacency[5] = 32848;
            this.nodeAdjacency[6] = 65696;
            this.nodeAdjacency[7] = 131392;
            this.nodeAdjacency[8] = 131712;
            this.nodeAdjacency[9] = 263424;
            this.nodeAdjacency[10] = 526848;
            this.nodeAdjacency[11] = 525313;
            this.nodeAdjacency[12] = 1581057;
            this.nodeAdjacency[13] = 3166214;
            this.nodeAdjacency[14] = 2138120;
            this.nodeAdjacency[15] = 6373424;
            this.nodeAdjacency[16] = 4358208;
            this.nodeAdjacency[17] = 12910976;
            this.nodeAdjacency[18] = 9044480;
            this.nodeAdjacency[19] = 9706496;
            this.nodeAdjacency[20] = 15216640;
            this.nodeAdjacency[21] = 0xD0E000;
            this.nodeAdjacency[22] = 11763712;
            this.nodeAdjacency[23] = 0x7E0000;
        }
        return this.findClosestNode(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public int findClosestNode(double p_31171_, double p_31172_, double p_31173_) {
        int j;
        float f = 10000.0f;
        int i = 0;
        Node node = new Node(Mth.m_14107_((double)p_31171_), Mth.m_14107_((double)p_31172_), Mth.m_14107_((double)p_31173_));
        for (int k = j = 0; k < 24; ++k) {
            float f1;
            if (this.nodes[k] == null || !((f1 = this.nodes[k].m_77299_(node)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @javax.annotation.Nullable
    public Path findPath(int p_31105_, int p_31106_, @javax.annotation.Nullable Node p_31107_) {
        for (int i = 0; i < 24; ++i) {
            Node node = this.nodes[i];
            node.f_77279_ = false;
            node.f_77277_ = 0.0f;
            node.f_77275_ = 0.0f;
            node.f_77276_ = 0.0f;
            node.f_77278_ = null;
            node.f_77274_ = -1;
        }
        Node node4 = this.nodes[p_31105_];
        Node node5 = this.nodes[p_31106_];
        node4.f_77275_ = 0.0f;
        node4.f_77277_ = node4.f_77276_ = node4.m_77293_(node5);
        this.openSet.m_77081_();
        this.openSet.m_77084_(node4);
        Node node1 = node4;
        int j = 0;
        while (!this.openSet.m_77092_()) {
            Node node2 = this.openSet.m_77091_();
            if (node2.equals((Object)node5)) {
                if (p_31107_ != null) {
                    p_31107_.f_77278_ = node5;
                    node5 = p_31107_;
                }
                return this.reconstructPath(node4, node5);
            }
            if (node2.m_77293_(node5) < node1.m_77293_(node5)) {
                node1 = node2;
            }
            node2.f_77279_ = true;
            int k = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.nodes[l] != node2) continue;
                k = l;
                break;
            }
            for (int i1 = j; i1 < 24; ++i1) {
                if ((this.nodeAdjacency[k] & 1 << i1) <= 0) continue;
                Node node3 = this.nodes[i1];
                if (node3.f_77279_) continue;
                float f = node2.f_77275_ + node2.m_77293_(node3);
                if (node3.m_77303_() && !(f < node3.f_77275_)) continue;
                node3.f_77278_ = node2;
                node3.f_77275_ = f;
                node3.f_77276_ = node3.m_77293_(node5);
                if (node3.m_77303_()) {
                    this.openSet.m_77086_(node3, node3.f_77275_ + node3.f_77276_);
                    continue;
                }
                node3.f_77277_ = node3.f_77275_ + node3.f_77276_;
                this.openSet.m_77084_(node3);
            }
        }
        if (node1 == node4) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)p_31105_, (Object)p_31106_);
        if (p_31107_ != null) {
            p_31107_.f_77278_ = node1;
            node1 = p_31107_;
        }
        return this.reconstructPath(node4, node1);
    }

    private Path reconstructPath(Node p_31129_, Node p_31130_) {
        ArrayList list = Lists.newArrayList();
        Node node = p_31130_;
        list.add(0, p_31130_);
        while (node.f_77278_ != null) {
            node = node.f_77278_;
            list.add(0, node);
        }
        return new Path((List)list, new BlockPos(p_31130_.f_77271_, p_31130_.f_77272_, p_31130_.f_77273_), true);
    }

    public void m_7380_(CompoundTag p_31144_) {
        super.m_7380_(p_31144_);
        p_31144_.m_128405_("DragonPhase", this.phaseManager.getCurrentPhase().getPhase().getId());
        p_31144_.m_128405_("DragonDeathTime", this.dragonDeathTime);
        p_31144_.m_128405_("Invul", this.getInvulnerableTicks());
    }

    public void m_7378_(CompoundTag p_31134_) {
        super.m_7378_(p_31134_);
        if (p_31134_.m_128441_("DragonPhase")) {
            this.phaseManager.setPhase(MagmaDragonPhase.getById(p_31134_.m_128451_("DragonPhase")));
        }
        if (p_31134_.m_128441_("DragonDeathTime")) {
            this.dragonDeathTime = p_31134_.m_128451_("DragonDeathTime");
        }
        this.setInvulnerableTicks(p_31134_.m_128451_("Invul"));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@javax.annotation.Nullable Component p_31476_) {
        super.m_6593_(p_31476_);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6043_() {
    }

    public MagmaDragonPart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean m_6087_() {
        return false;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11890_;
    }

    protected SoundEvent m_7975_(DamageSource p_31154_) {
        return SoundEvents.f_11895_;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public float getHeadPartYOffset(int p_31109_, double[] p_31110_, double[] p_31111_) {
        double d0;
        MagmaDragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
        MagmaDragonPhase<? extends MagmaDragonPhaseInstance> enderdragonphase = dragonphaseinstance.getPhase();
        if (enderdragonphase != MagmaDragonPhase.LANDING && enderdragonphase != MagmaDragonPhase.TAKEOFF) {
            d0 = dragonphaseinstance.isSitting() ? (double)p_31109_ : (p_31109_ == 6 ? 0.0 : p_31111_[1] - p_31110_[1]);
        } else {
            BlockPos blockpos = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.m_287210_((BlockPos)this.fightOrigin));
            double d1 = Math.max(Math.sqrt(blockpos.m_203193_((Position)this.m_20182_())) / 4.0, 1.0);
            d0 = (double)p_31109_ / d1;
        }
        return (float)d0;
    }

    public Vec3 getHeadLookVector(float p_31175_) {
        Vec3 vec3;
        MagmaDragonPhaseInstance dragonphaseinstance = this.phaseManager.getCurrentPhase();
        MagmaDragonPhase<? extends MagmaDragonPhaseInstance> enderdragonphase = dragonphaseinstance.getPhase();
        if (enderdragonphase != MagmaDragonPhase.LANDING && enderdragonphase != MagmaDragonPhase.TAKEOFF) {
            if (dragonphaseinstance.isSitting()) {
                float f4 = this.m_146909_();
                this.m_146926_(-45.0f);
                vec3 = this.m_20252_(p_31175_);
                this.m_146926_(f4);
            } else {
                vec3 = this.m_20252_(p_31175_);
            }
        } else {
            BlockPos blockpos = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.m_287210_((BlockPos)this.fightOrigin));
            float f = Math.max((float)Math.sqrt(blockpos.m_203193_((Position)this.m_20182_())) / 4.0f, 1.0f);
            float f1 = 6.0f / f;
            float f2 = this.m_146909_();
            this.m_146926_(-f1 * 1.5f * 5.0f);
            vec3 = this.m_20252_(p_31175_);
            this.m_146926_(f2);
        }
        return vec3;
    }

    public void onCrystalDestroyed(EndCrystal p_31125_, BlockPos p_31126_, DamageSource p_31127_) {
        Player player = p_31127_.m_7639_() instanceof Player ? (Player)p_31127_.m_7639_() : this.m_9236_().m_45941_(CRYSTAL_DESTROY_TARGETING, (double)p_31126_.m_123341_(), (double)p_31126_.m_123342_(), (double)p_31126_.m_123343_());
        if (p_31125_ == this.nearestCrystal) {
            this.hurt(this.head, this.m_269291_().m_269036_((Entity)p_31125_, (Entity)player), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalDestroyed(p_31125_, p_31126_, p_31127_, player);
    }

    public void m_7350_(EntityDataAccessor<?> p_31136_) {
        if (DATA_PHASE.equals(p_31136_) && this.m_9236_().f_46443_) {
            this.phaseManager.setPhase(MagmaDragonPhase.getById((Integer)this.m_20088_().m_135370_(DATA_PHASE)));
        }
        super.m_7350_(p_31136_);
    }

    public MagmaDragonPhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    public boolean m_147207_(MobEffectInstance p_182394_, @javax.annotation.Nullable Entity p_182395_) {
        return false;
    }

    protected boolean m_7341_(Entity p_31169_) {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_141965_(ClientboundAddEntityPacket p_218825_) {
        super.m_141965_(p_218825_);
    }

    public boolean m_6779_(LivingEntity p_149576_) {
        return p_149576_.m_142066_();
    }

    public double m_6048_() {
        return this.body.m_20206_();
    }

    public int getCrystalsAlive() {
        return this.crystalsAlive;
    }
}

