/*
 * Decompiled with CFR 0.152.
 */
package starcrop.magmadragoon;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import starcrop.magmadragoon.MagmaDragon;
import starcrop.magmadragoon.MagmaDragonPhase;
import starcrop.magmadragoon.MagmaDragonPhaseInstance;

public class MagmaDragonPhaseManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final MagmaDragon dragon;
    private final MagmaDragonPhaseInstance[] phases = new MagmaDragonPhaseInstance[MagmaDragonPhase.getCount()];
    @Nullable
    private MagmaDragonPhaseInstance currentPhase;

    public MagmaDragonPhaseManager(MagmaDragon p_31414_) {
        this.dragon = p_31414_;
        this.setPhase(MagmaDragonPhase.HOVERING);
    }

    public void setPhase(MagmaDragonPhase<?> p_31417_) {
        if (this.currentPhase == null || p_31417_ != this.currentPhase.getPhase()) {
            if (this.currentPhase != null) {
                this.currentPhase.end();
            }
            this.currentPhase = this.getPhase(p_31417_);
            if (!this.dragon.m_9236_().m_5776_()) {
                this.dragon.m_20088_().m_135381_(MagmaDragon.DATA_PHASE, (Object)p_31417_.getId());
            }
            LOGGER.debug("Dragon is now in phase {} on the {}", p_31417_, (Object)(this.dragon.m_9236_().m_5776_() ? "client" : "server"));
            this.currentPhase.begin();
        }
    }

    public MagmaDragonPhaseInstance getCurrentPhase() {
        return this.currentPhase;
    }

    public <T extends MagmaDragonPhaseInstance> T getPhase(MagmaDragonPhase<T> p_31419_) {
        int i = p_31419_.getId();
        if (this.phases[i] == null) {
            this.phases[i] = p_31419_.createInstance(this.dragon);
        }
        return (T)this.phases[i];
    }
}

