/*
 * Decompiled with CFR 0.152.
 */
package starcrop.magmadragoon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import starcrop.magmadragoon.MagmaDragon;

@OnlyIn(value=Dist.CLIENT)
public class MagmaDragonRenderer
extends EntityRenderer<MagmaDragon> {
    public static final ResourceLocation CRYSTAL_BEAM_LOCATION = new ResourceLocation("textures/entity/end_crystal/end_crystal_beam.png");
    private static final ResourceLocation DRAGON_EXPLODING_LOCATION = new ResourceLocation("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation DRAGON_LOCATION = new ResourceLocation("starcrop:textures/entity/magmadragon/magma_dragon.png");
    private static final ResourceLocation DRAGON_EYES_LOCATION = new ResourceLocation("starcrop:textures/entity/magmadragon/magma_dragon_eyes.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)DRAGON_LOCATION);
    private static final RenderType DECAL = RenderType.m_110479_((ResourceLocation)DRAGON_LOCATION);
    private static final RenderType EYES = RenderType.m_110488_((ResourceLocation)DRAGON_EYES_LOCATION);
    private static final RenderType BEAM = RenderType.m_110476_((ResourceLocation)CRYSTAL_BEAM_LOCATION);
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private final DragonModel model;

    public MagmaDragonRenderer(EntityRendererProvider.Context p_173973_) {
        super(p_173973_);
        this.f_114477_ = 0.5f;
        this.model = new DragonModel(p_173973_.m_174023_(ModelLayers.f_171144_));
    }

    public boolean shouldRender(MagmaDragon p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        if (super.m_5523_((Entity)p_114491_, p_114492_, p_114493_, p_114494_, p_114495_)) {
            return true;
        }
        Entity entity = p_114491_.m_21524_();
        return entity != null ? p_114492_.m_113029_(entity.m_6921_()) : false;
    }

    public void render(MagmaDragon p_114208_, float p_114209_, float p_114210_, PoseStack p_114211_, MultiBufferSource p_114212_, int p_114213_) {
        p_114211_.m_85836_();
        float f = (float)p_114208_.getLatencyPos(7, p_114210_)[0];
        float f1 = (float)(p_114208_.getLatencyPos(5, p_114210_)[1] - p_114208_.getLatencyPos(10, p_114210_)[1]);
        p_114211_.m_252781_(Axis.f_252436_.m_252977_(-f));
        p_114211_.m_252781_(Axis.f_252529_.m_252977_(f1 * 10.0f));
        p_114211_.m_252880_(0.0f, 0.0f, p_114208_.Scale());
        p_114211_.m_85841_(-p_114208_.Scale(), -p_114208_.Scale(), p_114208_.Scale());
        p_114211_.m_252880_(0.0f, -1.501f, 0.0f);
        boolean flag = p_114208_.f_20916_ > 0;
        this.model.prepareMobModel(p_114208_, 0.0f, 0.0f, p_114210_);
        if (p_114208_.f_20919_ > 0) {
            float f2 = (float)p_114208_.f_20919_ / 200.0f;
            VertexConsumer vertexconsumer = p_114212_.m_6299_(RenderType.m_173235_((ResourceLocation)DRAGON_EXPLODING_LOCATION));
            this.model.m_7695_(p_114211_, vertexconsumer, p_114213_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, f2);
            VertexConsumer vertexconsumer1 = p_114212_.m_6299_(DECAL);
            this.model.m_7695_(p_114211_, vertexconsumer1, p_114213_, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            VertexConsumer vertexconsumer3 = p_114212_.m_6299_(RENDER_TYPE);
            this.model.m_7695_(p_114211_, vertexconsumer3, p_114213_, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        VertexConsumer vertexconsumer4 = p_114212_.m_6299_(EYES);
        this.model.m_7695_(p_114211_, vertexconsumer4, p_114213_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (p_114208_.f_20919_ > 0) {
            float f5 = ((float)p_114208_.f_20919_ + p_114210_) / 200.0f;
            float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
            RandomSource randomsource = RandomSource.m_216335_((long)432L);
            VertexConsumer vertexconsumer2 = p_114212_.m_6299_(RenderType.m_110502_());
            p_114211_.m_85836_();
            p_114211_.m_252880_(0.0f, -1.0f, -2.0f);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
                p_114211_.m_252781_(Axis.f_252529_.m_252977_(randomsource.m_188501_() * 180.0f));
                p_114211_.m_252781_(Axis.f_252436_.m_252977_(randomsource.m_188501_() * 180.0f));
                p_114211_.m_252781_(Axis.f_252403_.m_252977_(randomsource.m_188501_() * 180.0f));
                p_114211_.m_252781_(Axis.f_252529_.m_252977_(randomsource.m_188501_() * 180.0f));
                p_114211_.m_252781_(Axis.f_252436_.m_252977_(randomsource.m_188501_() * 180.0f));
                p_114211_.m_252781_(Axis.f_252403_.m_252977_(randomsource.m_188501_() * 180.0f + f5 * 90.0f));
                float f3 = randomsource.m_188501_() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = randomsource.m_188501_() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = p_114211_.m_85850_().m_252922_();
                int j = (int)(255.0f * (1.0f - f7));
                MagmaDragonRenderer.vertex01(vertexconsumer2, matrix4f, j);
                MagmaDragonRenderer.vertex2(vertexconsumer2, matrix4f, f3, f4);
                MagmaDragonRenderer.vertex3(vertexconsumer2, matrix4f, f3, f4);
                MagmaDragonRenderer.vertex01(vertexconsumer2, matrix4f, j);
                MagmaDragonRenderer.vertex3(vertexconsumer2, matrix4f, f3, f4);
                MagmaDragonRenderer.vertex4(vertexconsumer2, matrix4f, f3, f4);
                MagmaDragonRenderer.vertex01(vertexconsumer2, matrix4f, j);
                MagmaDragonRenderer.vertex4(vertexconsumer2, matrix4f, f3, f4);
                MagmaDragonRenderer.vertex2(vertexconsumer2, matrix4f, f3, f4);
                ++i;
            }
            p_114211_.m_85849_();
        }
        p_114211_.m_85849_();
        super.m_7392_((Entity)p_114208_, p_114209_, p_114210_, p_114211_, p_114212_, p_114213_);
    }

    private static void vertex01(VertexConsumer p_254498_, Matrix4f p_253891_, int p_254278_) {
        p_254498_.m_252986_(p_253891_, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, p_254278_).m_5752_();
    }

    private static void vertex2(VertexConsumer p_253956_, Matrix4f p_254053_, float p_253704_, float p_253701_) {
        p_253956_.m_252986_(p_254053_, -HALF_SQRT_3 * p_253701_, p_253704_, -0.5f * p_253701_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer p_253850_, Matrix4f p_254379_, float p_253729_, float p_254030_) {
        p_253850_.m_252986_(p_254379_, HALF_SQRT_3 * p_254030_, p_253729_, -0.5f * p_254030_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer p_254184_, Matrix4f p_254082_, float p_253649_, float p_253694_) {
        p_254184_.m_252986_(p_254082_, 0.0f, p_253649_, 1.0f * p_253694_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    public static void renderCrystalBeams(float p_114188_, float p_114189_, float p_114190_, float p_114191_, int p_114192_, PoseStack p_114193_, MultiBufferSource p_114194_, int p_114195_) {
        float f = Mth.m_14116_((float)(p_114188_ * p_114188_ + p_114190_ * p_114190_));
        float f1 = Mth.m_14116_((float)(p_114188_ * p_114188_ + p_114189_ * p_114189_ + p_114190_ * p_114190_));
        p_114193_.m_85836_();
        p_114193_.m_252880_(0.0f, 2.0f, 0.0f);
        p_114193_.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(p_114190_, p_114188_)) - 1.5707964f));
        p_114193_.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(f, p_114189_)) - 1.5707964f));
        VertexConsumer vertexconsumer = p_114194_.m_6299_(BEAM);
        float f2 = 0.0f - ((float)p_114192_ + p_114191_) * 0.01f;
        float f3 = Mth.m_14116_((float)(p_114188_ * p_114188_ + p_114189_ * p_114189_ + p_114190_ * p_114190_)) / 32.0f - ((float)p_114192_ + p_114191_) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = p_114193_.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        for (int j = 1; j <= 8; ++j) {
            float f7 = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float f8 = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float f9 = (float)j / 8.0f;
            vertexconsumer.m_252986_(matrix4f, f4 * 0.2f, f5 * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114195_).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f4, f5, f1).m_6122_(255, 255, 255, 255).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114195_).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7, f8, f1).m_6122_(255, 255, 255, 255).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114195_).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7 * 0.2f, f8 * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(p_114195_).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        p_114193_.m_85849_();
    }

    public ResourceLocation getTextureLocation(MagmaDragon p_114206_) {
        return DRAGON_LOCATION;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition partdefinition1 = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171534_("upperlip", -6.0f, -1.0f, -24.0f, 12, 5, 16, 176, 44).m_171534_("upperhead", -8.0f, -8.0f, -10.0f, 16, 16, 16, 112, 30).m_171480_().m_171534_("scale", -5.0f, -12.0f, -4.0f, 2, 4, 6, 0, 0).m_171534_("nostril", -5.0f, -3.0f, -22.0f, 2, 2, 4, 112, 0).m_171480_().m_171534_("scale", 3.0f, -12.0f, -4.0f, 2, 4, 6, 0, 0).m_171534_("nostril", 3.0f, -3.0f, -22.0f, 2, 2, 4, 112, 0), PartPose.f_171404_);
        partdefinition1.m_171599_("jaw", CubeListBuilder.m_171558_().m_171534_("jaw", -6.0f, 0.0f, -16.0f, 12, 4, 16, 176, 65), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-8.0f));
        partdefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171534_("box", -5.0f, -5.0f, -5.0f, 10, 10, 10, 192, 104).m_171534_("scale", -1.0f, -9.0f, -3.0f, 2, 4, 6, 48, 0), PartPose.f_171404_);
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171534_("body", -12.0f, 0.0f, -16.0f, 24, 24, 64, 0, 0).m_171534_("scale", -1.0f, -6.0f, -10.0f, 2, 6, 12, 220, 53).m_171534_("scale", -1.0f, -6.0f, 10.0f, 2, 6, 12, 220, 53).m_171534_("scale", -1.0f, -6.0f, 30.0f, 2, 6, 12, 220, 53), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)8.0f));
        PartDefinition partdefinition2 = partdefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171480_().m_171534_("bone", 0.0f, -4.0f, -4.0f, 56, 8, 8, 112, 88).m_171534_("skin", 0.0f, 0.0f, 2.0f, 56, 0, 56, -56, 88), PartPose.m_171419_((float)12.0f, (float)5.0f, (float)2.0f));
        partdefinition2.m_171599_("left_wing_tip", CubeListBuilder.m_171558_().m_171480_().m_171534_("bone", 0.0f, -2.0f, -2.0f, 56, 4, 4, 112, 136).m_171534_("skin", 0.0f, 0.0f, 2.0f, 56, 0, 56, -56, 144), PartPose.m_171419_((float)56.0f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition3 = partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171534_("main", -4.0f, -4.0f, -4.0f, 8, 24, 8, 112, 104), PartPose.m_171419_((float)12.0f, (float)20.0f, (float)2.0f));
        PartDefinition partdefinition4 = partdefinition3.m_171599_("left_front_leg_tip", CubeListBuilder.m_171558_().m_171534_("main", -3.0f, -1.0f, -3.0f, 6, 24, 6, 226, 138), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-1.0f));
        partdefinition4.m_171599_("left_front_foot", CubeListBuilder.m_171558_().m_171534_("main", -4.0f, 0.0f, -12.0f, 8, 4, 16, 144, 104), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition partdefinition5 = partdefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171534_("main", -8.0f, -4.0f, -8.0f, 16, 32, 16, 0, 0), PartPose.m_171419_((float)16.0f, (float)16.0f, (float)42.0f));
        PartDefinition partdefinition6 = partdefinition5.m_171599_("left_hind_leg_tip", CubeListBuilder.m_171558_().m_171534_("main", -6.0f, -2.0f, 0.0f, 12, 32, 12, 196, 0), PartPose.m_171419_((float)0.0f, (float)32.0f, (float)-4.0f));
        partdefinition6.m_171599_("left_hind_foot", CubeListBuilder.m_171558_().m_171534_("main", -9.0f, 0.0f, -20.0f, 18, 6, 24, 112, 0), PartPose.m_171419_((float)0.0f, (float)31.0f, (float)4.0f));
        PartDefinition partdefinition7 = partdefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171534_("bone", -56.0f, -4.0f, -4.0f, 56, 8, 8, 112, 88).m_171534_("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56, -56, 88), PartPose.m_171419_((float)-12.0f, (float)5.0f, (float)2.0f));
        partdefinition7.m_171599_("right_wing_tip", CubeListBuilder.m_171558_().m_171534_("bone", -56.0f, -2.0f, -2.0f, 56, 4, 4, 112, 136).m_171534_("skin", -56.0f, 0.0f, 2.0f, 56, 0, 56, -56, 144), PartPose.m_171419_((float)-56.0f, (float)0.0f, (float)0.0f));
        PartDefinition partdefinition8 = partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171534_("main", -4.0f, -4.0f, -4.0f, 8, 24, 8, 112, 104), PartPose.m_171419_((float)-12.0f, (float)20.0f, (float)2.0f));
        PartDefinition partdefinition9 = partdefinition8.m_171599_("right_front_leg_tip", CubeListBuilder.m_171558_().m_171534_("main", -3.0f, -1.0f, -3.0f, 6, 24, 6, 226, 138), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-1.0f));
        partdefinition9.m_171599_("right_front_foot", CubeListBuilder.m_171558_().m_171534_("main", -4.0f, 0.0f, -12.0f, 8, 4, 16, 144, 104), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition partdefinition10 = partdefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171534_("main", -8.0f, -4.0f, -8.0f, 16, 32, 16, 0, 0), PartPose.m_171419_((float)-16.0f, (float)16.0f, (float)42.0f));
        PartDefinition partdefinition11 = partdefinition10.m_171599_("right_hind_leg_tip", CubeListBuilder.m_171558_().m_171534_("main", -6.0f, -2.0f, 0.0f, 12, 32, 12, 196, 0), PartPose.m_171419_((float)0.0f, (float)32.0f, (float)-4.0f));
        partdefinition11.m_171599_("right_hind_foot", CubeListBuilder.m_171558_().m_171534_("main", -9.0f, 0.0f, -20.0f, 18, 6, 24, 112, 0), PartPose.m_171419_((float)0.0f, (float)31.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DragonModel
    extends EntityModel<MagmaDragon> {
        private final ModelPart head;
        private final ModelPart neck;
        private final ModelPart jaw;
        private final ModelPart body;
        private final ModelPart leftWing;
        private final ModelPart leftWingTip;
        private final ModelPart leftFrontLeg;
        private final ModelPart leftFrontLegTip;
        private final ModelPart leftFrontFoot;
        private final ModelPart leftRearLeg;
        private final ModelPart leftRearLegTip;
        private final ModelPart leftRearFoot;
        private final ModelPart rightWing;
        private final ModelPart rightWingTip;
        private final ModelPart rightFrontLeg;
        private final ModelPart rightFrontLegTip;
        private final ModelPart rightFrontFoot;
        private final ModelPart rightRearLeg;
        private final ModelPart rightRearLegTip;
        private final ModelPart rightRearFoot;
        @Nullable
        private MagmaDragon entity;
        private float a;

        public DragonModel(ModelPart p_173976_) {
            this.head = p_173976_.m_171324_("head");
            this.jaw = this.head.m_171324_("jaw");
            this.neck = p_173976_.m_171324_("neck");
            this.body = p_173976_.m_171324_("body");
            this.leftWing = p_173976_.m_171324_("left_wing");
            this.leftWingTip = this.leftWing.m_171324_("left_wing_tip");
            this.leftFrontLeg = p_173976_.m_171324_("left_front_leg");
            this.leftFrontLegTip = this.leftFrontLeg.m_171324_("left_front_leg_tip");
            this.leftFrontFoot = this.leftFrontLegTip.m_171324_("left_front_foot");
            this.leftRearLeg = p_173976_.m_171324_("left_hind_leg");
            this.leftRearLegTip = this.leftRearLeg.m_171324_("left_hind_leg_tip");
            this.leftRearFoot = this.leftRearLegTip.m_171324_("left_hind_foot");
            this.rightWing = p_173976_.m_171324_("right_wing");
            this.rightWingTip = this.rightWing.m_171324_("right_wing_tip");
            this.rightFrontLeg = p_173976_.m_171324_("right_front_leg");
            this.rightFrontLegTip = this.rightFrontLeg.m_171324_("right_front_leg_tip");
            this.rightFrontFoot = this.rightFrontLegTip.m_171324_("right_front_foot");
            this.rightRearLeg = p_173976_.m_171324_("right_hind_leg");
            this.rightRearLegTip = this.rightRearLeg.m_171324_("right_hind_leg_tip");
            this.rightRearFoot = this.rightRearLegTip.m_171324_("right_hind_foot");
        }

        public void prepareMobModel(MagmaDragon p_114269_, float p_114270_, float p_114271_, float p_114272_) {
            this.entity = p_114269_;
            this.a = p_114272_;
        }

        public void setupAnim(MagmaDragon p_114274_, float p_114275_, float p_114276_, float p_114277_, float p_114278_, float p_114279_) {
        }

        public void m_7695_(PoseStack p_114281_, VertexConsumer p_114282_, int p_114283_, int p_114284_, float p_114285_, float p_114286_, float p_114287_, float p_114288_) {
            p_114281_.m_85836_();
            float f = Mth.m_14179_((float)this.a, (float)this.entity.oFlapTime, (float)this.entity.flapTime);
            this.jaw.f_104203_ = (float)(Math.sin(f * ((float)Math.PI * 2)) + 1.0) * 0.2f;
            float f1 = (float)(Math.sin(f * ((float)Math.PI * 2) - 1.0f) + 1.0);
            f1 = (f1 * f1 + f1 * 2.0f) * 0.05f;
            p_114281_.m_252880_(0.0f, f1 - 2.0f, -3.0f);
            p_114281_.m_252781_(Axis.f_252529_.m_252977_(f1 * 2.0f));
            float f2 = 0.0f;
            float f3 = 20.0f;
            float f4 = -12.0f;
            double[] adouble = this.entity.getLatencyPos(6, this.a);
            float f6 = Mth.m_14177_((float)((float)(this.entity.getLatencyPos(5, this.a)[0] - this.entity.getLatencyPos(10, this.a)[0])));
            float f7 = Mth.m_14177_((float)((float)(this.entity.getLatencyPos(5, this.a)[0] + (double)(f6 / 2.0f))));
            float f8 = f * ((float)Math.PI * 2);
            for (int i = 0; i < 5; ++i) {
                double[] adouble1 = this.entity.getLatencyPos(5 - i, this.a);
                float f9 = (float)Math.cos((float)i * 0.45f + f8) * 0.15f;
                this.neck.f_104204_ = Mth.m_14177_((float)((float)(adouble1[0] - adouble[0]))) * ((float)Math.PI / 180) * 1.5f;
                this.neck.f_104203_ = f9 + this.entity.getHeadPartYOffset(i, adouble, adouble1) * ((float)Math.PI / 180) * 1.5f * 5.0f;
                this.neck.f_104205_ = -Mth.m_14177_((float)((float)(adouble1[0] - (double)f7))) * ((float)Math.PI / 180) * 1.5f;
                this.neck.f_104201_ = f3;
                this.neck.f_104202_ = f4;
                this.neck.f_104200_ = f2;
                f3 += Mth.m_14031_((float)this.neck.f_104203_) * 10.0f;
                f4 -= Mth.m_14089_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
                f2 -= Mth.m_14031_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
                this.neck.m_104306_(p_114281_, p_114282_, p_114283_, p_114284_, 1.0f, 1.0f, 1.0f, p_114288_);
            }
            this.head.f_104201_ = f3;
            this.head.f_104202_ = f4;
            this.head.f_104200_ = f2;
            double[] adouble2 = this.entity.getLatencyPos(0, this.a);
            this.head.f_104204_ = Mth.m_14177_((float)((float)(adouble2[0] - adouble[0]))) * ((float)Math.PI / 180);
            this.head.f_104203_ = Mth.m_14177_((float)this.entity.getHeadPartYOffset(6, adouble, adouble2)) * ((float)Math.PI / 180) * 1.5f * 5.0f;
            this.head.f_104205_ = -Mth.m_14177_((float)((float)(adouble2[0] - (double)f7))) * ((float)Math.PI / 180);
            this.head.m_104306_(p_114281_, p_114282_, p_114283_, p_114284_, 1.0f, 1.0f, 1.0f, p_114288_);
            p_114281_.m_85836_();
            p_114281_.m_252880_(0.0f, 1.0f, 0.0f);
            p_114281_.m_252781_(Axis.f_252403_.m_252977_(-f6 * 1.5f));
            p_114281_.m_252880_(0.0f, -1.0f, 0.0f);
            this.body.f_104205_ = 0.0f;
            this.body.m_104306_(p_114281_, p_114282_, p_114283_, p_114284_, 1.0f, 1.0f, 1.0f, p_114288_);
            float f10 = f * ((float)Math.PI * 2);
            this.leftWing.f_104203_ = 0.125f - (float)Math.cos(f10) * 0.2f;
            this.leftWing.f_104204_ = -0.25f;
            this.leftWing.f_104205_ = -((float)(Math.sin(f10) + 0.125)) * 0.8f;
            this.leftWingTip.f_104205_ = (float)(Math.sin(f10 + 2.0f) + 0.5) * 0.75f;
            this.rightWing.f_104203_ = this.leftWing.f_104203_;
            this.rightWing.f_104204_ = -this.leftWing.f_104204_;
            this.rightWing.f_104205_ = -this.leftWing.f_104205_;
            this.rightWingTip.f_104205_ = -this.leftWingTip.f_104205_;
            this.renderSide(p_114281_, p_114282_, p_114283_, p_114284_, f1, this.leftWing, this.leftFrontLeg, this.leftFrontLegTip, this.leftFrontFoot, this.leftRearLeg, this.leftRearLegTip, this.leftRearFoot, p_114288_);
            this.renderSide(p_114281_, p_114282_, p_114283_, p_114284_, f1, this.rightWing, this.rightFrontLeg, this.rightFrontLegTip, this.rightFrontFoot, this.rightRearLeg, this.rightRearLegTip, this.rightRearFoot, p_114288_);
            p_114281_.m_85849_();
            float f11 = -Mth.m_14031_((float)(f * ((float)Math.PI * 2))) * 0.0f;
            f8 = f * ((float)Math.PI * 2);
            f3 = 10.0f;
            f4 = 60.0f;
            f2 = 0.0f;
            adouble = this.entity.getLatencyPos(11, this.a);
            for (int j = 0; j < 12; ++j) {
                adouble2 = this.entity.getLatencyPos(12 + j, this.a);
                this.neck.f_104204_ = (Mth.m_14177_((float)((float)(adouble2[0] - adouble[0]))) * 1.5f + 180.0f) * ((float)Math.PI / 180);
                this.neck.f_104203_ = (f11 += Mth.m_14031_((float)((float)j * 0.45f + f8)) * 0.05f) + (float)(adouble2[1] - adouble[1]) * ((float)Math.PI / 180) * 1.5f * 5.0f;
                this.neck.f_104205_ = Mth.m_14177_((float)((float)(adouble2[0] - (double)f7))) * ((float)Math.PI / 180) * 1.5f;
                this.neck.f_104201_ = f3;
                this.neck.f_104202_ = f4;
                this.neck.f_104200_ = f2;
                f3 += Mth.m_14031_((float)this.neck.f_104203_) * 10.0f;
                f4 -= Mth.m_14089_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
                f2 -= Mth.m_14031_((float)this.neck.f_104204_) * Mth.m_14089_((float)this.neck.f_104203_) * 10.0f;
                this.neck.m_104306_(p_114281_, p_114282_, p_114283_, p_114284_, 1.0f, 1.0f, 1.0f, p_114288_);
            }
            p_114281_.m_85849_();
        }

        private void renderSide(PoseStack p_173978_, VertexConsumer p_173979_, int p_173980_, int p_173981_, float p_173982_, ModelPart p_173983_, ModelPart p_173984_, ModelPart p_173985_, ModelPart p_173986_, ModelPart p_173987_, ModelPart p_173988_, ModelPart p_173989_, float p_173990_) {
            p_173987_.f_104203_ = 1.0f + p_173982_ * 0.1f;
            p_173988_.f_104203_ = 0.5f + p_173982_ * 0.1f;
            p_173989_.f_104203_ = 0.75f + p_173982_ * 0.1f;
            p_173984_.f_104203_ = 1.3f + p_173982_ * 0.1f;
            p_173985_.f_104203_ = -0.5f - p_173982_ * 0.1f;
            p_173986_.f_104203_ = 0.75f + p_173982_ * 0.1f;
            p_173983_.m_104306_(p_173978_, p_173979_, p_173980_, p_173981_, 1.0f, 1.0f, 1.0f, p_173990_);
            p_173984_.m_104306_(p_173978_, p_173979_, p_173980_, p_173981_, 1.0f, 1.0f, 1.0f, p_173990_);
            p_173987_.m_104306_(p_173978_, p_173979_, p_173980_, p_173981_, 1.0f, 1.0f, 1.0f, p_173990_);
        }
    }
}

