/*
 * Decompiled with CFR 0.152.
 */
package starcrop.magmadragoon;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import starcrop.magmadragoon.AbstractMagmaDragonPhaseInstance;
import starcrop.magmadragoon.MagmaBall;
import starcrop.magmadragoon.MagmaDragon;
import starcrop.magmadragoon.MagmaDragonPhase;

public class MagmaDragonStrafePlayerPhase
extends AbstractMagmaDragonPhaseInstance {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int fireballCharge;
    @Nullable
    private Path currentPath;
    @Nullable
    private Vec3 targetLocation;
    @Nullable
    private LivingEntity attackTarget;
    private boolean holdingPatternClockwise;

    public MagmaDragonStrafePlayerPhase(MagmaDragon p_31357_) {
        super(p_31357_);
    }

    @Override
    public void doServerTick() {
        if (this.attackTarget == null) {
            LOGGER.warn("Skipping player strafe phase because no player was found");
            this.dragon.getPhaseManager().setPhase(MagmaDragonPhase.HOLDING_PATTERN);
        } else {
            double d12;
            if (this.currentPath != null && this.currentPath.m_77392_()) {
                double d0 = this.attackTarget.m_20185_();
                double d1 = this.attackTarget.m_20189_();
                double d2 = d0 - this.dragon.m_20185_();
                double d3 = d1 - this.dragon.m_20189_();
                double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                double d5 = Math.min((double)0.4f + d4 / 80.0 - 1.0, 10.0);
                this.targetLocation = new Vec3(d0, this.attackTarget.m_20186_() + d5, d1);
            }
            double d = d12 = this.targetLocation == null ? 0.0 : this.targetLocation.m_82531_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_());
            if (d12 < 100.0 || d12 > 22500.0) {
                this.findNewTarget();
            }
            if (this.attackTarget.m_20280_((Entity)this.dragon) < 4096.0) {
                if (this.dragon.m_142582_((Entity)this.attackTarget)) {
                    ++this.fireballCharge;
                    Vec3 vec31 = new Vec3(this.attackTarget.m_20185_() - this.dragon.m_20185_(), 0.0, this.attackTarget.m_20189_() - this.dragon.m_20189_()).m_82541_();
                    Vec3 vec3 = new Vec3((double)Mth.m_14031_((float)(this.dragon.m_146908_() * ((float)Math.PI / 180))), 0.0, (double)(-Mth.m_14089_((float)(this.dragon.m_146908_() * ((float)Math.PI / 180))))).m_82541_();
                    float f1 = (float)vec3.m_82526_(vec31);
                    float f = (float)(Math.acos(f1) * 57.2957763671875);
                    f += 0.5f;
                    if (this.fireballCharge >= 5 && f >= 0.0f && f < 10.0f) {
                        Vec3 vec32 = this.dragon.m_20252_(1.0f);
                        double d6 = this.dragon.head.m_20185_() - vec32.f_82479_ * 1.0;
                        double d7 = this.dragon.head.m_20227_(0.5) + 0.5;
                        double d8 = this.dragon.head.m_20189_() - vec32.f_82481_ * 1.0;
                        double d9 = this.attackTarget.m_20185_() - d6;
                        double d10 = this.attackTarget.m_20227_(0.5) - d7;
                        double d11 = this.attackTarget.m_20189_() - d8;
                        if (!this.dragon.m_20067_()) {
                            this.dragon.m_9236_().m_5898_((Player)null, 1017, this.dragon.m_20183_(), 0);
                        }
                        MagmaBall dragonfireball = new MagmaBall(this.dragon.m_9236_(), (LivingEntity)this.dragon, d9, d10, d11);
                        dragonfireball.m_7678_(d6, d7, d8, 0.0f, 0.0f);
                        this.dragon.m_9236_().m_7967_((Entity)dragonfireball);
                        this.fireballCharge = 0;
                        if (this.currentPath != null) {
                            while (!this.currentPath.m_77392_()) {
                                this.currentPath.m_77374_();
                            }
                        }
                        this.dragon.getPhaseManager().setPhase(MagmaDragonPhase.HOLDING_PATTERN);
                    }
                } else if (this.fireballCharge > 0) {
                    --this.fireballCharge;
                }
            } else if (this.fireballCharge > 0) {
                --this.fireballCharge;
            }
        }
    }

    private void findNewTarget() {
        if (this.currentPath == null || this.currentPath.m_77392_()) {
            int i;
            int j = i = this.dragon.findClosestNode();
            if (this.dragon.m_217043_().m_188503_(8) == 0) {
                this.holdingPatternClockwise = !this.holdingPatternClockwise;
                j = i + 6;
            }
            j = this.holdingPatternClockwise ? ++j : --j;
            if (this.dragon.getCrystalsAlive() > 0) {
                if ((j %= 12) < 0) {
                    j += 12;
                }
            } else {
                j -= 12;
                j &= 7;
                j += 12;
            }
            this.currentPath = this.dragon.findPath(i, j, null);
            if (this.currentPath != null) {
                this.currentPath.m_77374_();
            }
        }
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null && !this.currentPath.m_77392_()) {
            double d1;
            BlockPos vec3i = this.currentPath.m_77400_();
            this.currentPath.m_77374_();
            double d0 = vec3i.m_123341_();
            double d2 = vec3i.m_123343_();
            while ((d1 = (double)((float)vec3i.m_123342_() + this.dragon.m_217043_().m_188501_() * 20.0f)) < (double)vec3i.m_123342_()) {
            }
            this.targetLocation = new Vec3(d0, d1, d2);
        }
    }

    @Override
    public void begin() {
        this.fireballCharge = 0;
        this.targetLocation = null;
        this.currentPath = null;
        this.attackTarget = null;
    }

    public void setTarget(LivingEntity p_31359_) {
        this.attackTarget = p_31359_;
        int i = this.dragon.findClosestNode();
        int j = this.dragon.findClosestNode(this.attackTarget.m_20185_(), this.attackTarget.m_20186_(), this.attackTarget.m_20189_());
        int k = this.attackTarget.m_146903_();
        int l = this.attackTarget.m_146907_();
        double d0 = (double)k - this.dragon.m_20185_();
        double d1 = (double)l - this.dragon.m_20189_();
        double d2 = Math.sqrt(d0 * d0 + d1 * d1);
        double d3 = Math.min((double)0.4f + d2 / 80.0 - 1.0, 10.0);
        int i1 = Mth.m_14107_((double)(this.attackTarget.m_20186_() + d3));
        Node node = new Node(k, i1, l);
        this.currentPath = this.dragon.findPath(i, j, node);
        if (this.currentPath != null) {
            this.currentPath.m_77374_();
            this.navigateToNextPathNode();
        }
    }

    @Override
    @Nullable
    public Vec3 getFlyTargetLocation() {
        return this.targetLocation;
    }

    public MagmaDragonPhase<MagmaDragonStrafePlayerPhase> getPhase() {
        return MagmaDragonPhase.STRAFE_PLAYER;
    }
}

