/*
 * Decompiled with CFR 0.152.
 */
package starcrop.magmadragoon;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import starcrop.magmadragoon.AbstractMagmaDragonPhaseInstance;
import starcrop.magmadragoon.MagmaDragon;
import starcrop.magmadragoon.MagmaDragonPhase;

public class MagmaDragonTakeoffPhase
extends AbstractMagmaDragonPhaseInstance {
    private boolean firstTick;
    @Nullable
    private Path currentPath;
    @Nullable
    private Vec3 targetLocation;

    public MagmaDragonTakeoffPhase(MagmaDragon p_31370_) {
        super(p_31370_);
    }

    @Override
    public void doServerTick() {
        if (!this.firstTick && this.currentPath != null) {
            BlockPos blockpos = this.dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.m_287210_((BlockPos)this.dragon.getFightOrigin()));
            if (!blockpos.m_203195_((Position)this.dragon.m_20182_(), 10.0)) {
                this.dragon.getPhaseManager().setPhase(MagmaDragonPhase.HOLDING_PATTERN);
            }
        } else {
            this.firstTick = false;
            this.findNewTarget();
        }
    }

    @Override
    public void begin() {
        this.firstTick = true;
        this.currentPath = null;
        this.targetLocation = null;
    }

    private void findNewTarget() {
        int i = this.dragon.findClosestNode();
        Vec3 vec3 = this.dragon.getHeadLookVector(1.0f);
        int j = this.dragon.findClosestNode(-vec3.f_82479_ * 40.0, 105.0, -vec3.f_82481_ * 40.0);
        if (this.dragon.getCrystalsAlive() > 0) {
            if ((j %= 12) < 0) {
                j += 12;
            }
        } else {
            j -= 12;
            j &= 7;
            j += 12;
        }
        this.currentPath = this.dragon.findPath(i, j, null);
        this.navigateToNextPathNode();
    }

    private void navigateToNextPathNode() {
        if (this.currentPath != null) {
            this.currentPath.m_77374_();
            if (!this.currentPath.m_77392_()) {
                double d0;
                BlockPos vec3i = this.currentPath.m_77400_();
                this.currentPath.m_77374_();
                while ((d0 = (double)((float)vec3i.m_123342_() + this.dragon.m_217043_().m_188501_() * 20.0f)) < (double)vec3i.m_123342_()) {
                }
                this.targetLocation = new Vec3((double)vec3i.m_123341_(), d0, (double)vec3i.m_123343_());
            }
        }
    }

    @Override
    @Nullable
    public Vec3 getFlyTargetLocation() {
        return this.targetLocation;
    }

    public MagmaDragonPhase<MagmaDragonTakeoffPhase> getPhase() {
        return MagmaDragonPhase.TAKEOFF;
    }
}

