/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.familiar_friends.entities.abstractcompanionclasses;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2616;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_8080;

public class MockLivingEntity
extends class_1297 {
    public final class_8080 limbAnimator = new class_8080();
    public float lastHandSwingProgress;
    public float handSwingProgress;
    public boolean handSwinging;
    public class_1268 preferredHand;
    public int handSwingTicks;
    protected float prevStepBobbingAmount;
    protected float stepBobbingAmount;
    public float bodyYaw;
    public float prevBodyYaw;
    public float headYaw;
    public float prevHeadYaw;
    protected float lookDirection;
    protected float prevLookDirection;
    protected int bodyTrackingIncrements;
    protected double serverX;
    protected double serverY;
    protected double serverZ;
    protected double serverYaw;
    protected double serverPitch;
    protected double serverHeadYaw;
    protected int headTrackingIncrements;

    public MockLivingEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5693() {
    }

    public void updateLimbs(boolean flutter) {
        float f = (float)class_3532.method_33825((double)(this.method_23317() - this.field_6014), (double)(flutter ? this.method_23318() - this.field_6036 : 0.0), (double)(this.method_23321() - this.field_5969));
        this.updateLimbs(f);
    }

    protected void updateLimbs(float posDelta) {
        float f = Math.min(posDelta * 4.0f, 1.0f);
        this.limbAnimator.method_48568(f, 0.4f);
    }

    public float getHandSwingProgress(float tickDelta) {
        float f = this.handSwingProgress - this.lastHandSwingProgress;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.lastHandSwingProgress + f * tickDelta;
    }

    public void method_5670() {
        super.method_5670();
        this.lastHandSwingProgress = this.handSwingProgress;
        this.prevLookDirection = this.lookDirection;
        this.prevBodyYaw = this.bodyYaw;
        this.prevHeadYaw = this.headYaw;
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.method_37908().method_16107().method_15407();
    }

    private int getHandSwingDuration() {
        return 6;
    }

    public void swingHand(class_1268 hand) {
        this.swingHand(hand, false);
    }

    public void swingHand(class_1268 hand, boolean fromServerPlayer) {
        if (!this.handSwinging || this.handSwingTicks >= this.getHandSwingDuration() / 2 || this.handSwingTicks < 0) {
            this.handSwingTicks = -1;
            this.handSwinging = true;
            this.preferredHand = hand;
            if (this.method_37908() instanceof class_3218) {
                class_2616 entityAnimationS2CPacket = new class_2616((class_1297)this, hand == class_1268.field_5808 ? 0 : 3);
                class_3215 serverChunkManager = ((class_3218)this.method_37908()).method_14178();
                if (fromServerPlayer) {
                    serverChunkManager.method_18751((class_1297)this, (class_2596)entityAnimationS2CPacket);
                } else {
                    serverChunkManager.method_18754((class_1297)this, (class_2596)entityAnimationS2CPacket);
                }
            }
        }
    }

    protected void tickHandSwing() {
        int i = this.getHandSwingDuration();
        if (this.handSwinging) {
            ++this.handSwingTicks;
            if (this.handSwingTicks >= i) {
                this.handSwingTicks = 0;
                this.handSwinging = false;
            }
        } else {
            this.handSwingTicks = 0;
        }
        this.handSwingProgress = (float)this.handSwingTicks / (float)i;
    }

    protected float turnHead(float bodyRotation, float headRotation) {
        boolean bl;
        float f = class_3532.method_15393((float)(bodyRotation - this.bodyYaw));
        this.bodyYaw += f * 0.3f;
        float g = class_3532.method_15393((float)(this.method_36454() - this.bodyYaw));
        float h = 50.0f;
        if (Math.abs(g) > h) {
            this.bodyYaw += g - (float)class_3532.method_17822((double)g) * h;
        }
        boolean bl2 = bl = g < -90.0f || g >= 90.0f;
        if (bl) {
            headRotation *= -1.0f;
        }
        return headRotation;
    }

    public float lerpYaw(float delta) {
        return class_3532.method_16439((float)delta, (float)this.prevBodyYaw, (float)this.bodyYaw);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_31481()) {
            this.tickMovement();
        }
        this.updateLimbs(false);
        double d = this.method_23317() - this.field_6014;
        double e = this.method_23321() - this.field_5969;
        float f = (float)(d * d + e * e);
        float g = this.bodyYaw;
        float h = 0.0f;
        this.prevStepBobbingAmount = this.stepBobbingAmount;
        float k = 0.0f;
        if (f > 0.0025000002f) {
            k = 1.0f;
            h = (float)Math.sqrt(f) * 3.0f;
            float l = (float)class_3532.method_15349((double)e, (double)d) * 57.295776f - 90.0f;
            float m = class_3532.method_15379((float)(class_3532.method_15393((float)this.method_36454()) - l));
            g = 95.0f < m && m < 265.0f ? l - 180.0f : l;
        }
        if (this.handSwingProgress > 0.0f) {
            g = this.method_36454();
        }
        this.method_37908().method_16107().method_15396("headTurn");
        h = this.turnHead(g, h);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("rangeChecks");
        while (this.method_36454() - this.field_5982 < -180.0f) {
            this.field_5982 -= 360.0f;
        }
        while (this.method_36454() - this.field_5982 >= 180.0f) {
            this.field_5982 += 360.0f;
        }
        while (this.bodyYaw - this.prevBodyYaw < -180.0f) {
            this.prevBodyYaw -= 360.0f;
        }
        while (this.bodyYaw - this.prevBodyYaw >= 180.0f) {
            this.prevBodyYaw += 360.0f;
        }
        while (this.method_36455() - this.field_6004 < -180.0f) {
            this.field_6004 -= 360.0f;
        }
        while (this.method_36455() - this.field_6004 >= 180.0f) {
            this.field_6004 += 360.0f;
        }
        while (this.headYaw - this.prevHeadYaw < -180.0f) {
            this.prevHeadYaw -= 360.0f;
        }
        while (this.headYaw - this.prevHeadYaw >= 180.0f) {
            this.prevHeadYaw += 360.0f;
        }
        this.method_37908().method_16107().method_15407();
        this.lookDirection += h;
    }

    protected void tickMovement() {
        if (this.method_5787()) {
            this.bodyTrackingIncrements = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.bodyTrackingIncrements > 0) {
            this.lerpPosAndRotation(this.bodyTrackingIncrements, this.serverX, this.serverY, this.serverZ, this.serverYaw, this.serverPitch);
            --this.bodyTrackingIncrements;
        } else if (!this.method_6034()) {
            this.method_18799(this.method_18798().method_1021(0.98));
        }
        if (this.headTrackingIncrements > 0) {
            this.lerpHeadYaw(this.headTrackingIncrements, this.serverHeadYaw);
            --this.headTrackingIncrements;
        }
        class_243 vec3d = this.method_18798();
        double d = vec3d.field_1352;
        double e = vec3d.field_1351;
        double f = vec3d.field_1350;
        if (Math.abs(vec3d.field_1352) < 0.003) {
            d = 0.0;
        }
        if (Math.abs(vec3d.field_1351) < 0.003) {
            e = 0.0;
        }
        if (Math.abs(vec3d.field_1350) < 0.003) {
            f = 0.0;
        }
        this.method_18800(d, e, f);
    }

    protected void lerpPosAndRotation(int step, double x, double y, double z, double yaw, double pitch) {
        double d = 1.0 / (double)step;
        double e = class_3532.method_16436((double)d, (double)this.method_23317(), (double)x);
        double f = class_3532.method_16436((double)d, (double)this.method_23318(), (double)y);
        double g = class_3532.method_16436((double)d, (double)this.method_23321(), (double)z);
        float h = class_3532.method_17821((float)((float)d), (float)this.method_36454(), (float)((float)yaw));
        float i = (float)class_3532.method_16436((double)d, (double)this.method_36455(), (double)pitch);
        this.method_5814(e, f, g);
        this.method_5710(h, i);
    }

    protected void lerpHeadYaw(int headTrackingIncrements, double serverHeadYaw) {
        this.headYaw = class_3532.method_17821((float)((float)(1.0 / (double)headTrackingIncrements)), (float)this.headYaw, (float)((float)serverHeadYaw));
    }

    protected void method_5749(class_2487 nbt) {
    }

    protected void method_5652(class_2487 nbt) {
    }

    public boolean method_5862() {
        return false;
    }
}

