/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.familiar_friends.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.deadlydiamond98.familiar_friends.entities.PlayerCompanion;
import net.deadlydiamond98.familiar_friends.events.CompanionClientTickEvent;
import net.deadlydiamond98.familiar_friends.util.CompanionGuiDrawMethods;
import net.deadlydiamond98.familiar_friends.util.TextFormatHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class CompanionIconButton
extends class_4185 {
    private static final class_2960 BOOK_TEXTURE = class_2960.method_43902((String)"familiar_friends", (String)"textures/gui/companion_book.png");
    private int renderX;
    private int renderY;
    private int originalY;
    private int entityIndex;
    public boolean locked;
    private PlayerCompanion companion;

    public CompanionIconButton(int x, int y, int width, int height, int i, boolean locked, PlayerCompanion companion, class_4185.class_4241 onPress) {
        super(x - width / 2, y - height / 2, width, height, class_5244.field_39003, onPress, field_40754);
        this.renderX = x;
        this.renderY = y;
        this.originalY = y;
        this.entityIndex = i;
        this.locked = locked;
        this.companion = companion;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)BOOK_TEXTURE);
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        int pressed = this.field_22763 ? (this.method_25367() ? 21 : 0) : 42;
        int centerX = this.renderX - this.method_25368() / 2;
        int centerY = this.renderY - this.method_25364() / 2;
        context.method_25293(BOOK_TEXTURE, centerX, centerY, this.method_25368(), this.method_25364(), 315.0f, (float)(203 + pressed), 20, 20, 512, 512);
        CompanionGuiDrawMethods.drawEntity(context, this.renderX, this.renderY + 6, 9, 0.0625f, this.companion, this.locked);
        if (this.locked) {
            RenderSystem.disableDepthTest();
            context.method_25293(BOOK_TEXTURE, centerX - 4, centerY - 4, (int)((double)this.method_25368() * 0.75), (int)((double)this.method_25364() * 0.75), 336.0f, 203.0f, 20, 20, 512, 512);
            RenderSystem.enableDepthTest();
        }
        this.renderTooltip(context, textRenderer, mouseX, mouseY);
    }

    public void renderTooltip(class_332 context, class_327 textRenderer, int mouseX, int mouseY) {
        if (this.method_49606()) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            int maxLen = 30;
            tooltip.add(this.companion.method_5477().method_27661());
            int authorColor = 0x797979;
            String author = this.companion.getAuthor().getString();
            while (author.length() > maxLen) {
                int splitIndex = TextFormatHelper.findCommaSplitIndex(author, maxLen);
                if (splitIndex == -1) {
                    splitIndex = TextFormatHelper.findSplitIndex(author, maxLen);
                }
                tooltip.add(class_2561.method_43470((String)author.substring(0, splitIndex).trim()).method_10862(class_2583.field_24360.method_36139(authorColor)));
                author = author.substring(splitIndex).trim();
            }
            tooltip.add(class_2561.method_43470((String)author).method_10862(class_2583.field_24360.method_36139(authorColor)));
            if (this.locked) {
                tooltip.add(this.companion.getCostLang(this.companion.getCostClient()));
            } else {
                tooltip.add(class_2561.method_43471((String)"gui.familiar_friends.unlocked").method_10862(class_2583.field_24360.method_36139(4689479)));
            }
            String description = this.companion.getDescription(CompanionClientTickEvent.getKeybinding()).getString();
            int descriptionColor = 16772212;
            while (description.length() > maxLen) {
                int split = TextFormatHelper.findSplitIndex(description, maxLen);
                tooltip.add(class_2561.method_43470((String)description.substring(0, split).trim()).method_10862(class_2583.field_24360.method_36139(descriptionColor)));
                description = description.substring(split).trim();
            }
            tooltip.add(class_2561.method_43470((String)description).method_10862(class_2583.field_24360.method_36139(descriptionColor)));
            context.method_51434(textRenderer, tooltip, mouseX, mouseY);
        }
    }

    public void scroll(int offset) {
        this.renderY = this.originalY + offset;
        this.method_46419(this.renderY - this.field_22759 / 2);
    }

    public int getYScrolled() {
        return this.renderY;
    }

    public int getEntityIndex() {
        return this.entityIndex;
    }
}

